/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.LanguageSettingsProvider;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.Jsr305Parser;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.config.TargetPlatformVersion;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProviderKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.utils.Jsr305State;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/IDELanguageSettingsProvider;", "Lorg/jetbrains/kotlin/analyzer/LanguageSettingsProvider;", "()V", "getExtraAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getTargetPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformVersion;", "idea-core"})
public final class IDELanguageSettingsProvider
implements LanguageSettingsProvider {
    public static final IDELanguageSettingsProvider INSTANCE;

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings(@NotNull ModuleInfo moduleInfo, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ModuleInfo moduleInfo2 = moduleInfo;
        return moduleInfo2 instanceof ModuleSourceInfo ? PlatformKt.getLanguageVersionSettings(((ModuleSourceInfo)moduleInfo).getModule()) : (moduleInfo2 instanceof LibraryInfo ? PlatformKt.getLanguageVersionSettings$default(project, null, this.getExtraAnalysisFlags(project), 1, null) : (moduleInfo2 instanceof ScriptModuleInfo ? IDELanguageSettingsProviderKt.access$getVersionLanguageSettingsForScripts(project, ((ScriptModuleInfo)moduleInfo).getScriptDefinition()) : (moduleInfo2 instanceof ScriptDependenciesInfo.ForFile ? IDELanguageSettingsProviderKt.access$getVersionLanguageSettingsForScripts(project, ((ScriptDependenciesInfo.ForFile)moduleInfo).getScriptDefinition()) : (moduleInfo2 instanceof PlatformModuleInfo ? PlatformKt.getLanguageVersionSettings(((PlatformModuleInfo)moduleInfo).getPlatformModule$idea_core().getModule()) : PlatformKt.getLanguageVersionSettings$default(project, null, null, 3, null)))));
    }

    private final Map<AnalysisFlag<?>, Object> getExtraAnalysisFlags(Project project) {
        Map map2 = new LinkedHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            K2JVMCompilerArguments compilerArguments2;
            KotlinFacetSettings settings2;
            KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
            Module module2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (kotlinFacetSettingsProvider.getSettings(module2) == null) {
                continue;
            }
            CommonCompilerArguments commonCompilerArguments = settings2.getMergedCompilerArguments();
            if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                commonCompilerArguments = null;
            }
            if ((K2JVMCompilerArguments)commonCompilerArguments == null) {
                continue;
            }
            Jsr305State jsr305State = new Jsr305Parser(MessageCollector.Companion.getNONE()).parse(compilerArguments2.getJsr305(), compilerArguments2.getSupportCompatqualCheckerFrameworkAnnotations());
            map2.put(AnalysisFlag.Flags.getJsr305(), jsr305State);
        }
        return map2;
    }

    @Override
    @NotNull
    public TargetPlatformVersion getTargetPlatform(@NotNull ModuleInfo moduleInfo) {
        TargetPlatformKind<?> targetPlatformKind;
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        ModuleInfo moduleInfo2 = moduleInfo;
        if (!(moduleInfo2 instanceof ModuleSourceInfo)) {
            moduleInfo2 = null;
        }
        if ((targetPlatformKind = (ModuleSourceInfo)moduleInfo2) == null || (targetPlatformKind = targetPlatformKind.getModule()) == null || (targetPlatformKind = PlatformKt.getTargetPlatform((Module)targetPlatformKind)) == null || (targetPlatformKind = targetPlatformKind.getVersion()) == null) {
            targetPlatformKind = TargetPlatformVersion.NoVersion.INSTANCE;
        }
        return targetPlatformKind;
    }

    private IDELanguageSettingsProvider() {
    }

    static {
        IDELanguageSettingsProvider iDELanguageSettingsProvider;
        INSTANCE = iDELanguageSettingsProvider = new IDELanguageSettingsProvider();
    }
}

