/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.CacheUtilKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.caches.project.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n*\u00020\rH\u0000\u001a\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n*\u00020\r\u001a\u0010\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\n*\u00020\r\u001a\f\u0010\u001d\u001a\u00020\u000f*\u00020\rH\u0002\u001a\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\f\u0010!\u001a\u00020\u000f*\u00020\rH\u0002\u001a\f\u0010\"\u001a\u00020\u000f*\u00020\u000bH\u0000\u001a\f\u0010#\u001a\u00020\u000f*\u00020\u0019H\u0000\u001a\f\u0010$\u001a\u0004\u0018\u00010%*\u00020\r\u001a\u0012\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\n*\u00020\u000b\u001a\f\u0010'\u001a\u0004\u0018\u00010(*\u00020\r\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "ideaModelDependencies", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "forProduction", "", "platform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "orderEntryToModuleInfo", "project", "Lcom/intellij/openapi/project/Project;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "acceptAsDependency", "correspondingModuleInfos", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "findImplementedModuleNames", "", "findImplementedModules", "hasProductionRoots", "hasRootsOfType", "sourceRootType", "Lorg/jetbrains/jps/model/java/JavaSourceRootType;", "hasTestRoots", "isLibraryClasses", "isTests", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleProductionSourceInfo;", "projectSourceModules", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleTestSourceInfo;", "idea-core"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(IdeaModuleInfo.class);
    @NotNull
    private static final ModuleDescriptor.Capability<ModuleOrigin> OriginCapability = new ModuleDescriptor.Capability("MODULE_ORIGIN");

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean forProduction) {
        List list2;
        Function1<Module, List<? extends ModuleSourceInfo>> toInfos$ = new Function1<Module, List<? extends ModuleSourceInfo>>(forProduction){
            final /* synthetic */ boolean $forProduction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $receiver) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable iterable = $receiver$iv = (Iterable)IdeaModuleInfosKt.correspondingModuleInfos($receiver);
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    if (!(!this.$forProduction || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$forProduction = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module = orderEntry.getOwnerModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"orderEntry.getOwnerModule()");
            list2 = toInfos$.invoke(module);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Module module2 = module;
            if (forProduction && orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency()) {
                Module module3 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
                list2 = CollectionsKt.listOfNotNull((Object)IdeaModuleInfosKt.testSourceInfo(module3));
            } else {
                Module module4 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
                list2 = toInfos$.invoke(module4);
            }
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2;
            Library library3 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library3 == null) {
                return CollectionsKt.emptyList();
            }
            Library library4 = library2 = library3;
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            list2 = CollectionsKt.listOfNotNull((Object)new LibraryInfo(project, library4));
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return CollectionsKt.emptyList();
            }
            Sdk sdk2 = sdk;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean acceptAsDependency(@NotNull OrderEntry $receiver, boolean forProduction) {
        if (!($receiver instanceof ExportableOrderEntry)) return true;
        if (!forProduction) return true;
        if ($receiver instanceof ModuleOrderEntryImpl) {
            if (((ModuleOrderEntryImpl)$receiver).isProductionOnTestDependency()) return true;
        }
        DependencyScope dependencyScope = ((ExportableOrderEntry)$receiver).getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyScope, (String)"scope");
        if (!dependencyScope.isForProductionCompile()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IdeaModuleInfo> ideaModelDependencies(Module module, boolean forProduction, TargetPlatform platform) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator dependencyEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        if (forProduction && Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(module), (Object)BuildSystemType.JPS.INSTANCE)) {
            dependencyEnumerator.productionOnly();
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(forProduction, result2, module){
            final /* synthetic */ boolean $forProduction;
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;

            public final boolean process(OrderEntry orderEntry) {
                OrderEntry orderEntry2 = orderEntry;
                Intrinsics.checkExpressionValueIsNotNull((Object)orderEntry2, (String)"orderEntry");
                if (IdeaModuleInfosKt.access$acceptAsDependency(orderEntry2, this.$forProduction)) {
                    Project project = this.$module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                    this.$result.addAll(IdeaModuleInfosKt.access$orderEntryToModuleInfo(project, orderEntry, this.$forProduction));
                }
                return true;
            }
            {
                this.$forProduction = bl;
                this.$result = linkedHashSet;
                this.$module = module;
            }
        });
        Iterable iterable = $receiver$iv = (Iterable)result2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IdeaModuleInfo it = (IdeaModuleInfo)element$iv$iv;
            if (it instanceof LibraryInfo && Intrinsics.areEqual((Object)((LibraryInfo)it).getPlatform(), (Object)platform) ^ true) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<String> findImplementedModuleNames(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FacetManager facetManager = FacetManager.getInstance((Module)$receiver);
        FacetTypeId<KotlinFacet> facetTypeId = KotlinFacetType.Companion.getTYPE_ID();
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType("kotlin-language");
        if (facetType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)facetType, (String)"FacetTypeRegistry.getIns\u2026nce().findFacetType(ID)!!");
        KotlinFacet facet = (KotlinFacet)facetManager.findFacet(facetTypeId, facetType.getDefaultFacetName());
        Object object = facet;
        if (object == null || (object = (KotlinFacetConfiguration)object.getConfiguration()) == null || (object = object.getSettings()) == null || (object = ((KotlinFacetSettings)object).getImplementedModuleNames()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<Module> findImplementedModules(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (List)CacheUtilKt.cached($receiver, (CachedValueProvider)new CachedValueProvider<List<? extends Module>>($receiver){
            final /* synthetic */ Module receiver$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CachedValueProvider.Result<List<Module>> compute() {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(this.receiver$0.getProject());
                Iterable iterable = $receiver$iv = (Iterable)IdeaModuleInfosKt.findImplementedModuleNames(this.receiver$0);
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Module module;
                    T element$iv$iv = element$iv$iv$iv;
                    String it = (String)element$iv$iv;
                    if (modelsProvider.findIdeModule(it) == null) continue;
                    Module it$iv$iv = module;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this.receiver$0.getProject())};
                List list3 = list2;
                return new CachedValueProvider.Result((Object)list3, objectArray);
            }
            {
                this.receiver$0 = module;
            }
        });
    }

    public static final boolean isTests(@NotNull ModuleSourceInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ModuleTestSourceInfo;
    }

    @Nullable
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return IdeaModuleInfosKt.hasProductionRoots($receiver) ? new ModuleProductionSourceInfo($receiver) : null;
    }

    @Nullable
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return IdeaModuleInfosKt.hasTestRoots($receiver) ? new ModuleTestSourceInfo($receiver) : null;
    }

    @NotNull
    public static final List<ModuleSourceInfo> correspondingModuleInfos(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ModuleSourceInfoWithExpectedBy[]{IdeaModuleInfosKt.testSourceInfo($receiver), IdeaModuleInfosKt.productionSourceInfo($receiver)}));
    }

    private static final boolean hasProductionRoots(@NotNull Module $receiver) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($receiver, javaSourceRootType);
    }

    private static final boolean hasTestRoots(@NotNull Module $receiver) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($receiver, javaSourceRootType);
    }

    private static final boolean hasRootsOfType(@NotNull Module $receiver, JavaSourceRootType sourceRootType) {
        boolean bl;
        block1: {
            ContentEntry[] contentEntryArray = ProjectRootsUtilKt.getRootManager($receiver).getContentEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntryArray, (String)"rootManager.contentEntries");
            ContentEntry[] $receiver$iv = contentEntryArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                ContentEntry element$iv;
                ContentEntry it = element$iv = $receiver$iv[i];
                List list2 = it.getSourceFolders((JpsModuleSourceRootType)sourceRootType);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"it.getSourceFolders(sourceRootType)");
                Collection collection = list2;
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof SdkInfo || $receiver instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleDescriptor.Capability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    @Nullable
    public static final List<ModuleSourceInfo> projectSourceModules(@NotNull IdeaModuleInfo $receiver) {
        ModuleSourceInfo moduleSourceInfo;
        ModuleSourceInfo p1;
        List<ModuleSourceInfo> list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IdeaModuleInfo ideaModuleInfo = $receiver;
        if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
            ideaModuleInfo = null;
        }
        if ((list2 = (ModuleSourceInfo)ideaModuleInfo) == null || (list2 = CollectionsKt.listOf((Object)(p1 = (moduleSourceInfo = list2)))) == null) {
            IdeaModuleInfo ideaModuleInfo2 = $receiver;
            if (!(ideaModuleInfo2 instanceof PlatformModuleInfo)) {
                ideaModuleInfo2 = null;
            }
            PlatformModuleInfo platformModuleInfo = (PlatformModuleInfo)ideaModuleInfo2;
            list2 = platformModuleInfo != null ? platformModuleInfo.getContainedModules() : null;
        }
        return list2;
    }

    @NotNull
    public static final /* synthetic */ List access$ideaModelDependencies(@NotNull Module module, boolean forProduction, @NotNull TargetPlatform platform) {
        return IdeaModuleInfosKt.ideaModelDependencies(module, forProduction, platform);
    }

    public static final /* synthetic */ boolean access$acceptAsDependency(@NotNull OrderEntry $receiver, boolean forProduction) {
        return IdeaModuleInfosKt.acceptAsDependency($receiver, forProduction);
    }

    @NotNull
    public static final /* synthetic */ List access$orderEntryToModuleInfo(@NotNull Project project, @NotNull OrderEntry orderEntry, boolean forProduction) {
        return IdeaModuleInfosKt.orderEntryToModuleInfo(project, orderEntry, forProduction);
    }
}

