/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\r\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u0018J*\u0010\u001b\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J2\u0010\u001c\u001a\u00020\u001d*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J*\u0010\u001f\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J*\u0010 \u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0002R0\u0010\u0005\u001a$\u0012\u0004\u0012\u00020\u0007\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "implicitPackageCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackageData;", "analyzeImplicitPackagePrefixes", "sourceRoot", "checkDeletedFileInSourceRoot", "", "file", "checkNewFileInSourceRoot", "clear", "clear$idea_core", "getPrefix", "update", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "update$idea_core", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "addFile", "addPsiFile", "", "psiFile", "removeFile", "updateFile", "idea-core"})
public final class ImplicitPackagePrefixCache {
    private final ConcurrentHashMap<VirtualFile, Map<FqName, List<VirtualFile>>> implicitPackageCache;
    private final Project project;

    @NotNull
    public final FqName getPrefix(@NotNull VirtualFile sourceRoot) {
        Map implicitPackageMap;
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull((Object)sourceRoot, (String)"sourceRoot");
        ConcurrentMap $receiver$iv = this.implicitPackageCache;
        Object object = $receiver$iv.get(sourceRoot);
        if (object == null) {
            Map<FqName, List<VirtualFile>> map2 = this.analyzeImplicitPackagePrefixes(sourceRoot);
            Map<FqName, List<VirtualFile>> default$iv = map2;
            object = $receiver$iv.putIfAbsent(sourceRoot, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((fqName2 = (FqName)CollectionsKt.singleOrNull((Iterable)(implicitPackageMap = (Map)object).keySet())) == null) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.ROOT");
        }
        return fqName2;
    }

    public final void clear$idea_core() {
        this.implicitPackageCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FqName, List<VirtualFile>> analyzeImplicitPackagePrefixes(VirtualFile sourceRoot) {
        void $receiver$iv$iv;
        Map result2 = new LinkedHashMap();
        VirtualFile[] virtualFileArray = sourceRoot.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"sourceRoot.children");
        VirtualFile[] $receiver$iv = virtualFileArray;
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it;
            void v1 = it = (element$iv$iv = $receiver$iv$iv[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!Intrinsics.areEqual((Object)v1.getFileType(), (Object)((Object)KotlinFileType.INSTANCE))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles2 = (List)destination$iv$iv;
        object = ktFiles2.iterator();
        while (object.hasNext()) {
            VirtualFile ktFile;
            VirtualFile virtualFile2 = ktFile = (VirtualFile)object.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile");
            this.addFile(result2, virtualFile2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(@NotNull Map<FqName, List<VirtualFile>> $receiver, VirtualFile ktFile) {
        synchronized ($receiver) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(ktFile);
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile2 = (KtFile)psiFile;
            if (ktFile2 == null) {
                return;
            }
            KtFile psiFile2 = ktFile2;
            boolean bl = this.addPsiFile($receiver, psiFile2, ktFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addPsiFile(@NotNull Map<FqName, List<VirtualFile>> $receiver, KtFile psiFile, VirtualFile ktFile) {
        Object object;
        void $receiver$iv;
        Map<FqName, List<VirtualFile>> map2 = $receiver;
        FqName key$iv = psiFile.getPackageFqName();
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            List answer$iv = new ArrayList();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((List)object).add(ktFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFile(@NotNull Map<FqName, List<VirtualFile>> $receiver, VirtualFile file2) {
        synchronized ($receiver) {
            Map<FqName, List<VirtualFile>> map2 = $receiver;
            Unit unit = map2.entrySet().iterator();
            while (unit.hasNext()) {
                Map.Entry<FqName, List<VirtualFile>> entry;
                Map.Entry<FqName, List<VirtualFile>> entry2 = entry = unit.next();
                FqName key = entry2.getKey();
                entry2 = entry;
                List<VirtualFile> value2 = entry2.getValue();
                if (!value2.remove(file2)) continue;
                if (!value2.isEmpty()) break;
                $receiver.remove(key);
                break;
            }
            unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFile(@NotNull Map<FqName, List<VirtualFile>> $receiver, KtFile file2) {
        synchronized ($receiver) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            this.removeFile($receiver, virtualFile2);
            VirtualFile virtualFile3 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file.virtualFile");
            boolean bl = this.addPsiFile($receiver, file2, virtualFile3);
        }
    }

    public final void update$idea_core(@NotNull VFileEvent event) {
        block3: {
            VFileEvent vFileEvent;
            block5: {
                VirtualFile newParent;
                block4: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        vFileEvent = event;
                        if (!(vFileEvent instanceof VFileCreateEvent)) break block2;
                        this.checkNewFileInSourceRoot(((VFileCreateEvent)event).getFile());
                        break block3;
                    }
                    if (!(vFileEvent instanceof VFileDeleteEvent)) break block4;
                    this.checkDeletedFileInSourceRoot(((VFileDeleteEvent)event).getFile());
                    break block3;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) break block5;
                VirtualFile virtualFile2 = newParent = ((VFileCopyEvent)event).getNewParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"newParent");
                if (!virtualFile2.isValid()) break block3;
                this.checkNewFileInSourceRoot(newParent.findChild(((VFileCopyEvent)event).getNewChildName()));
                break block3;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) break block3;
            this.checkNewFileInSourceRoot(((VFileMoveEvent)event).getFile());
            VirtualFile virtualFile3 = ((VFileMoveEvent)event).getOldParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"event.oldParent");
            if (Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(virtualFile3, this.project), (Object)((VFileMoveEvent)event).getOldParent())) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(((VFileMoveEvent)event).getOldParent());
                if (map2 != null) {
                    VirtualFile virtualFile4 = ((VFileMoveEvent)event).getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"event.file");
                    this.removeFile(map2, virtualFile4);
                }
            }
        }
    }

    private final void checkNewFileInSourceRoot(VirtualFile file2) {
        block2: {
            if (file2 == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(file2, this.project), (Object)file2.getParent())) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(file2.getParent());
            if (map2 != null) {
                this.addFile(map2, file2);
            }
        }
    }

    private final void checkDeletedFileInSourceRoot(VirtualFile file2) {
        block2: {
            VirtualFile directory;
            VirtualFile virtualFile2 = file2;
            Object object = directory = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (directory == null || !directory.isValid()) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(directory, this.project), (Object)directory)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(directory);
            if (map2 != null) {
                this.removeFile(map2, file2);
            }
        }
    }

    public final void update$idea_core(@NotNull KtFile ktFile) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            VirtualFile virtualFile2 = ktFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile.virtualFile");
            VirtualFile parent2 = virtualFile2.getParent();
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)ktFile), (Object)parent2)) break block1;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(parent2);
            if (map2 != null) {
                this.updateFile(map2, ktFile);
            }
        }
    }

    public ImplicitPackagePrefixCache(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.implicitPackageCache = new ConcurrentHashMap();
    }
}

