/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.psi.KtElement;

public final class KotlinDescriptorIconProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider");

    private KotlinDescriptorIconProvider() {
    }

    @Nullable
    public static Icon getIcon(@NotNull DeclarationDescriptor descriptor2, @Nullable PsiElement declaration2, @Iconable.IconFlags int flags) {
        if (declaration2 != null && !(declaration2 instanceof KtElement)) {
            return declaration2.getIcon(flags);
        }
        Icon result2 = KotlinDescriptorIconProvider.getBaseIcon(descriptor2);
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(result2, 0);
            rowIcon.setIcon(KotlinDescriptorIconProvider.getVisibilityIcon(descriptor2), 1);
            result2 = rowIcon;
        }
        return result2;
    }

    private static Icon getVisibilityIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptorWithVisibility descriptorWithVisibility = (DeclarationDescriptorWithVisibility)descriptor2;
            Visibility visibility = descriptorWithVisibility.getVisibility().normalize();
            if (visibility == Visibilities.PUBLIC) {
                return PlatformIcons.PUBLIC_ICON;
            }
            if (visibility == Visibilities.PROTECTED) {
                return PlatformIcons.PROTECTED_ICON;
            }
            if (Visibilities.isPrivate(visibility)) {
                return PlatformIcons.PRIVATE_ICON;
            }
            if (visibility == Visibilities.INTERNAL) {
                return PlatformIcons.PACKAGE_LOCAL_ICON;
            }
        }
        return null;
    }

    private static Modality getModalitySafe(@NotNull MemberDescriptor descriptor2) {
        try {
            return descriptor2.getModality();
        }
        catch (InvalidModuleException ex) {
            return Modality.FINAL;
        }
    }

    private static Icon getBaseIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return PlatformIcons.PACKAGE_ICON;
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)descriptor2;
            if (functionDescriptor2.getExtensionReceiverParameter() != null) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe(functionDescriptor2) ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : KotlinIcons.EXTENSION_FUNCTION;
            }
            if (descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe(functionDescriptor2) ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
            }
            return KotlinIcons.FUNCTION;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            switch (classDescriptor.getKind()) {
                case INTERFACE: {
                    return KotlinIcons.INTERFACE;
                }
                case ENUM_CLASS: {
                    return KotlinIcons.ENUM;
                }
                case ENUM_ENTRY: {
                    return KotlinIcons.ENUM;
                }
                case ANNOTATION_CLASS: {
                    return KotlinIcons.ANNOTATION;
                }
                case OBJECT: {
                    return KotlinIcons.OBJECT;
                }
                case CLASS: {
                    return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe(classDescriptor) ? KotlinIcons.ABSTRACT_CLASS : KotlinIcons.CLASS;
                }
            }
            LOG.warn("No icon for descriptor: " + descriptor2);
            return null;
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return KotlinIcons.PARAMETER;
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? KotlinIcons.VAR : KotlinIcons.VAL;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return PlatformIcons.CLASS_ICON;
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            return KotlinIcons.TYPE_ALIAS;
        }
        LOG.warn("No icon for descriptor: " + descriptor2);
        return null;
    }
}

