/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplColors;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.ReplOutputProcessor$WhenMappings;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.console.gutter.ConsoleErrorRenderer;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020#J\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020#J$\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020#J\u000e\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020#J\u000e\u00102\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020#J\u0018\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u000206H\u0002J\u001c\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018082\u0006\u00109\u001a\u00020#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "historyDocument", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "historyMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "project", "Lcom/intellij/openapi/project/Project;", "getAttributesForSeverity", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "infoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "insightColors", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "start", "", "end", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "highlightCompilerErrors", "", "compilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "printBuildInfoWarningIfNeeded", "printHelp", "help", "", "printInitialPrompt", "command", "printInternalErrorMessage", "internalErrorText", "printOutput", "output", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "iconWithTooltip", "Lorg/jetbrains/kotlin/console/gutter/IconWithTooltip;", "printResultWithGutterIcon", "result", "printRuntimeError", "errorText", "printUserOutput", "printWarningMessage", "message", "isAddHyperlink", "", "textOffsets", "Lkotlin/Pair;", "text", "idea"})
public final class ReplOutputProcessor {
    private final Project project;
    private final LanguageConsoleImpl consoleView;
    private final EditorEx historyEditor;
    private final DocumentEx historyDocument;
    private final MarkupModelEx historyMarkup;
    private final KotlinConsoleRunner runner;

    private final Pair<Integer, Integer> textOffsets(String text2) {
        this.consoleView.flushDeferredText();
        DocumentEx documentEx = this.historyDocument;
        Intrinsics.checkExpressionValueIsNotNull((Object)documentEx, (String)"historyDocument");
        int oldLen = documentEx.getTextLength();
        int newLen = oldLen + text2.length();
        return new Pair((Object)oldLen, (Object)newLen);
    }

    /*
     * WARNING - void declaration
     */
    private final void printOutput(String output, ConsoleViewContentType contentType, IconWithTooltip iconWithTooltip) {
        void startOffset;
        RangeHighlighter rangeHighlighter = this.textOffsets(output);
        int n = ((Number)rangeHighlighter.component1()).intValue();
        int endOffset = ((Number)rangeHighlighter.component2()).intValue();
        this.consoleView.print(output, contentType);
        this.consoleView.flushDeferredText();
        if (iconWithTooltip == null) {
            return;
        }
        RangeHighlighter $receiver = rangeHighlighter = this.historyMarkup.addRangeHighlighter((int)startOffset, endOffset, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        $receiver.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(iconWithTooltip));
    }

    static /* bridge */ /* synthetic */ void printOutput$default(ReplOutputProcessor replOutputProcessor, String string, ConsoleViewContentType consoleViewContentType, IconWithTooltip iconWithTooltip, int n, Object object) {
        if ((n & 4) != 0) {
            iconWithTooltip = null;
        }
        replOutputProcessor.printOutput(string, consoleViewContentType, iconWithTooltip);
    }

    private final void printWarningMessage(String message2, boolean isAddHyperlink) {
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, message2, isAddHyperlink){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ boolean $isAddHyperlink;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.printOutput$default(this.this$0, "\n", consoleViewContentType, null, 4, null);
                ReplOutputProcessor.access$printOutput(this.this$0, this.$message, ReplColors.INSTANCE.getWARNING_INFO_CONTENT_TYPE(), ReplIcons.INSTANCE.getBUILD_WARNING_INDICATOR());
                if (this.$isAddHyperlink) {
                    ReplOutputProcessor.access$getConsoleView$p(this.this$0).printHyperlink("Build module '" + ReplOutputProcessor.access$getRunner$p(this.this$0).getModule().getName() + "' and restart", new HyperlinkInfo(this){
                        final /* synthetic */ printWarningMessage.1 this$0;

                        public final void navigate(Project it) {
                            ReplOutputProcessor.access$getRunner$p(this.this$0.this$0).getCompilerHelper().compileModule();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.printOutput$default(this.this$0, "\n\n", consoleViewContentType2, null, 4, null);
            }
            {
                this.this$0 = replOutputProcessor;
                this.$message = string;
                this.$isAddHyperlink = bl;
            }
        });
    }

    public final void printBuildInfoWarningIfNeeded() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        if (this.runner.getPreviousCompilationFailed$idea()) {
            this.printWarningMessage("There were compilation errors in module " + this.runner.getModule().getName(), false);
            return;
        }
        if (this.runner.getCompilerHelper().moduleIsUpToDate()) {
            return;
        }
        String compilerWarningMessage = "You\u2019re running the REPL with outdated classes: ";
        this.printWarningMessage(compilerWarningMessage, true);
    }

    public final void printInitialPrompt(@NotNull String command2) {
        Intrinsics.checkParameterIsNotNull((Object)command2, (String)"command");
        this.consoleView.print(command2, ReplColors.INSTANCE.getINITIAL_PROMPT_CONTENT_TYPE());
    }

    public final void printHelp(@NotNull String help) {
        Intrinsics.checkParameterIsNotNull((Object)help, (String)"help");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, help){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $help;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$help, consoleViewContentType, ReplIcons.INSTANCE.getSYSTEM_HELP());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$help = string;
            }
        });
    }

    public final void printUserOutput(@NotNull String command2) {
        Intrinsics.checkParameterIsNotNull((Object)command2, (String)"command");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, command2){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $command;

            public final void run() {
                ReplOutputProcessor.access$getConsoleView$p(this.this$0).print(this.$command, ReplColors.INSTANCE.getUSER_OUTPUT_CONTENT_TYPE());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$command = string;
            }
        });
    }

    public final void printResultWithGutterIcon(@NotNull String result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, result2){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $result;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$result, consoleViewContentType, ReplIcons.INSTANCE.getRESULT());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$result = string;
            }
        });
    }

    public final void highlightCompilerErrors(@NotNull List<SeverityDetails> compilerMessages) {
        Intrinsics.checkParameterIsNotNull(compilerMessages, (String)"compilerMessages");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, compilerMessages){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ List $compilerMessages;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Object answer$iv$iv$iv;
                Object message2;
                Iterable $receiver$iv$iv;
                RangeHighlighter element$iv2;
                int lastCommandStartLine;
                int lastCommandStartOffset;
                block11: {
                    CommandHistory commandHistory = ReplOutputProcessor.access$getRunner$p(this.this$0).getCommandHistory();
                    CommandHistory.Entry entry = commandHistory.lastUnprocessedEntry();
                    if (entry == null) {
                        RunExecuteActionsKt.logError(ReplOutputProcessor.class, "Processed more commands than were sent. Sent commands: " + commandHistory.getSize() + ". Processed: " + commandHistory.getProcessedEntriesCount());
                        return;
                    }
                    CommandHistory.Entry lastUnprocessedHistoryEntry = entry;
                    lastCommandStartOffset = lastUnprocessedHistoryEntry.getRangeInHistoryDocument().getStartOffset();
                    lastCommandStartLine = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0).getLineNumber(lastCommandStartOffset);
                    MarkupModelEx markupModelEx = ReplOutputProcessor.access$getHistoryMarkup$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)markupModelEx, (String)"historyMarkup");
                    RangeHighlighter[] rangeHighlighterArray = markupModelEx.getAllHighlighters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighterArray, (String)"historyMarkup.allHighlighters");
                    for (RangeHighlighter element$iv2 : rangeHighlighterArray) {
                        RangeHighlighter it = element$iv2;
                        DocumentEx documentEx = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0);
                        RangeHighlighter rangeHighlighter = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter, (String)"it");
                        if (!(documentEx.getLineNumber(rangeHighlighter.getStartOffset()) == lastCommandStartLine && it.getGutterIconRenderer() != null)) {
                            continue;
                        }
                        break block11;
                    }
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                RangeHighlighter historyCommandRunIndicator = element$iv2;
                Iterable $receiver$iv = this.$compilerMessages;
                Iterable iterable = $receiver$iv;
                Object destination$iv$iv = new ArrayList<E>();
                for (E element$iv$iv : $receiver$iv$iv) {
                    SeverityDetails it = (SeverityDetails)element$iv$iv;
                    if (!(it.getSeverity() == Severity.ERROR || it.getSeverity() == Severity.WARNING)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                for (E element$iv$iv : $receiver$iv$iv) {
                    Object object;
                    message2 = (SeverityDetails)element$iv$iv;
                    int cmdStart = lastCommandStartOffset + ((SeverityDetails)message2).getRange().getStartOffset();
                    EditorEx editorEx = ReplOutputProcessor.access$getHistoryEditor$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"historyEditor");
                    Integer key$iv$iv = editorEx.getDocument().getLineNumber(cmdStart);
                    Object $receiver$iv$iv$iv = destination$iv$iv;
                    V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        answer$iv$iv$iv = new ArrayList<E>();
                        $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = destination$iv$iv.values();
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (E item$iv$iv : $receiver$iv$iv) {
                    void $receiver$iv$iv2;
                    void messages;
                    Iterable $receiver$iv2;
                    message2 = (List)item$iv$iv;
                    Object object = destination$iv$iv;
                    Iterable $i$a$2$groupBy = $receiver$iv2 = (Iterable)messages;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (T item$iv$iv2 : $receiver$iv$iv2) {
                        void message3;
                        answer$iv$iv$iv = (SeverityDetails)item$iv$iv2;
                        Collection collection = destination$iv$iv2;
                        int cmdStart = lastCommandStartOffset + message3.getRange().getStartOffset();
                        int cmdEnd = lastCommandStartOffset + Math.max(message3.getRange().getEndOffset(), message3.getRange().getStartOffset() + 1);
                        TextAttributes textAttributes = ReplOutputProcessor.access$getAttributesForSeverity(this.this$0, cmdStart, cmdEnd, message3.getSeverity());
                        RangeHighlighter rangeHighlighter = ReplOutputProcessor.access$getHistoryMarkup$p(this.this$0).addRangeHighlighter(cmdStart, cmdEnd, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
                        collection.add(rangeHighlighter);
                    }
                    List highlighters = (List)destination$iv$iv2;
                    Pair pair2 = new Pair(CollectionsKt.first((List)highlighters), (Object)messages);
                    object.add(pair2);
                }
                List highlighterAndMessagesByLine = (List)destination$iv$iv;
                for (Pair pair3 : highlighterAndMessagesByLine) {
                    RangeHighlighter highlighter = (RangeHighlighter)pair3.component1();
                    List messages = (List)pair3.component2();
                    DocumentEx documentEx = ReplOutputProcessor.access$getHistoryDocument$p(this.this$0);
                    RangeHighlighter rangeHighlighter = highlighter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter, (String)"highlighter");
                    if (documentEx.getLineNumber(rangeHighlighter.getStartOffset()) == lastCommandStartLine) {
                        RangeHighlighter rangeHighlighter2 = historyCommandRunIndicator;
                        Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter2, (String)"historyCommandRunIndicator");
                        rangeHighlighter2.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
                        continue;
                    }
                    highlighter.setGutterIconRenderer((GutterIconRenderer)new ConsoleErrorRenderer(messages));
                }
            }
            {
                this.this$0 = replOutputProcessor;
                this.$compilerMessages = list2;
            }
        });
    }

    public final void printRuntimeError(@NotNull String errorText2) {
        Intrinsics.checkParameterIsNotNull((Object)errorText2, (String)"errorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, errorText2){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $errorText;

            public final void run() {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, this.$errorText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
            }
            {
                this.this$0 = replOutputProcessor;
                this.$errorText = string;
            }
        });
    }

    public final void printInternalErrorMessage(@NotNull String internalErrorText) {
        Intrinsics.checkParameterIsNotNull((Object)internalErrorText, (String)"internalErrorText");
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, internalErrorText){
            final /* synthetic */ ReplOutputProcessor this$0;
            final /* synthetic */ String $internalErrorText;

            public final void run() {
                String promptText = "Internal error occurred. Please, send report to developers.\n";
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                ReplOutputProcessor.access$printOutput(this.this$0, promptText, consoleViewContentType, ReplIcons.INSTANCE.getRUNTIME_EXCEPTION());
                RunExecuteActionsKt.logError(this.this$0.getClass(), this.$internalErrorText);
            }
            {
                this.this$0 = replOutputProcessor;
                this.$internalErrorText = string;
            }
        });
    }

    private final TextAttributes getAttributesForSeverity(int start, int end, Severity severity) {
        TextAttributes textAttributes;
        switch (ReplOutputProcessor$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType, (String)"HighlightInfoType.ERROR");
                HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"HighlightSeverity.ERROR");
                TextAttributesKey textAttributesKey = CodeInsightColors.ERRORS_ATTRIBUTES;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"CodeInsightColors.ERRORS_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            case 2: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WARNING;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType, (String)"HighlightInfoType.WARNING");
                HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"HighlightSeverity.WARNING");
                TextAttributesKey textAttributesKey = CodeInsightColors.WARNINGS_ATTRIBUTES;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"CodeInsightColors.WARNINGS_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            case 3: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WEAK_WARNING;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType, (String)"HighlightInfoType.WEAK_WARNING");
                HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"HighlightSeverity.WEAK_WARNING");
                TextAttributesKey textAttributesKey = CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"CodeInsightColors.WEAK_WARNING_ATTRIBUTES");
                textAttributes = this.getAttributesForSeverity(highlightInfoType, highlightSeverity, textAttributesKey, start, end);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textAttributes;
    }

    private final TextAttributes getAttributesForSeverity(HighlightInfoType infoType, HighlightSeverity severity, TextAttributesKey insightColors, int start, int end) {
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)infoType).range(start, end).severity(severity).textAttributes(insightColors).create();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        EditorEx editorEx = this.consoleView.getConsoleEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleView.consoleEditor");
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editorEx.getDocument());
        EditorEx editorEx2 = this.consoleView.getConsoleEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"consoleView.consoleEditor");
        EditorColorsScheme colorScheme = editorEx2.getColorsScheme();
        HighlightInfo highlightInfo2 = highlightInfo;
        if (highlightInfo2 == null || (highlightInfo2 = highlightInfo2.getTextAttributes((PsiElement)psiFile, colorScheme)) == null) {
            highlightInfo2 = new TextAttributes();
        }
        return highlightInfo2;
    }

    public ReplOutputProcessor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.project = this.runner.getProject();
        LanguageConsoleView languageConsoleView = this.runner.getConsoleView();
        if (languageConsoleView == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        }
        this.consoleView = (LanguageConsoleImpl)languageConsoleView;
        EditorEx editorEx = this.historyEditor = this.consoleView.getHistoryViewer();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"historyEditor");
        this.historyDocument = editorEx.getDocument();
        EditorEx editorEx2 = this.historyEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"historyEditor");
        this.historyMarkup = editorEx2.getMarkupModel();
    }

    public static final /* synthetic */ void access$printOutput(ReplOutputProcessor $this, @NotNull String output, @NotNull ConsoleViewContentType contentType, @Nullable IconWithTooltip iconWithTooltip) {
        $this.printOutput(output, contentType, iconWithTooltip);
    }

    @NotNull
    public static final /* synthetic */ LanguageConsoleImpl access$getConsoleView$p(ReplOutputProcessor $this) {
        return $this.consoleView;
    }

    @NotNull
    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$p(ReplOutputProcessor $this) {
        return $this.runner;
    }

    @NotNull
    public static final /* synthetic */ DocumentEx access$getHistoryDocument$p(ReplOutputProcessor $this) {
        return $this.historyDocument;
    }

    @NotNull
    public static final /* synthetic */ MarkupModelEx access$getHistoryMarkup$p(ReplOutputProcessor $this) {
        return $this.historyMarkup;
    }

    @NotNull
    public static final /* synthetic */ EditorEx access$getHistoryEditor$p(ReplOutputProcessor $this) {
        return $this.historyEditor;
    }

    @NotNull
    public static final /* synthetic */ TextAttributes access$getAttributesForSeverity(ReplOutputProcessor $this, int start, int end, @NotNull Severity severity) {
        return $this.getAttributesForSeverity(start, end, severity);
    }
}

