/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.KotlinConsoleKeeperKt;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "module", "Lcom/intellij/openapi/module/Module;", "previousCompilationFailed", "", "Companion", "idea"})
public final class KotlinConsoleKeeper {
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.get(virtualFile2);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile2, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile2, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile2);
    }

    @Nullable
    public final KotlinConsoleRunner run(@NotNull Module module, boolean previousCompilationFailed) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String path = module.getModuleFilePath();
        GeneralCommandLine cmdLine = Companion.createCommandLine(module);
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module, cmdLine, previousCompilationFailed, this.project, KotlinConsoleKeeperKt.access$getREPL_TITLE$p(), path);
        consoleRunner.initAndRun();
        consoleRunner.setupGutters();
        return consoleRunner;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.consoleMap = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "addPathToCompiledOutput", "", "paramList", "Lcom/intellij/execution/configurations/ParametersList;", "module", "Lcom/intellij/openapi/module/Module;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createJavaParametersWithSdk", "Lcom/intellij/execution/configurations/JavaParameters;", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
    public static final class Companion {
        @JvmStatic
        public final KotlinConsoleKeeper getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinConsoleKeeper)ServiceManager.getService((Project)project, KotlinConsoleKeeper.class);
        }

        @NotNull
        public final GeneralCommandLine createCommandLine(@NotNull Module module) {
            GeneralCommandLine commandLine;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            JavaParameters javaParameters = this.createJavaParametersWithSdk(module);
            javaParameters.setMainClass("dummy");
            GeneralCommandLine generalCommandLine = commandLine = javaParameters.toCommandLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"commandLine");
            ParametersList paramList = generalCommandLine.getParametersList();
            paramList.clearAll();
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForIdeaPlugin();
            Iterable iterable = CollectionsKt.listOf((Object[])new File[]{kotlinPaths.getCompilerPath(), kotlinPaths.getReflectPath(), kotlinPaths.getStdlibPath(), kotlinPaths.getScriptRuntimePath()});
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            String replClassPath2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)createCommandLine.replClassPath.1.INSTANCE, (int)30, null);
            paramList.add("-cp");
            paramList.add(replClassPath2);
            paramList.add("-Dkotlin.repl.ideMode=true");
            paramList.add("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler");
            ParametersList parametersList = paramList;
            Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"paramList");
            this.addPathToCompiledOutput(parametersList, module);
            return commandLine;
        }

        @NotNull
        public final JavaParameters createJavaParametersWithSdk(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            JavaParameters params2 = new JavaParameters();
            params2.setCharset((Charset)null);
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            Sdk sdk = moduleRootManager.getSdk();
            if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && new File(sdk.getHomePath()).exists()) {
                params2.setJdk(sdk);
            }
            if (params2.getJdk() == null) {
                params2.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
            }
            return params2;
        }

        private final void addPathToCompiledOutput(ParametersList paramList, Module module) {
            Object[] objectArray = CompilerPathsEx.getOutputPaths((Module[])new Module[]{module});
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"CompilerPathsEx.getOutputPaths(arrayOf(module))");
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            String compiledModulePath = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
            OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Module)module).recursively();
            Intrinsics.checkExpressionValueIsNotNull((Object)orderEnumerator, (String)"OrderEnumerator.orderEntries(module).recursively()");
            PathsList pathsList = orderEnumerator.getPathsList();
            Intrinsics.checkExpressionValueIsNotNull((Object)pathsList, (String)"OrderEnumerator.orderEnt\u2026).recursively().pathsList");
            String moduleDependencies = pathsList.getPathsString();
            String compiledOutputClasspath = compiledModulePath + File.pathSeparator + moduleDependencies;
            paramList.add("-cp");
            paramList.add(compiledOutputClasspath);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

