/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.org.objectweb.asm.Type;

public class FieldInfo {
    private final Type fieldType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (!classDescriptor.getKind().isSingleton() || DescriptorUtils.isEnumEntry(classDescriptor)) {
            throw new UnsupportedOperationException("Can't create singleton field for class: " + classDescriptor);
        }
        if (DescriptorUtils.isNonCompanionObject(classDescriptor) || CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(classDescriptor)) {
            return FieldInfo.createSingletonViaInstance(classDescriptor, typeMapper, "INSTANCE");
        }
        ClassDescriptor ownerDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class);
        assert (ownerDescriptor != null) : "Owner not found for class: " + classDescriptor;
        Type ownerType = typeMapper.mapClass(ownerDescriptor);
        return new FieldInfo(ownerType, typeMapper.mapType(classDescriptor), classDescriptor.getName().asString(), true);
    }

    @NotNull
    public static FieldInfo createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinTypeMapper typeMapper, @NotNull String name2) {
        Type type2 = typeMapper.mapType(classDescriptor);
        return new FieldInfo(type2, type2, name2, true);
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @NotNull String fieldName) {
        return new FieldInfo(owner, fieldType, fieldName, false);
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @NotNull String fieldName, boolean isStatic) {
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        return this.fieldType;
    }

    @NotNull
    public Type getOwnerType() {
        return this.ownerType;
    }

    @NotNull
    public String getOwnerInternalName() {
        return this.ownerType.getInternalName();
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return String.format("%s %s.%s : %s", this.isStatic ? "GETSTATIC" : "GETFIELD", this.ownerType.getInternalName(), this.fieldName, this.fieldType);
    }
}

