/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrValidator;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"validateIrFile", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "validateIrModule", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "reportIrValidationError", "message", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "backend-common"})
public final class IrValidatorKt {
    public static final void validateIrFile(@NotNull CommonBackendContext context, @NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrValidator visitor2 = new IrValidator(context, false);
        IrElementVisitorVoidKt.acceptVoid(irFile, visitor2);
    }

    public static final void validateIrModule(@NotNull CommonBackendContext context, @NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)irModule, (String)"irModule");
        IrValidator visitor2 = new IrValidator(context, true);
        IrElementVisitorVoidKt.acceptVoid(irModule, visitor2);
    }

    private static final void reportIrValidationError(@NotNull CommonBackendContext $receiver, String message2, IrFile irFile, IrElement irElement) {
        try {
            UtilsKt.reportWarning($receiver, "[IR VALIDATION] " + message2, irFile, irElement);
        }
        catch (Throwable e) {
            String string = "an error trying to print a warning message: " + e;
            System.out.println((Object)string);
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ void access$reportIrValidationError(@NotNull CommonBackendContext $receiver, @NotNull String message2, @NotNull IrFile irFile, @NotNull IrElement irElement) {
        IrValidatorKt.reportIrValidationError($receiver, message2, irFile, irElement);
    }
}

