/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

public class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        for (PsiElementFinder extension : extensions = (PsiElementFinder[])Extensions.getArea((AreaInstance)project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            return (JavaElementFinder)extension;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull KotlinAsJavaSupport kotlinAsJavaSupport) {
        this.project = project;
        this.psiManager = PsiManager.getInstance((Project)project);
        this.kotlinAsJavaSupport = kotlinAsJavaSupport;
    }

    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        PsiClass[] allClasses = this.findClasses(qualifiedName2, scope2);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList answer = new SmartList();
        FqName qualifiedName2 = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName2, scope2, (List<PsiClass>)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName2, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName2, scope2));
        return JavaElementFinder.sortByClasspath((List<PsiClass>)answer, scope2).toArray(new PsiClass[answer.size()]);
    }

    private void findClassesAndObjects(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName2, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2, scope2);
        for (KtClassOrObject declaration2 : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration2 instanceof KtEnumEntry || (lightClass = LightClassUtilsKt.toLightClass(declaration2)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findInterfaceDefaultImpls(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        if (qualifiedName2.isRoot()) {
            return;
        }
        if (!qualifiedName2.shortName().asString().equals("DefaultImpls")) {
            return;
        }
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2.parent(), scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            if (!(classOrObject instanceof KtClass) || !((KtClass)classOrObject).isInterface() || (interfaceClass = LightClassUtilsKt.toLightClass(classOrObject)) == null || (implsClass = interfaceClass.findInnerClassByName("DefaultImpls", false)) == null) continue;
            answer.add(implsClass);
        }
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet answer = Sets.newHashSet();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration2 : declarations2) {
            String name2 = declaration2.getName();
            if (name2 == null) continue;
            answer.add(name2);
        }
        return answer;
    }

    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.project);
        if (this.kotlinAsJavaSupport.packageExists(fqName2, allScope)) {
            return new KtLightPackage(this.psiManager, fqName2, allScope);
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(packageFQN, scope2);
        Collection answer = Collections2.transform(subpackages, input -> new KtLightPackage(this.psiManager, (FqName)input, scope2));
        return answer.toArray(new PsiPackage[answer.size()]);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        SmartList answer = new SmartList();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration2 : declarations2) {
            KtLightClass aClass2 = LightClassUtilsKt.toLightClass(declaration2);
            if (aClass2 == null) continue;
            answer.add(aClass2);
        }
        return JavaElementFinder.sortByClasspath((List<PsiClass>)answer, scope2).toArray(new PsiClass[answer.size()]);
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtFile> result2 = this.kotlinAsJavaSupport.findFilesForPackage(packageFQN, scope2);
        return result2.toArray(new PsiFile[result2.size()]);
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        return input -> {
            if (!(input instanceof KtFile)) {
                return true;
            }
            return psiPackage.getQualifiedName().equals(((KtFile)input).getPackageFqName().asString());
        };
    }

    @NotNull
    public static Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope2) {
        return (o1, o2) -> {
            VirtualFile f2;
            VirtualFile f1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
            if (f1 == (f2 = PsiUtilCore.getVirtualFile((PsiElement)o2))) {
                return 0;
            }
            if (f1 == null) {
                return -1;
            }
            if (f2 == null) {
                return 1;
            }
            return searchScope2.compare(f2, f1);
        };
    }

    private static Collection<PsiClass> sortByClasspath(@NotNull List<PsiClass> classes2, @NotNull GlobalSearchScope searchScope2) {
        if (classes2.size() > 1) {
            ContainerUtil.quickSort(classes2, JavaElementFinder.byClasspathComparator(searchScope2));
        }
        return classes2;
    }
}

