/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.quickfix.ApiUtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinIfSurrounder;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/AddTargetVersionCheckQuickFix;", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "api", "", "(I)V", "getApi", "()I", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$Context;", "getName", "", "getSurrounder", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinIfSurrounder;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "todoText", "getTargetExpression", "isApplicable", "", "contextType", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$ContextType;", "idea-android"})
public final class AddTargetVersionCheckQuickFix
implements AndroidLintQuickFix {
    private final int api;

    public void apply(@NotNull PsiElement startElement2, @NotNull PsiElement endElement2, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtElement targetExpression = this.getTargetExpression(startElement2);
        KtElement ktElement = targetExpression;
        if (ktElement == null || (ktElement = ktElement.getProject()) == null) {
            return;
        }
        KtElement project = ktElement;
        Editor editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)targetExpression);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile file2 = targetExpression.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        KotlinIfSurrounder surrounder = this.getSurrounder(targetExpression, "\"VERSION.SDK_INT < " + ApiUtilsKt.getVersionField(this.api, false) + '\"');
        TextRange textRange = surrounder.surroundElements((Project)project, editor2, (PsiElement[])new KtElement[]{targetExpression});
        if (textRange == null) {
            return;
        }
        TextRange conditionRange = textRange;
        String conditionText = "android.os.Build.VERSION.SDK_INT >= " + ApiUtilsKt.getVersionField(this.api, true);
        TextRange textRange2 = conditionRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"conditionRange");
        document2.replaceString(textRange2.getStartOffset(), conditionRange.getEndOffset(), (CharSequence)conditionText);
        documentManager.commitDocument(document2);
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        ShortenReferences.DEFAULT.process((KtFile)psiFile, conditionRange.getStartOffset(), conditionRange.getStartOffset() + conditionText.length());
    }

    public boolean isApplicable(@NotNull PsiElement startElement2, @NotNull PsiElement endElement2, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)contextType, (String)"contextType");
        return this.getTargetExpression(startElement2) != null;
    }

    @NotNull
    public String getName() {
        return "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + ApiUtilsKt.getVersionField(this.api, false) + ") { ... }";
    }

    private final KtElement getTargetExpression(PsiElement element3) {
        KtExpression current = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtExpression.class);
        while (!(current == null || current.getParent() instanceof KtBlockExpression || current.getParent() instanceof KtContainerNode || current.getParent() instanceof KtWhenEntry || current.getParent() instanceof KtFunction || current.getParent() instanceof KtPropertyAccessor || current.getParent() instanceof KtProperty || current.getParent() instanceof KtReturnExpression || current.getParent() instanceof KtDestructuringDeclaration)) {
            current = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)current), KtExpression.class, (boolean)true);
        }
        return current;
    }

    private final KotlinIfSurrounder getSurrounder(KtElement element3, String todoText) {
        Boolean used;
        Boolean bl = (Boolean)ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL).get(BindingContext.USED_AS_EXPRESSION, element3);
        if (bl == null) {
            bl = false;
        }
        Boolean bl2 = used = bl;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"used");
        return bl2 != false ? (KotlinIfSurrounder)new KotlinIfSurrounder(todoText){
            final /* synthetic */ String $todoText;

            @NotNull
            protected String getCodeTemplate() {
                StringBuilder stringBuilder = new StringBuilder().append("if (a) { \n} else {\nTODO(");
                String string = this.$todoText;
                if (string == null) {
                    string = "";
                }
                return stringBuilder.append(string).append(")\n}").toString();
            }
            {
                this.$todoText = $captured_local_variable$0;
            }
        } : new KotlinIfSurrounder();
    }

    public final int getApi() {
        return this.api;
    }

    public AddTargetVersionCheckQuickFix(int api) {
        this.api = api;
    }
}

