/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.KtPsiUtilKt;
import org.jetbrains.kotlin.android.quickfix.ApiUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u0005*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u0005*\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u0005*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/android/quickfix/AddTargetApiQuickFix;", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "api", "", "useRequiresApi", "", "(IZ)V", "getApi", "()I", "getUseRequiresApi", "()Z", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$Context;", "getAnnotationContainer", "element", "getAnnotationValue", "", "fullyQualified", "getName", "isApplicable", "contextType", "Lorg/jetbrains/android/inspections/lint/AndroidQuickfixContexts$ContextType;", "isNewLineNeededForAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRequiresApiAnnotationValidTarget", "isTargetApiAnnotationValidTarget", "Companion", "idea-android"})
public final class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private final int api;
    private final boolean useRequiresApi;
    @NotNull
    private static final FqName FQNAME_TARGET_API;
    @NotNull
    private static final FqName FQNAME_REQUIRES_API;
    @Deprecated
    public static final Companion Companion;

    public boolean isApplicable(@NotNull PsiElement startElement2, @NotNull PsiElement endElement2, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)contextType, (String)"contextType");
        return this.getAnnotationContainer(startElement2, this.useRequiresApi) != null;
    }

    @NotNull
    public String getName() {
        String string;
        String string2;
        String it = string2 = this.getAnnotationValue(false);
        if (this.useRequiresApi) {
            string = "Add @RequiresApi(" + it + ") Annotation";
        } else {
            String string3 = AndroidBundle.message((String)"android.lint.fix.add.target.api", (Object[])new Object[]{it});
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"AndroidBundle.message(\"a\u2026.fix.add.target.api\", it)");
        }
        return string;
    }

    public void apply(@NotNull PsiElement startElement2, @NotNull PsiElement endElement2, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement2 = this.getAnnotationContainer(startElement2, this.useRequiresApi);
        if (psiElement2 == null) {
            return;
        }
        PsiElement annotationContainer2 = psiElement2;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer2)) {
            return;
        }
        if (annotationContainer2 instanceof KtModifierListOwner) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)annotationContainer2, this.useRequiresApi ? FQNAME_REQUIRES_API : FQNAME_TARGET_API, this.getAnnotationValue(true), this.isNewLineNeededForAnnotation((KtElement)annotationContainer2) ? "\n" : " ", null, 8, null);
        }
    }

    private final boolean isNewLineNeededForAnnotation(@NotNull KtElement $receiver) {
        return !($receiver instanceof KtParameter) && !($receiver instanceof KtTypeParameter) && !($receiver instanceof KtPropertyAccessor);
    }

    private final String getAnnotationValue(boolean fullyQualified) {
        return ApiUtilsKt.getVersionField(this.api, fullyQualified);
    }

    private final PsiElement getAnnotationContainer(PsiElement element3, boolean useRequiresApi) {
        return PsiTreeUtil.findFirstParent((PsiElement)element3, (Condition)((Condition)new Condition<PsiElement>(this, useRequiresApi){
            final /* synthetic */ AddTargetApiQuickFix this$0;
            final /* synthetic */ boolean $useRequiresApi;

            public final boolean value(PsiElement it) {
                boolean bl;
                if (this.$useRequiresApi) {
                    PsiElement psiElement2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
                    bl = AddTargetApiQuickFix.access$isRequiresApiAnnotationValidTarget(this.this$0, psiElement2);
                } else {
                    PsiElement psiElement3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it");
                    bl = AddTargetApiQuickFix.access$isTargetApiAnnotationValidTarget(this.this$0, psiElement3);
                }
                return bl;
            }
            {
                this.this$0 = addTargetApiQuickFix;
                this.$useRequiresApi = bl;
            }
        }));
    }

    private final boolean isRequiresApiAnnotationValidTarget(@NotNull PsiElement $receiver) {
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtFunction && !($receiver instanceof KtFunctionLiteral) || $receiver instanceof KtProperty && !((KtProperty)$receiver).isLocal() && KtPsiUtilKt.hasBackingField((KtProperty)$receiver) || $receiver instanceof KtPropertyAccessor;
    }

    private final boolean isTargetApiAnnotationValidTarget(@NotNull PsiElement $receiver) {
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtFunction && !($receiver instanceof KtFunctionLiteral) || $receiver instanceof KtPropertyAccessor;
    }

    public final int getApi() {
        return this.api;
    }

    public final boolean getUseRequiresApi() {
        return this.useRequiresApi;
    }

    public AddTargetApiQuickFix(int api, boolean useRequiresApi) {
        this.api = api;
        this.useRequiresApi = useRequiresApi;
    }

    static {
        Companion = new Companion(null);
        FQNAME_TARGET_API = new FqName("android.annotation.TargetApi");
        FQNAME_REQUIRES_API = new FqName("android.support.annotation.RequiresApi");
    }

    public static final /* synthetic */ boolean access$isRequiresApiAnnotationValidTarget(AddTargetApiQuickFix $this, @NotNull PsiElement $receiver) {
        return $this.isRequiresApiAnnotationValidTarget($receiver);
    }

    public static final /* synthetic */ boolean access$isTargetApiAnnotationValidTarget(AddTargetApiQuickFix $this, @NotNull PsiElement $receiver) {
        return $this.isTargetApiAnnotationValidTarget($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/AddTargetApiQuickFix$Companion;", "", "()V", "FQNAME_REQUIRES_API", "Lorg/jetbrains/kotlin/name/FqName;", "getFQNAME_REQUIRES_API", "()Lorg/jetbrains/kotlin/name/FqName;", "FQNAME_TARGET_API", "getFQNAME_TARGET_API", "idea-android"})
    private static final class Companion {
        @NotNull
        public final FqName getFQNAME_TARGET_API() {
            return FQNAME_TARGET_API;
        }

        @NotNull
        public final FqName getFQNAME_REQUIRES_API() {
            return FQNAME_REQUIRES_API;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

