/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.folding;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.folding.ResourceFoldingBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\tH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u000f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0007*\u00020\u001dH\u0002J'\u0010!\u001a\u0004\u0018\u00010\u000f*\u00020\u00142\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0082\u0010J\f\u0010&\u001a\u00020\u0004*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "()V", "isFoldingEnabled", "", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "formatArguments", "", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "formatString", "getAppResources", "Lcom/android/tools/idea/res/LocalResourceRepository;", "element", "getPlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "getAndroidResourceType", "Lcom/android/resources/ResourceType;", "getAndroidResourceValue", "Lorg/jetbrains/uast/UReferenceExpression;", "resources", "call", "getFoldingDescriptor", "getResourceValue", "type", "name", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isFoldableGetResourceValueCall", "Companion", "idea-android"})
public final class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private final boolean isFoldingEnabled;
    private static final Pattern FORMAT;
    private static final int FOLD_MAX_LENGTH = 60;
    private static final boolean UNIT_TEST_MODE;
    private static final List<ResourceType> RESOURCE_TYPES;
    public static final Companion Companion;

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Function2<UElement, LocalResourceRepository, String> unwrapReferenceAndGetValue$ = new Function2<UElement, LocalResourceRepository, String>(this){
            final /* synthetic */ ResourceFoldingBuilder this$0;

            @Nullable
            public final String invoke(@NotNull UElement $receiver, @NotNull LocalResourceRepository resources) {
                String string;
                UElement uElement;
                while (true) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
                    uElement = $receiver;
                    if (!(uElement instanceof UQualifiedReferenceExpression)) break;
                    $receiver = (UElement)((UQualifiedReferenceExpression)$receiver).getSelector();
                }
                if (uElement instanceof UCallExpression) {
                    Object object = CollectionsKt.firstOrNull((List)((UCallExpression)$receiver).getValueArguments());
                    if (!(object instanceof UReferenceExpression)) {
                        object = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)object;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.access$getAndroidResourceValue(this.this$0, uReferenceExpression, resources, (UCallExpression)$receiver) : null;
                } else {
                    UElement uElement2 = $receiver;
                    if (!(uElement2 instanceof UReferenceExpression)) {
                        uElement2 = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)uElement2;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.getAndroidResourceValue$default(this.this$0, uReferenceExpression, resources, null, 2, null) : null;
                }
                return string;
            }
            {
                this.this$0 = resourceFoldingBuilder;
                super(2);
            }
        };
        PsiElement psiElement2 = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement3 = element3 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        LocalResourceRepository localResourceRepository = this.getAppResources(psiElement3);
        if (localResourceRepository == null) {
            return null;
        }
        LocalResourceRepository appResources = localResourceRepository;
        UastContext uastContext = (UastContext)ServiceManager.getService((Project)element3.getProject(), UastContext.class);
        if (uastContext == null) {
            return null;
        }
        UastContext uastContext2 = uastContext;
        UElement uElement = uastContext2.convertElement(element3, null, null);
        return uElement != null ? unwrapReferenceAndGetValue$.invoke(uElement, appResources) : null;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Collection $receiver$iv;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                if (!(root instanceof KtFile) || quick && !UNIT_TEST_MODE || !this.isFoldingEnabled) break block5;
                if (AndroidFacet.getInstance((PsiElement)root) != null) break block6;
            }
            return new FoldingDescriptor[0];
        }
        UElement file2 = UastContextKt.toUElement((PsiElement)root);
        ArrayList result2 = new ArrayList();
        UElement uElement = file2;
        if (uElement != null) {
            uElement.accept((UastVisitor)new AbstractUastVisitor(this, result2){
                final /* synthetic */ ResourceFoldingBuilder this$0;
                final /* synthetic */ ArrayList $result;

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    block0: {
                        FoldingDescriptor foldingDescriptor;
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        FoldingDescriptor foldingDescriptor2 = ResourceFoldingBuilder.access$getFoldingDescriptor(this.this$0, (UReferenceExpression)node);
                        if (foldingDescriptor2 == null) break block0;
                        FoldingDescriptor it = foldingDescriptor = foldingDescriptor2;
                        this.$result.add(it);
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
                {
                    this.this$0 = $outer;
                    this.$result = $captured_local_variable$1;
                }
            });
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)result2;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[0]);
        if (foldingDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.isFoldingEnabled;
    }

    private final FoldingDescriptor getFoldingDescriptor(@NotNull UReferenceExpression $receiver) {
        UCallExpression getResourceValueCall;
        UCallExpression uCallExpression;
        UCallExpression it;
        PsiElement psiElement2 = $receiver.resolve();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement resolved = psiElement2;
        ResourceType resourceType = this.getAndroidResourceType(resolved);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        if (!RESOURCE_TYPES.contains(resourceType2)) {
            return null;
        }
        getFoldingDescriptor.1 createFoldingDescriptor$ = getFoldingDescriptor.1.INSTANCE;
        UElement uElement = $receiver.getUastParent();
        if (!(uElement instanceof UQualifiedReferenceExpression)) {
            uElement = null;
        }
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement;
        UReferenceExpression element3 = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : $receiver;
        UElement uElement2 = element3.getUastParent();
        if (!(uElement2 instanceof UCallExpression)) {
            uElement2 = null;
        }
        UCallExpression uCallExpression2 = (UCallExpression)uElement2;
        Object object = uCallExpression2 != null ? (this.isFoldableGetResourceValueCall(it = (uCallExpression = uCallExpression2)) ? uCallExpression : null) : (getResourceValueCall = null);
        if (getResourceValueCall != null) {
            UQualifiedReferenceExpression qualifiedCall;
            UElement uElement3 = getResourceValueCall.getUastParent();
            if (!(uElement3 instanceof UQualifiedReferenceExpression)) {
                uElement3 = null;
            }
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = qualifiedCall = (UQualifiedReferenceExpression)uElement3;
            if (Intrinsics.areEqual((Object)(uQualifiedReferenceExpression2 != null ? uQualifiedReferenceExpression2.getSelector() : null), (Object)getResourceValueCall)) {
                return createFoldingDescriptor$.invoke((UElement)qualifiedCall);
            }
            return createFoldingDescriptor$.invoke((UElement)getResourceValueCall);
        }
        return createFoldingDescriptor$.invoke((UElement)element3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFoldableGetResourceValueCall(@NotNull UCallExpression $receiver) {
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getString")) return true;
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getText")) return true;
        if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)"getInteger")) return true;
        String string = $receiver.getMethodName();
        if (string != null ? StringsKt.startsWith$default((String)string, (String)"getDimension", (boolean)false, (int)2, null) : false) return true;
        String string2 = $receiver.getMethodName();
        if (string2 == null) return false;
        boolean bl = StringsKt.startsWith$default((String)string2, (String)"getQuantityString", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    private final ResourceType getAndroidResourceType(@NotNull PsiElement $receiver) {
        PsiElement psiElement2 = $receiver.getParent();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass2 = (PsiClass)psiElement2;
        if (psiClass2 == null) {
            return null;
        }
        PsiClass elementType = psiClass2;
        PsiElement psiElement3 = elementType.getParent();
        if (!(psiElement3 instanceof PsiClass)) {
            psiElement3 = null;
        }
        PsiClass psiClass3 = (PsiClass)psiElement3;
        if (psiClass3 == null) {
            return null;
        }
        PsiClass elementPackage = psiClass3;
        if (Intrinsics.areEqual((Object)"R", (Object)elementPackage.getName()) ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)elementPackage.getQualifiedName(), (Object)"android.R") ^ true) {
            return ResourceType.getEnum((String)elementType.getName());
        }
        return null;
    }

    private final String getAndroidResourceValue(@NotNull UReferenceExpression $receiver, LocalResourceRepository resources, UCallExpression call2) {
        String text2;
        FolderConfiguration folderConfiguration;
        PsiElement psiElement2 = $receiver.resolve();
        if (psiElement2 == null || (psiElement2 = this.getAndroidResourceType(psiElement2)) == null) {
            return null;
        }
        PsiElement resourceType = psiElement2;
        FolderConfiguration $receiver2 = folderConfiguration = new FolderConfiguration();
        $receiver2.setLocaleQualifier(new LocaleQualifier("xx"));
        FolderConfiguration referenceConfig = folderConfiguration;
        String string = $receiver.getResolvedName();
        if (string == null) {
            return null;
        }
        String key = string;
        String string2 = this.getResourceValue(resources, (ResourceType)resourceType, key, referenceConfig);
        if (string2 == null) {
            return null;
        }
        String resourceValue = string2;
        String string3 = text2 = call2 != null ? this.formatArguments(call2, resourceValue) : resourceValue;
        if (resourceType == ResourceType.STRING || resourceType == ResourceType.PLURALS) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '\"';
            String string4 = StringUtil.shortenTextWithEllipsis((String)text2, (int)(FOLD_MAX_LENGTH - 2), (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringUtil.shortenTextWi\u2026, FOLD_MAX_LENGTH - 2, 0)");
            String string5 = string4;
            StringBuilder stringBuilder2 = stringBuilder;
            String string6 = String.valueOf(c) + string5;
            return stringBuilder2.append(string6).append('\"').toString();
        }
        if (text2.length() <= 1) {
            return key + ": " + text2;
        }
        return StringUtil.shortenTextWithEllipsis((String)text2, (int)FOLD_MAX_LENGTH, (int)0);
    }

    static /* bridge */ /* synthetic */ String getAndroidResourceValue$default(ResourceFoldingBuilder resourceFoldingBuilder, UReferenceExpression uReferenceExpression, LocalResourceRepository localResourceRepository, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return resourceFoldingBuilder.getAndroidResourceValue(uReferenceExpression, localResourceRepository, uCallExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final String getResourceValue(@NotNull LocalResourceRepository $receiver, ResourceType type2, String name2, FolderConfiguration referenceConfig) {
        Object object;
        while ((object = $receiver.getConfiguredValue(type2, name2, referenceConfig)) != null && (object = object.getValue()) != null) {
            ResourceType referencedType;
            void referencedTypeName;
            Object object2;
            Object value2 = object;
            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)value2), (char)'@', (boolean)false, (int)2, null)) {
                return value2;
            }
            Object object3 = value2;
            int n = 1;
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            Object it = object3 = StringsKt.split$default((CharSequence)string, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            Object object5 = it.size() == 2 ? object3 : null;
            if (object5 == null) {
                return value2;
            }
            object3 = object2 = object5;
            String string2 = (String)object3.get(0);
            object3 = object2;
            String referencedName = (String)object3.get(1);
            if (ResourceType.getEnum((String)referencedTypeName) == null) {
                return value2;
            }
            name2 = referencedName;
            type2 = referencedType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatArguments(UCallExpression callExpression2, String formatString) {
        if (!StringsKt.contains$default((CharSequence)formatString, (char)'%', (boolean)false, (int)2, null)) {
            return formatString;
        }
        List args = callExpression2.getValueArguments();
        if (args.isEmpty() || !((UExpression)CollectionsKt.first((List)args)).isPsiValid()) {
            return formatString;
        }
        Matcher matcher2 = FORMAT.matcher(formatString);
        int index2 = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start = 0;
        StringBuilder sb = new StringBuilder(2 * formatString.length());
        while (matcher2.find(index2)) {
            int n;
            int number;
            int n2;
            if (Intrinsics.areEqual((Object)"%", (Object)matcher2.group(6))) {
                index2 = matcher2.end();
                continue;
            }
            int matchStart = matcher2.start();
            while (prevIndex < matchStart) {
                char c = formatString.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index2 = prevIndex;
                continue;
            }
            index2 = matcher2.end();
            String numberString = matcher2.group(1);
            if (numberString != null) {
                String string = numberString;
                int n3 = 0;
                n2 = numberString.length() - 1;
                String string2 = string.substring(n3, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                numberString = string2;
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.size()) continue;
            UExpression argExpression = (UExpression)args.get(number);
            Object value2 = argExpression.evaluate();
            if (value2 == null) {
                value2 = ((UExpression)args.get(number)).asSourceString();
            }
            if ((n2 = start) <= (n = matchStart - 1)) {
                while (true) {
                    void i;
                    sb.append(formatString.charAt((int)i));
                    if (i == n) break;
                    ++i;
                }
            }
            sb.append("{");
            sb.append(value2);
            sb.append('}');
            start = index2;
        }
        int n = formatString.length();
        for (int i = start; i < n; ++i) {
            sb.append(formatString.charAt(i));
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final LocalResourceRepository getAppResources(PsiElement element3) {
        AppResourceRepository appResourceRepository;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element3);
        if (module != null) {
            Module module2;
            Module it = module2 = module;
            appResourceRepository = AppResourceRepository.findExistingInstance((Module)it);
        } else {
            appResourceRepository = null;
        }
        return (LocalResourceRepository)appResourceRepository;
    }

    public ResourceFoldingBuilder() {
        AndroidFoldingSettings androidFoldingSettings = AndroidFoldingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFoldingSettings, (String)"AndroidFoldingSettings.getInstance()");
        this.isFoldingEnabled = androidFoldingSettings.isCollapseAndroidStrings();
    }

    static {
        Companion = new Companion(null);
        FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        FOLD_MAX_LENGTH = 60;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        UNIT_TEST_MODE = application.isUnitTestMode();
        RESOURCE_TYPES = CollectionsKt.listOf((Object[])new ResourceType[]{ResourceType.STRING, ResourceType.DIMEN, ResourceType.INTEGER, ResourceType.PLURALS});
    }

    @Nullable
    public static final /* synthetic */ String access$getAndroidResourceValue(ResourceFoldingBuilder $this, @NotNull UReferenceExpression $receiver, @NotNull LocalResourceRepository resources, @Nullable UCallExpression call2) {
        return $this.getAndroidResourceValue($receiver, resources, call2);
    }

    @Nullable
    public static final /* synthetic */ FoldingDescriptor access$getFoldingDescriptor(ResourceFoldingBuilder $this, @NotNull UReferenceExpression $receiver) {
        return $this.getFoldingDescriptor($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder$Companion;", "", "()V", "FOLD_MAX_LENGTH", "", "FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RESOURCE_TYPES", "", "Lcom/android/resources/ResourceType;", "UNIT_TEST_MODE", "", "idea-android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

