/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.android.ResourceReferenceAnnotatorUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/AndroidResourceReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getResourceReferenceTargetDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "idea-android"})
public final class AndroidResourceReferenceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtReferenceExpression)) {
            psiElement2 = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement2;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression reference2 = ktReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)element3);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        JavaPropertyDescriptor javaPropertyDescriptor = this.getResourceReferenceTargetDescriptor(reference2);
        if (javaPropertyDescriptor == null) {
            return;
        }
        JavaPropertyDescriptor referenceTarget = javaPropertyDescriptor;
        ResourceType resourceType = AndroidUtilKt.getAndroidResourceType(referenceTarget);
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2 != ResourceType.COLOR && resourceType2 != ResourceType.DRAWABLE && resourceType2 != ResourceType.MIPMAP) {
            return;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidUtilKt.getResourceReferenceType(referenceTarget);
        AndroidFacet androidFacet3 = androidFacet2;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacet3, (String)"androidFacet");
        Configuration configuration2 = ResourceReferenceAnnotatorUtil.pickConfiguration(androidFacet2, androidFacet3.getModule(), ((KtReferenceExpression)element3).getContainingFile());
        if (configuration2 == null) {
            return;
        }
        Configuration configuration3 = configuration2;
        ResourceValue resourceValue = ResourceReferenceAnnotatorUtil.findResourceValue(resourceType2, reference2.getText(), referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK, androidFacet2.getModule(), configuration3);
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        Configuration configuration4 = configuration3;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration4, (String)"configuration");
        ResourceResolver resourceResolver = configuration4.getResourceResolver();
        if (resourceResolver == null) {
            return;
        }
        ResourceResolver resourceResolver2 = resourceResolver;
        if (resourceType2 == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)((RenderResources)resourceResolver2), (ResourceValue)resourceValue2, (Project)((KtReferenceExpression)element3).getProject());
            if (color != null) {
                Annotation annotation2;
                Annotation annotation3 = annotation2 = holder.createInfoAnnotation(element3, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                annotation3.setGutterIconRenderer((GutterIconRenderer)new ResourceReferenceAnnotatorUtil.ColorRenderer(element3, color));
            }
        } else {
            File iconFile;
            File file2 = ResourceHelper.resolveDrawable((RenderResources)((RenderResources)resourceResolver2), (ResourceValue)resourceValue2, (Project)((KtReferenceExpression)element3).getProject());
            if (file2 != null) {
                String string = file2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                    file2 = ResourceReferenceAnnotatorUtil.pickBitmapFromXml(file2, resourceResolver2, ((KtReferenceExpression)element3).getProject());
                }
            }
            if ((iconFile = AndroidColorAnnotator.pickBestBitmap((File)file2)) != null) {
                Annotation annotation4;
                Annotation annotation5 = annotation4 = holder.createInfoAnnotation(element3, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation5, (String)"annotation");
                annotation5.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, element3, iconFile));
            }
        }
    }

    private final JavaPropertyDescriptor getResourceReferenceTargetDescriptor(@NotNull KtReferenceExpression $receiver) {
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default($receiver, null, 1, null);
        Object object = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(object instanceof JavaPropertyDescriptor)) {
            object = null;
        }
        return (JavaPropertyDescriptor)object;
    }
}

