/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.DoubleValue;
import org.jetbrains.eval4j.FloatValue;
import org.jetbrains.eval4j.IntValue;
import org.jetbrains.eval4j.LongValue;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.VOID_VALUE;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIFailureException;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0014*\u00020\u0016\u001a\f\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u0006\u001a\f\u0010\u0017\u001a\u00020\u0002*\u0004\u0018\u00010\u0010\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"jdiClass", "Lcom/sun/jdi/ClassObjectReference;", "Lorg/jetbrains/eval4j/Value;", "getJdiClass", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ClassObjectReference;", "jdiObj", "Lcom/sun/jdi/ObjectReference;", "getJdiObj", "(Lorg/jetbrains/eval4j/Value;)Lcom/sun/jdi/ObjectReference;", "makeInitialFrame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "arguments", "", "asJdiValue", "Lcom/sun/jdi/Value;", "vm", "Lcom/sun/jdi/VirtualMachine;", "expectedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "asType", "Lcom/sun/jdi/Type;", "asValue", "Lorg/jetbrains/eval4j/ObjectValue;", "eval4j"})
public final class JdiValuesKt {
    @NotNull
    public static final Frame<Value> makeInitialFrame(@NotNull MethodNode methodNode, @NotNull List<? extends Value> arguments2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        boolean isStatic = (methodNode.access & 8) != 0;
        Type[] params2 = Type.getArgumentTypes((String)methodNode.desc);
        boolean bl2 = bl = arguments2.size() == (isStatic ? params2.length : params2.length + 1);
        if (_Assertions.ENABLED && !bl) {
            String string = "Wrong number of arguments for " + methodNode + ": " + arguments2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Frame frame = new Frame(methodNode.maxLocals, methodNode.maxStack);
        Type type2 = Type.getReturnType((String)methodNode.desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getReturnType(methodNode.desc)");
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ValuesKt.makeNotInitializedValue(type2));
        int index2 = 0;
        for (Value value2 : arguments2) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value2);
            if (value2.getSize() != 2) continue;
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        while (index2 < methodNode.maxLocals) {
            frame.setLocal(index2++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)NOT_A_VALUE.INSTANCE);
        }
        return frame;
    }

    @NotNull
    public static final ObjectValue asValue(@Nullable ObjectReference $receiver) {
        ObjectValue objectValue;
        ObjectReference objectReference = $receiver;
        if (objectReference == null) {
            objectValue = ValuesKt.getNULL_VALUE();
        } else {
            com.sun.jdi.Type type2 = $receiver.type();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type()");
            objectValue = new ObjectValue($receiver, JdiValuesKt.asType(type2));
        }
        return objectValue;
    }

    @NotNull
    public static final Value asValue(@Nullable com.sun.jdi.Value $receiver) {
        Value value2;
        com.sun.jdi.Value value3 = $receiver;
        if (value3 == null) {
            value2 = ValuesKt.getNULL_VALUE();
        } else if (value3 instanceof VoidValue) {
            value2 = VOID_VALUE.INSTANCE;
        } else if (value3 instanceof BooleanValue) {
            int n = ((BooleanValue)$receiver).intValue();
            Type type2 = Type.BOOLEAN_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.BOOLEAN_TYPE");
            value2 = new IntValue(n, type2);
        } else if (value3 instanceof ByteValue) {
            int n = ((ByteValue)$receiver).intValue();
            Type type3 = Type.BYTE_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.BYTE_TYPE");
            value2 = new IntValue(n, type3);
        } else if (value3 instanceof ShortValue) {
            int n = ((ShortValue)$receiver).intValue();
            Type type4 = Type.SHORT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"Type.SHORT_TYPE");
            value2 = new IntValue(n, type4);
        } else if (value3 instanceof CharValue) {
            int n = ((CharValue)$receiver).intValue();
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.CHAR_TYPE");
            value2 = new IntValue(n, type5);
        } else if (value3 instanceof IntegerValue) {
            int n = ((IntegerValue)$receiver).intValue();
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"Type.INT_TYPE");
            value2 = new IntValue(n, type6);
        } else if (value3 instanceof com.sun.jdi.LongValue) {
            value2 = new LongValue(((com.sun.jdi.LongValue)$receiver).longValue());
        } else if (value3 instanceof com.sun.jdi.FloatValue) {
            value2 = new FloatValue(((com.sun.jdi.FloatValue)$receiver).floatValue());
        } else if (value3 instanceof com.sun.jdi.DoubleValue) {
            value2 = new DoubleValue(((com.sun.jdi.DoubleValue)$receiver).doubleValue());
        } else if (value3 instanceof ObjectReference) {
            value2 = JdiValuesKt.asValue((ObjectReference)$receiver);
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }

    @NotNull
    public static final Type asType(@NotNull com.sun.jdi.Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type2 = Type.getType((String)$receiver.signature());
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(this.signature())");
        return type2;
    }

    @Nullable
    public static final ObjectReference getJdiObj(@NotNull Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ObjectReference)ValuesKt.obj$default($receiver, null, 1, null);
    }

    @Nullable
    public static final ClassObjectReference getJdiClass(@NotNull Value $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ClassObjectReference)JdiValuesKt.getJdiObj($receiver);
    }

    @Nullable
    public static final com.sun.jdi.Value asJdiValue(@NotNull Value $receiver, @NotNull VirtualMachine vm, @NotNull Type expectedType) {
        com.sun.jdi.Value value2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Value value3 = $receiver;
        if (Intrinsics.areEqual((Object)value3, (Object)ValuesKt.getNULL_VALUE())) {
            value2 = null;
        } else if (Intrinsics.areEqual((Object)value3, (Object)VOID_VALUE.INSTANCE)) {
            value2 = vm.mirrorOfVoid();
        } else if (value3 instanceof IntValue) {
            PrimitiveValue primitiveValue;
            Type type2 = expectedType;
            if (Intrinsics.areEqual((Object)type2, (Object)Type.BOOLEAN_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getBoolean($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.BYTE_TYPE)) {
                primitiveValue = vm.mirrorOf((byte)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.SHORT_TYPE)) {
                primitiveValue = vm.mirrorOf((short)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
                primitiveValue = vm.mirrorOf((char)ValuesKt.getInt($receiver));
            } else if (Intrinsics.areEqual((Object)type2, (Object)Type.INT_TYPE)) {
                primitiveValue = vm.mirrorOf(ValuesKt.getInt($receiver));
            } else {
                throw (Throwable)new JDIFailureException("Unknown value type: " + $receiver, null, 2, null);
            }
            value2 = primitiveValue;
        } else if (value3 instanceof LongValue) {
            value2 = vm.mirrorOf(((Number)((LongValue)$receiver).getValue()).longValue());
        } else if (value3 instanceof FloatValue) {
            value2 = vm.mirrorOf(((Number)((FloatValue)$receiver).getValue()).floatValue());
        } else if (value3 instanceof DoubleValue) {
            value2 = vm.mirrorOf(((Number)((DoubleValue)$receiver).getValue()).doubleValue());
        } else if (value3 instanceof ObjectValue) {
            Object v = ((ObjectValue)$receiver).getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)v;
        } else if (value3 instanceof NewObjectValue) {
            Object object = ValuesKt.obj$default($receiver, null, 1, null);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            value2 = (ObjectReference)object;
        } else {
            throw (Throwable)new JDIFailureException("Unknown value: " + $receiver, null, 2, null);
        }
        return value2;
    }
}

