/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import java.util.List;
import org.gradle.internal.impldep.org.testng.ITestNGMethod;
import org.gradle.internal.impldep.org.testng.TestNGException;
import org.gradle.internal.impldep.org.testng.collections.ListMultiMap;
import org.gradle.internal.impldep.org.testng.collections.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            this.m_dependencies.put(m.getMethodName(), m);
            for (String g : m.getGroups()) {
                this.m_groups.put(g, m);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group, ITestNGMethod fromMethod) {
        List<ITestNGMethod> result = this.m_groups.get(group);
        if (result == null) {
            throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent group \"" + group + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List<ITestNGMethod> l = this.m_dependencies.get(methodName);
        for (ITestNGMethod m : l) {
            if (fromMethod.getRealClass().isAssignableFrom(m.getRealClass())) {
                if (m.getInstance() != fromMethod.getInstance()) continue;
                return m;
            }
            return m;
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }
}

