/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyGraphTransformer;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;
import org.gradle.internal.impldep.org.sonatype.aether.graph.DependencyNode;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMarker
implements DependencyGraphTransformer {
    private final Object SEEN = Boolean.TRUE;

    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        IdentityHashMap<DependencyNode, Object> nodes = new IdentityHashMap<DependencyNode, Object>(1024);
        HashMap<Object, ConflictGroup> groups = new HashMap<Object, ConflictGroup>(1024);
        this.analyze(node, nodes, groups);
        Map<DependencyNode, Object> conflictIds = this.mark(nodes.keySet(), groups);
        context.put(TransformationContextKeys.CONFLICT_IDS, conflictIds);
        return node;
    }

    private void analyze(DependencyNode node, Map<DependencyNode, Object> nodes, Map<Object, ConflictGroup> groups) {
        if (nodes.put(node, this.SEEN) != null) {
            return;
        }
        Set<Object> keys = this.getKeys(node);
        if (!keys.isEmpty()) {
            ConflictGroup group = null;
            boolean fixMappings = false;
            for (Object key : keys) {
                Set<Object> newKeys;
                ConflictGroup g = groups.get(key);
                if (group == g) continue;
                if (group == null) {
                    newKeys = this.merge(g.keys, keys);
                    if (newKeys == g.keys) {
                        group = g;
                        break;
                    }
                    group = new ConflictGroup(newKeys);
                    fixMappings = true;
                    continue;
                }
                if (g == null) {
                    fixMappings = true;
                    continue;
                }
                newKeys = this.merge(g.keys, group.keys);
                if (newKeys == g.keys) {
                    group = g;
                    fixMappings = false;
                    break;
                }
                if (newKeys == group.keys) continue;
                group = new ConflictGroup(newKeys);
                fixMappings = true;
            }
            if (group == null) {
                group = new ConflictGroup(keys);
                fixMappings = true;
            }
            if (fixMappings) {
                for (Object key : group.keys) {
                    groups.put(key, group);
                }
            }
        }
        for (DependencyNode child : node.getChildren()) {
            this.analyze(child, nodes, groups);
        }
    }

    private Set<Object> merge(Set<Object> keys1, Set<Object> keys2) {
        int size2;
        int size1 = keys1.size();
        if (size1 < (size2 = keys2.size())) {
            if (keys2.containsAll(keys1)) {
                return keys2;
            }
        } else if (keys1.containsAll(keys2)) {
            return keys1;
        }
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(keys1);
        keys.addAll(keys2);
        return keys;
    }

    private Set<Object> getKeys(DependencyNode node) {
        Set<Object> keys;
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            keys = Collections.emptySet();
        } else {
            Object key = ConflictMarker.toKey(dependency.getArtifact());
            if (node.getRelocations().isEmpty() && node.getAliases().isEmpty()) {
                keys = Collections.singleton(key);
            } else {
                keys = new HashSet<Object>();
                keys.add(key);
                for (Artifact relocation : node.getRelocations()) {
                    key = ConflictMarker.toKey(relocation);
                    keys.add(key);
                }
                for (Artifact alias : node.getAliases()) {
                    key = ConflictMarker.toKey(alias);
                    keys.add(key);
                }
            }
        }
        return keys;
    }

    private Map<DependencyNode, Object> mark(Collection<DependencyNode> nodes, Map<Object, ConflictGroup> groups) {
        IdentityHashMap<DependencyNode, Object> conflictIds = new IdentityHashMap<DependencyNode, Object>(nodes.size() + 1);
        for (DependencyNode node : nodes) {
            Dependency dependency = node.getDependency();
            if (dependency == null) continue;
            Object key = ConflictMarker.toKey(dependency.getArtifact());
            conflictIds.put(node, groups.get((Object)key).keys);
        }
        return conflictIds;
    }

    private static Object toKey(Artifact artifact) {
        return new Key(artifact);
    }

    static class Key {
        private final Artifact artifact;

        public Key(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifact.getArtifactId().equals(that.artifact.getArtifactId()) && this.artifact.getGroupId().equals(that.artifact.getGroupId()) && this.artifact.getExtension().equals(that.artifact.getExtension()) && this.artifact.getClassifier().equals(that.artifact.getClassifier());
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.artifact.getArtifactId().hashCode();
            hash = hash * 31 + this.artifact.getGroupId().hashCode();
            hash = hash * 31 + this.artifact.getClassifier().hashCode();
            hash = hash * 31 + this.artifact.getExtension().hashCode();
            return hash;
        }

        public String toString() {
            return this.artifact.getGroupId() + ':' + this.artifact.getArtifactId() + ':' + this.artifact.getClassifier() + ':' + this.artifact.getExtension();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGroup {
        final Set<Object> keys;

        public ConflictGroup(Set<Object> keys) {
            this.keys = keys;
        }

        public String toString() {
            return String.valueOf(this.keys);
        }
    }
}

