/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.opentest4j;

import java.io.Serializable;

public final class ValueWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ValueWrapper nullValueWrapper = new ValueWrapper(null);
    private final Serializable value;
    private final Class<?> type;
    private final String stringRepresentation;
    private final int identityHashCode;

    public static ValueWrapper create(Object value) {
        return value == null ? nullValueWrapper : new ValueWrapper(value);
    }

    private ValueWrapper(Object value) {
        this.value = value instanceof Serializable ? (Serializable)value : null;
        this.type = value != null ? value.getClass() : null;
        this.stringRepresentation = String.valueOf(value);
        this.identityHashCode = System.identityHashCode(value);
    }

    public Serializable getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public String toString() {
        if (this.type == null) {
            return "null";
        }
        return this.stringRepresentation + " (" + this.type.getName() + "@" + Integer.toHexString(this.identityHashCode) + ")";
    }
}

