/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ClassUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ReflectionUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.StringUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ToStringBuilder;
import org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSelector
implements DiscoverySelector {
    private final String className;
    private final String methodName;
    private final String methodParameterTypes;
    private Class<?> javaClass;
    private Method javaMethod;

    MethodSelector(String className, String methodName) {
        this(className, methodName, "");
    }

    MethodSelector(String className, String methodName, String methodParameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, String methodName) {
        this(javaClass, methodName, "");
    }

    MethodSelector(Class<?> javaClass, String methodName, String methodParameterTypes) {
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.javaMethod = method;
        this.methodName = method.getName();
        this.methodParameterTypes = ClassUtils.nullSafeToString(method.getParameterTypes());
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).append("methodName", this.methodName).append("methodParameterTypes", this.methodParameterTypes).toString();
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = ReflectionUtils.loadClass(this.className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + this.className));
        }
    }

    private void lazyLoadJavaMethod() {
        this.lazyLoadJavaClass();
        if (this.javaMethod == null) {
            this.javaMethod = StringUtils.isNotBlank(this.methodParameterTypes) ? ReflectionUtils.findMethod(this.javaClass, this.methodName, this.methodParameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.methodParameterTypes, this.javaClass.getName()))) : ReflectionUtils.findMethod(this.javaClass, this.methodName, new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }
}

