/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine;

import java.util.Optional;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.util.PackageUtils;
import org.gradle.internal.impldep.org.junit.platform.engine.EngineDiscoveryRequest;
import org.gradle.internal.impldep.org.junit.platform.engine.ExecutionRequest;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public interface TestEngine {
    public String getId();

    public TestDescriptor discover(EngineDiscoveryRequest var1, UniqueId var2);

    public void execute(ExecutionRequest var1);

    default public Optional<String> getGroupId() {
        return Optional.empty();
    }

    default public Optional<String> getArtifactId() {
        return PackageUtils.getAttribute(this.getClass(), Package::getImplementationTitle);
    }

    default public Optional<String> getVersion() {
        Optional<String> standalone = PackageUtils.getAttribute(this.getClass(), "Engine-Version-" + this.getId());
        if (standalone.isPresent()) {
            return standalone;
        }
        return Optional.of(PackageUtils.getAttribute(this.getClass(), Package::getImplementationVersion).orElse("DEVELOPMENT"));
    }
}

