/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.logging;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.AbstractLogger;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.AbstractLoggerManager;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private Map loggerCache = new HashMap();
    private String threshold = "info";
    private int currentThreshold;

    public void initialize() {
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.currentThreshold = 0;
        }
    }

    protected int parseThreshold(String text) {
        if ((text = text.trim().toLowerCase(Locale.ENGLISH)).equals("debug")) {
            return 0;
        }
        if (text.equals("info")) {
            return 1;
        }
        if (text.equals("warn")) {
            return 2;
        }
        if (text.equals("error")) {
            return 3;
        }
        if (text.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    public void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    public void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Logger logger : this.loggerCache.values()) {
            logger.setThreshold(currentThreshold);
        }
    }

    public int getThreshold() {
        return this.currentThreshold;
    }

    public void setThreshold(String role, String roleHint, int threshold) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return;
        }
        logger.setThreshold(threshold);
    }

    public int getThreshold(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        AbstractLogger logger = (AbstractLogger)this.loggerCache.get(key);
        if (logger == null) {
            return 0;
        }
        return logger.getThreshold();
    }

    public Logger getLoggerForComponent(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Logger logger = (Logger)this.loggerCache.get(key);
        if (logger != null) {
            return logger;
        }
        logger = this.createLogger(key);
        this.loggerCache.put(key, logger);
        return logger;
    }

    protected abstract Logger createLogger(String var1);

    public void returnComponentLogger(String role, String roleHint) {
        String key = this.toMapKey(role, roleHint);
        Object obj = this.loggerCache.remove(key);
        if (obj == null) {
            System.err.println("There was no such logger '" + key + "' " + this.hashCode() + ".");
        }
    }

    public int getActiveLoggerCount() {
        return this.loggerCache.size();
    }

    public String getThresholdAsString() {
        return this.threshold;
    }
}

