/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.toolchain;

import java.io.File;
import org.gradle.internal.impldep.org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.gradle.internal.impldep.org.apache.maven.toolchain.ToolchainsBuilder;
import org.gradle.internal.impldep.org.apache.maven.toolchain.model.PersistedToolchains;
import org.gradle.internal.impldep.org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.ReaderFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.XmlStreamReader;

@Component(role=ToolchainsBuilder.class, hint="default")
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    @Requirement
    private Logger logger;

    public PersistedToolchains build(File userToolchainsFile) throws MisconfiguredToolchainException {
        PersistedToolchains toolchains = null;
        if (userToolchainsFile != null && userToolchainsFile.isFile()) {
            XmlStreamReader in = null;
            try {
                in = ReaderFactory.newXmlReader(userToolchainsFile);
                toolchains = new MavenToolchainsXpp3Reader().read(in);
            }
            catch (Exception e) {
                throw new MisconfiguredToolchainException("Cannot read toolchains file at " + userToolchainsFile.getAbsolutePath(), e);
            }
            finally {
                IOUtil.close(in);
            }
        } else if (userToolchainsFile != null) {
            this.logger.debug("Toolchains configuration was not found at " + userToolchainsFile);
        }
        return toolchains;
    }
}

