/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.metadata;

import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactScopeEnum;
import org.gradle.internal.impldep.org.apache.maven.repository.metadata.ArtifactMetadata;
import org.gradle.internal.impldep.org.apache.maven.repository.metadata.MetadataResolutionException;

public class MetadataTreeNode {
    ArtifactMetadata md;
    MetadataTreeNode parent;
    int nChildren = 8;
    MetadataTreeNode[] children;

    public int getNChildren() {
        return this.nChildren;
    }

    public void setNChildren(int children) {
        this.nChildren = children;
    }

    public MetadataTreeNode() {
    }

    public MetadataTreeNode(ArtifactMetadata md, MetadataTreeNode parent, boolean resolved, ArtifactScopeEnum scope) {
        if (md != null) {
            md.setArtifactScope(ArtifactScopeEnum.checkScope(scope));
            md.setResolved(resolved);
        }
        this.md = md;
        this.parent = parent;
    }

    public MetadataTreeNode(Artifact af, MetadataTreeNode parent, boolean resolved, ArtifactScopeEnum scope) {
        this(new ArtifactMetadata(af), parent, resolved, scope);
    }

    public void addChild(int index, MetadataTreeNode kid) {
        if (kid == null) {
            return;
        }
        if (this.children == null) {
            this.children = new MetadataTreeNode[this.nChildren];
        }
        this.children[index % this.nChildren] = kid;
    }

    public String toString() {
        return this.md == null ? "no metadata" : this.md.toString();
    }

    public String graphHash() throws MetadataResolutionException {
        if (this.md == null) {
            throw new MetadataResolutionException("treenode without metadata, parent: " + (this.parent == null ? "null" : this.parent.toString()));
        }
        return this.md.groupId + ":" + this.md.artifactId;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public ArtifactMetadata getMd() {
        return this.md;
    }

    public void setMd(ArtifactMetadata md) {
        this.md = md;
    }

    public MetadataTreeNode getParent() {
        return this.parent;
    }

    public void setParent(MetadataTreeNode parent) {
        this.parent = parent;
    }

    public MetadataTreeNode[] getChildren() {
        return this.children;
    }

    public void setChildren(MetadataTreeNode[] children) {
        this.children = children;
    }
}

