/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository;

import java.io.File;
import java.util.EventObject;
import org.gradle.internal.impldep.org.apache.maven.repository.ArtifactTransferResource;

public class ArtifactTransferEvent
extends EventObject {
    public static final int TRANSFER_INITIATED = 0;
    public static final int TRANSFER_STARTED = 1;
    public static final int TRANSFER_COMPLETED = 2;
    public static final int TRANSFER_PROGRESS = 3;
    public static final int TRANSFER_ERROR = 4;
    public static final int REQUEST_GET = 5;
    public static final int REQUEST_PUT = 6;
    private int eventType;
    private int requestType;
    private Exception exception;
    private File localFile;
    private ArtifactTransferResource artifact;
    private long transferredBytes;
    private byte[] dataBuffer;
    private int dataOffset;
    private int dataLength;

    public ArtifactTransferEvent(String wagon, int eventType, int requestType, ArtifactTransferResource artifact) {
        super(wagon);
        this.setEventType(eventType);
        this.setRequestType(requestType);
        this.artifact = artifact;
    }

    public ArtifactTransferEvent(String wagon, Exception exception, int requestType, ArtifactTransferResource artifact) {
        this(wagon, 4, requestType, artifact);
        this.exception = exception;
    }

    public ArtifactTransferResource getResource() {
        return this.artifact;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        switch (requestType) {
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal request type: " + requestType);
            }
        }
        this.requestType = requestType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal event type: " + eventType);
            }
        }
        this.eventType = eventType;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public void setDataBuffer(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        this.dataOffset = dataOffset;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransferEvent[");
        switch (this.getRequestType()) {
            case 5: {
                sb.append("GET");
                break;
            }
            case 6: {
                sb.append("PUT");
                break;
            }
            default: {
                sb.append(this.getRequestType());
            }
        }
        sb.append("|");
        switch (this.getEventType()) {
            case 2: {
                sb.append("COMPLETED");
                break;
            }
            case 4: {
                sb.append("ERROR");
                break;
            }
            case 0: {
                sb.append("INITIATED");
                break;
            }
            case 3: {
                sb.append("PROGRESS");
                break;
            }
            case 1: {
                sb.append("STARTED");
                break;
            }
            default: {
                sb.append(this.getEventType());
            }
        }
        sb.append("|");
        sb.append(this.getLocalFile()).append("|");
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.eventType;
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.localFile == null ? 0 : this.localFile.hashCode());
        result = 31 * result + this.requestType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactTransferEvent other = (ArtifactTransferEvent)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.requestType != other.requestType) {
            return false;
        }
        return this.source.equals(other.source);
    }
}

