/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.gradle.internal.impldep.org.apache.ivy.util.CopyProgressListener;

public interface URLHandler {
    public static final int REQUEST_METHOD_GET = 1;
    public static final int REQUEST_METHOD_HEAD = 2;
    public static final URLInfo UNAVAILABLE = new URLInfo(false, 0L, 0L);

    public boolean isReachable(URL var1);

    public boolean isReachable(URL var1, int var2);

    public long getContentLength(URL var1);

    public long getContentLength(URL var1, int var2);

    public long getLastModified(URL var1);

    public long getLastModified(URL var1, int var2);

    public URLInfo getURLInfo(URL var1);

    public URLInfo getURLInfo(URL var1, int var2);

    public InputStream openStream(URL var1) throws IOException;

    public void download(URL var1, File var2, CopyProgressListener var3) throws IOException;

    public void upload(File var1, URL var2, CopyProgressListener var3) throws IOException;

    public void setRequestMethod(int var1);

    public static class URLInfo {
        private long contentLength;
        private long lastModified;
        private boolean available;

        protected URLInfo(boolean available, long contentLength, long lastModified) {
            this.available = available;
            this.contentLength = contentLength;
            this.lastModified = lastModified;
        }

        public boolean isReachable() {
            return this.available;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

