/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.ivy.Ivy;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyContext;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvyVariableContainer;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.gradle.internal.impldep.org.apache.ivy.util.ConfigurationUtils;

public final class PomModuleDescriptorWriter {
    private static final String SKIP_LINE = "SKIP_LINE";
    private static final PomWriterOptions.ConfigurationScopeMapping DEFAULT_MAPPING = new PomWriterOptions.ConfigurationScopeMapping(new HashMap(){
        {
            this.put("compile", "compile");
            this.put("runtime", "runtime");
            this.put("provided", "provided");
            this.put("test", "test");
            this.put("system", "system");
        }
    });

    private PomModuleDescriptorWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor md, File output, PomWriterOptions options) throws IOException {
        LineNumberReader in = options.getTemplate() == null ? new LineNumberReader(new InputStreamReader(PomModuleDescriptorWriter.class.getResourceAsStream("pom.template"))) : new LineNumberReader(new InputStreamReader(new FileInputStream(options.getTemplate())));
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        try {
            IvySettings settings = IvyContext.getContext().getSettings();
            IvyVariableContainerWrapper variables = new IvyVariableContainerWrapper(settings.getVariableContainer());
            variables.setVariable("ivy.pom.license", SKIP_LINE, true);
            variables.setVariable("ivy.pom.header", SKIP_LINE, true);
            variables.setVariable("ivy.pom.groupId", SKIP_LINE, true);
            variables.setVariable("ivy.pom.artifactId", SKIP_LINE, true);
            variables.setVariable("ivy.pom.version", SKIP_LINE, true);
            variables.setVariable("ivy.pom.packaging", SKIP_LINE, true);
            variables.setVariable("ivy.pom.name", SKIP_LINE, true);
            variables.setVariable("ivy.pom.description", SKIP_LINE, true);
            variables.setVariable("ivy.pom.url", SKIP_LINE, true);
            if (options.getLicenseHeader() != null) {
                variables.setVariable("ivy.pom.license", options.getLicenseHeader(), true);
            }
            if (options.isPrintIvyInfo()) {
                String header = "<!--\n   Apache Maven 2 POM generated by Apache Ivy\n   " + Ivy.getIvyHomeURL() + "\n" + "   Apache Ivy version: " + Ivy.getIvyVersion() + " " + Ivy.getIvyDate() + "\n" + "-->";
                variables.setVariable("ivy.pom.header", header, true);
            }
            PomModuleDescriptorWriter.setModuleVariables(md, variables, options);
            boolean dependenciesPrinted = false;
            int lastIndent = 0;
            int indent = 0;
            String line = in.readLine();
            while (line != null) {
                if ((line = IvyPatternHelper.substituteVariables(line, variables)).indexOf(SKIP_LINE) != -1) {
                    line = in.readLine();
                    continue;
                }
                if (line.trim().length() == 0) {
                    out.println(line);
                    line = in.readLine();
                    continue;
                }
                lastIndent = indent;
                indent = line.indexOf(60);
                if (!dependenciesPrinted && line.indexOf("</dependencies>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(md, out, options, indent, false);
                    dependenciesPrinted = true;
                }
                if (!dependenciesPrinted && line.indexOf("</project>") != -1) {
                    PomModuleDescriptorWriter.printDependencies(md, out, options, lastIndent, true);
                    dependenciesPrinted = true;
                }
                out.println(line);
                line = in.readLine();
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void setModuleVariables(ModuleDescriptor md, IvyVariableContainer variables, PomWriterOptions options) {
        String packaging;
        ModuleRevisionId mrid = md.getModuleRevisionId();
        variables.setVariable("ivy.pom.groupId", mrid.getOrganisation(), true);
        String artifactId = options.getArtifactName();
        if (artifactId == null) {
            artifactId = mrid.getName();
        }
        if ((packaging = options.getArtifactPackaging()) == null) {
            Artifact artifact = PomModuleDescriptorWriter.findArtifact(md, artifactId);
            packaging = artifact == null ? "pom" : artifact.getType();
        }
        variables.setVariable("ivy.pom.artifactId", artifactId, true);
        variables.setVariable("ivy.pom.packaging", packaging, true);
        if (mrid.getRevision() != null) {
            variables.setVariable("ivy.pom.version", mrid.getRevision(), true);
        }
        if (options.getDescription() != null) {
            variables.setVariable("ivy.pom.description", options.getDescription(), true);
        }
        if (md.getHomePage() != null) {
            variables.setVariable("ivy.pom.url", md.getHomePage(), true);
        }
    }

    private static Artifact findArtifact(ModuleDescriptor md, String artifactName) {
        Artifact[] artifacts = md.getAllArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!artifacts[i].getName().equals(artifactName) || artifacts[i].getAttribute("classifier") != null) continue;
            return artifacts[i];
        }
        return null;
    }

    private static void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
    }

    private static void printDependencies(ModuleDescriptor md, PrintWriter out, PomWriterOptions options, int indent, boolean printDependencies) {
        List extraDeps = options.getExtraDependencies();
        DependencyDescriptor[] dds = PomModuleDescriptorWriter.getDependencies(md, options);
        if (!extraDeps.isEmpty() || dds.length > 0) {
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out, indent);
                out.println("<dependencies>");
            }
            Iterator it = extraDeps.iterator();
            while (it.hasNext()) {
                PomWriterOptions.ExtraDependency dep = (PomWriterOptions.ExtraDependency)it.next();
                PomModuleDescriptorWriter.indent(out, indent * 2);
                out.println("<dependency>");
                String groupId = dep.getGroup();
                if (groupId == null) {
                    groupId = md.getModuleRevisionId().getOrganisation();
                }
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<groupId>" + groupId + "</groupId>");
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<artifactId>" + dep.getArtifact() + "</artifactId>");
                String version = dep.getVersion();
                if (version == null) {
                    version = md.getModuleRevisionId().getRevision();
                }
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<version>" + version + "</version>");
                if (dep.getScope() != null) {
                    PomModuleDescriptorWriter.indent(out, indent * 3);
                    out.println("<scope>" + dep.getScope() + "</scope>");
                }
                if (dep.isOptional()) {
                    PomModuleDescriptorWriter.indent(out, indent * 3);
                    out.println("<optional>true</optional>");
                }
                PomModuleDescriptorWriter.indent(out, indent * 2);
                out.println("</dependency>");
            }
            PomWriterOptions.ConfigurationScopeMapping mapping = options.getMapping();
            if (mapping == null) {
                mapping = DEFAULT_MAPPING;
            }
            for (int i = 0; i < dds.length; ++i) {
                ModuleRevisionId mrid = dds[i].getDependencyRevisionId();
                PomModuleDescriptorWriter.indent(out, indent * 2);
                out.println("<dependency>");
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<groupId>" + mrid.getOrganisation() + "</groupId>");
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<artifactId>" + mrid.getName() + "</artifactId>");
                PomModuleDescriptorWriter.indent(out, indent * 3);
                out.println("<version>" + mrid.getRevision() + "</version>");
                String scope = mapping.getScope(dds[i].getModuleConfigurations());
                if (scope != null) {
                    PomModuleDescriptorWriter.indent(out, indent * 3);
                    out.println("<scope>" + scope + "</scope>");
                }
                if (mapping.isOptional(dds[i].getModuleConfigurations())) {
                    PomModuleDescriptorWriter.indent(out, indent * 3);
                    out.println("<optional>true</optional>");
                }
                PomModuleDescriptorWriter.indent(out, indent * 2);
                out.println("</dependency>");
            }
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out, indent);
                out.println("</dependencies>");
            }
        }
    }

    private static DependencyDescriptor[] getDependencies(ModuleDescriptor md, PomWriterOptions options) {
        String[] confs = ConfigurationUtils.replaceWildcards(options.getConfs(), md);
        ArrayList<DependencyDescriptor> result = new ArrayList<DependencyDescriptor>();
        DependencyDescriptor[] dds = md.getDependencies();
        for (int i = 0; i < dds.length; ++i) {
            String[] depConfs = dds[i].getDependencyConfigurations(confs);
            if (depConfs == null || depConfs.length <= 0) continue;
            result.add(dds[i]);
        }
        return result.toArray(new DependencyDescriptor[result.size()]);
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer variables) {
            this.variables = variables;
        }

        public void setVariable(String varName, String value, boolean overwrite) {
            this.localVariables.put(varName, value);
        }

        public void setEnvironmentPrefix(String prefix) {
            this.variables.setEnvironmentPrefix(prefix);
        }

        public String getVariable(String name) {
            String result = this.variables.getVariable(name);
            if (result == null) {
                result = (String)this.localVariables.get(name);
            }
            return result;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

