/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.cache;

import java.io.File;
import java.io.FilenameFilter;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager {
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PATTERN = "resolved-[organisation]-[module]-[revision].xml";
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PROPERTIES_PATTERN = "resolved-[organisation]-[module]-[revision].properties";
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File basedir) {
        this.setBasedir(basedir);
    }

    public File getResolutionCacheRoot() {
        return this.basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public void setResolvedIvyPattern(String cacheResolvedIvyPattern) {
        this.resolvedIvyPattern = cacheResolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public void setResolvedIvyPropertiesPattern(String cacheResolvedIvyPropertiesPattern) {
        this.resolvedIvyPropertiesPattern = cacheResolvedIvyPropertiesPattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getResolvedIvyFileInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    public File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    public File getConfigurationResolveReportInCache(String resolveId, String conf) {
        return new File(this.getResolutionCacheRoot(), resolveId + "-" + conf + ".xml");
    }

    public File[] getConfigurationResolveReportsInCache(String resolveId) {
        final String prefix = resolveId + "-";
        String suffix = ".xml";
        return this.getResolutionCacheRoot().listFiles(new FilenameFilter(){

            public boolean accept(File dir2, String name) {
                return name.startsWith(prefix) && name.endsWith(".xml");
            }
        });
    }

    public String toString() {
        return this.name;
    }

    public void clean() {
        FileUtil.forceDelete(this.getBasedir());
    }
}

