/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.DeserializationConfig;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.JavaType;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.SerializationConfig;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.type.SimpleType;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.util.ClassUtil;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.util.LRUMap;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final BasicBeanDescription STRING_DESC;
    protected static final BasicBeanDescription BOOLEAN_DESC;
    protected static final BasicBeanDescription INT_DESC;
    protected static final BasicBeanDescription LONG_DESC;
    @Deprecated
    public static final BasicClassIntrospector instance;
    protected final LRUMap<JavaType, BasicBeanDescription> _cachedFCA = new LRUMap(16, 64);

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null) {
            desc = this._findStdJdkCollectionDesc(cfg, type);
            if (desc == null) {
                desc = BasicBeanDescription.forSerialization(this.collectProperties(cfg, type, r, true, "set"));
            }
            this._cachedFCA.putIfAbsent(type, desc);
        }
        return desc;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null) {
            desc = this._findStdJdkCollectionDesc(cfg, type);
            if (desc == null) {
                desc = BasicBeanDescription.forDeserialization(this.collectProperties(cfg, type, r, false, "set"));
            }
            this._cachedFCA.putIfAbsent(type, desc);
        }
        return desc;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(cfg, type, r, false));
        this._cachedFCA.putIfAbsent(type, desc);
        return desc;
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null && (desc = this._findStdJdkCollectionDesc(cfg, type)) == null) {
            desc = BasicBeanDescription.forDeserialization(this.collectProperties(cfg, type, r, false, "set"));
        }
        return desc;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null && (desc = this._cachedFCA.get(type)) == null) {
            AnnotatedClass ac = AnnotatedClass.construct(type, config, r);
            desc = BasicBeanDescription.forOtherUse(config, type, ac);
            this._cachedFCA.put(type, desc);
        }
        return desc;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null) {
            AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(type.getRawClass(), config, r);
            desc = BasicBeanDescription.forOtherUse(config, type, ac);
        }
        return desc;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r, boolean forSerialization, String mutatorPrefix) {
        AnnotatedClass ac = AnnotatedClass.construct(type, config, r);
        return this.constructPropertyCollector(config, ac, type, forSerialization, mutatorPrefix);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> config, JavaType type, ClassIntrospector.MixInResolver r, boolean forSerialization) {
        boolean useAnnotations = config.isAnnotationProcessingEnabled();
        AnnotationIntrospector ai = useAnnotations ? config.getAnnotationIntrospector() : null;
        AnnotatedClass ac = AnnotatedClass.construct(type, config, r);
        JsonPOJOBuilder.Value builderConfig = ai == null ? null : ai.findPOJOBuilderConfig(ac);
        String mutatorPrefix = builderConfig == null ? "with" : builderConfig.withPrefix;
        return this.constructPropertyCollector(config, ac, type, forSerialization, mutatorPrefix);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> config, AnnotatedClass ac, JavaType type, boolean forSerialization, String mutatorPrefix) {
        return new POJOPropertiesCollector(config, forSerialization, type, ac, mutatorPrefix);
    }

    protected BasicBeanDescription _findStdTypeDesc(JavaType type) {
        Class<?> cls = type.getRawClass();
        if (cls.isPrimitive()) {
            if (cls == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
            if (cls == Integer.TYPE) {
                return INT_DESC;
            }
            if (cls == Long.TYPE) {
                return LONG_DESC;
            }
        } else if (cls == String.class) {
            return STRING_DESC;
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType type) {
        if (!type.isContainerType() || type.isArrayType()) {
            return false;
        }
        Class<?> raw = type.getRawClass();
        String pkgName = ClassUtil.getPackageName(raw);
        return !(pkgName == null || !pkgName.startsWith("java.lang") && !pkgName.startsWith("java.util") || !Collection.class.isAssignableFrom(raw) && !Map.class.isAssignableFrom(raw));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> cfg, JavaType type) {
        if (this._isStdJDKCollection(type)) {
            AnnotatedClass ac = AnnotatedClass.construct(type, cfg);
            return BasicBeanDescription.forOtherUse(cfg, type, ac);
        }
        return null;
    }

    static {
        AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(String.class, null);
        STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), ac);
        ac = AnnotatedClass.constructWithoutSuperTypes(Boolean.TYPE, null);
        BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), ac);
        ac = AnnotatedClass.constructWithoutSuperTypes(Integer.TYPE, null);
        INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), ac);
        ac = AnnotatedClass.constructWithoutSuperTypes(Long.TYPE, null);
        LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), ac);
        instance = new BasicClassIntrospector();
    }
}

