/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.dd.plist;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.internal.impldep.com.dd.plist.BinaryPropertyListWriter;
import org.gradle.internal.impldep.com.dd.plist.NSArray;
import org.gradle.internal.impldep.com.dd.plist.NSData;
import org.gradle.internal.impldep.com.dd.plist.NSDate;
import org.gradle.internal.impldep.com.dd.plist.NSDictionary;
import org.gradle.internal.impldep.com.dd.plist.NSNumber;
import org.gradle.internal.impldep.com.dd.plist.NSSet;
import org.gradle.internal.impldep.com.dd.plist.NSString;
import org.gradle.internal.impldep.com.dd.plist.UID;

public abstract class NSObject {
    static final String NEWLINE = System.getProperty("line.separator");
    static final int ASCII_LINE_LENGTH = 80;
    private static final String INDENT = "\t";

    abstract void toXML(StringBuilder var1, int var2);

    void assignIDs(BinaryPropertyListWriter out) {
        out.assignID(this);
    }

    abstract void toBinary(BinaryPropertyListWriter var1) throws IOException;

    public String toXMLPropertyList() {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(NEWLINE).append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">").append(NEWLINE).append("<plist version=\"1.0\">").append(NEWLINE);
        this.toXML(xml, 0);
        xml.append(NEWLINE).append("</plist>");
        return xml.toString();
    }

    protected abstract void toASCII(StringBuilder var1, int var2);

    protected abstract void toASCIIGnuStep(StringBuilder var1, int var2);

    void indent(StringBuilder xml, int level) {
        for (int i = 0; i < level; ++i) {
            xml.append(INDENT);
        }
    }

    public Object toJavaObject() {
        if (this instanceof NSArray) {
            return this.deserializeArray();
        }
        if (this instanceof NSDictionary) {
            return this.deserializeMap();
        }
        if (this instanceof NSSet) {
            return this.deserializeSet();
        }
        if (this instanceof NSNumber) {
            return this.deserializeNumber();
        }
        if (this instanceof NSString) {
            return ((NSString)this).getContent();
        }
        if (this instanceof NSData) {
            return ((NSData)this).bytes();
        }
        if (this instanceof NSDate) {
            return ((NSDate)this).getDate();
        }
        if (this instanceof UID) {
            return ((UID)this).getBytes();
        }
        return this;
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return (T)this.toJavaObject(this, clazz, null);
    }

    public static NSObject fromJavaObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NSObject) {
            return (NSObject)object;
        }
        Class<?> objClass = object.getClass();
        if (objClass.isArray()) {
            return NSObject.fromArray(object, objClass);
        }
        if (NSObject.isSimple(objClass)) {
            return NSObject.fromSimple(object, objClass);
        }
        if (Set.class.isAssignableFrom(objClass)) {
            return NSObject.fromSet((Set)object);
        }
        if (Map.class.isAssignableFrom(objClass)) {
            return NSObject.fromMap((Map)object);
        }
        if (Collection.class.isAssignableFrom(objClass)) {
            return NSObject.fromCollection((Collection)object);
        }
        return NSObject.fromPojo(object, objClass);
    }

    private static boolean isSimple(Class<?> clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || clazz == String.class || Date.class.isAssignableFrom(clazz);
    }

    private static Object getInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz.getSimpleName());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz.getSimpleName());
        }
    }

    private static Class<?> getClassForName(String className) {
        int spaceIndex = className.indexOf(32);
        if (spaceIndex != -1) {
            className = className.substring(spaceIndex + 1);
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("long".equals(className)) {
            return Long.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if ("boolean".equals(className)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class " + className, e);
        }
    }

    private static String makeFirstCharLowercase(String input) {
        char[] chars = input.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Object toJavaObject(NSObject payload, Class<?> clazz, Type[] types) {
        if (clazz.isArray()) {
            return this.deserializeArray(payload, clazz);
        }
        if (NSObject.isSimple(clazz)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (clazz == Object.class && !(payload instanceof NSSet) && !(payload instanceof NSArray)) {
            return NSObject.deserializeSimple(payload, clazz);
        }
        if (payload instanceof NSSet && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSArray && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(payload, clazz, types);
        }
        if (payload instanceof NSDictionary) {
            return this.deserializeObject((NSDictionary)payload, clazz, types);
        }
        throw new IllegalArgumentException("Cannot process " + clazz.getSimpleName());
    }

    private Object deserializeObject(NSDictionary payload, Class<?> clazz, Type[] types) {
        HashMap<String, NSObject> map = payload.getHashMap();
        if (Map.class.isAssignableFrom(clazz)) {
            return this.deserializeMap(clazz, types, map);
        }
        Object result = NSObject.getInstance(clazz);
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            if (name.startsWith("get")) {
                getters.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (name.startsWith("set")) {
                setters.put(NSObject.makeFirstCharLowercase(name.substring(3)), method);
                continue;
            }
            if (!name.startsWith("is")) continue;
            getters.put(NSObject.makeFirstCharLowercase(name.substring(2)), method);
        }
        for (Map.Entry entry : map.entrySet()) {
            Method setter = (Method)setters.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            Method getter = (Method)getters.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            if (setter == null || getter == null) continue;
            Class<?> elemClass = getter.getReturnType();
            Type[] elemTypes = null;
            Type type = getter.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                elemTypes = ((ParameterizedType)type).getActualTypeArguments();
            }
            try {
                setter.invoke(result, this.toJavaObject((NSObject)entry.getValue(), elemClass, elemTypes));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access setter " + setter);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke setter " + setter);
            }
        }
        return result;
    }

    private HashMap<String, Object> deserializeMap() {
        HashMap<String, NSObject> originalMap = ((NSDictionary)this).getHashMap();
        HashMap<String, Object> clonedMap = new HashMap<String, Object>(originalMap.size());
        for (String key : originalMap.keySet()) {
            clonedMap.put(key, originalMap.get(key).toJavaObject());
        }
        return clonedMap;
    }

    private Object deserializeMap(Class<?> clazz, Type[] types, Map<String, NSObject> map) {
        Map<String, Object> result;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            result = new HashMap();
        } else {
            Map temp = (Map)NSObject.getInstance(clazz);
            result = temp;
        }
        Class elemClass = Object.class;
        Type[] elemParams = null;
        if (types != null && types.length > 1) {
            Type elemType = types[1];
            if (elemType instanceof ParameterizedType) {
                elemClass = NSObject.getClassForName(((ParameterizedType)elemType).getRawType().toString());
                elemParams = ((ParameterizedType)elemType).getActualTypeArguments();
            } else {
                elemClass = NSObject.getClassForName(elemType.toString());
            }
        }
        for (Map.Entry<String, NSObject> entry : map.entrySet()) {
            result.put(entry.getKey(), this.toJavaObject(entry.getValue(), elemClass, elemParams));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserializeCollection(NSObject payload, Class<?> clazz, Type[] types) {
        void var5_9;
        Collection<Object> result;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            if (List.class.isAssignableFrom(clazz)) {
                result = new ArrayList();
            } else {
                if (!Set.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Could not find a proper implementation for " + clazz.getSimpleName());
                result = new HashSet();
            }
        } else {
            Collection collection = (Collection)NSObject.getInstance(clazz);
            result = collection;
        }
        Class<Object> clazz2 = Object.class;
        Type[] elemTypes = null;
        if (types != null && types.length > 0) {
            if (types[0] instanceof ParameterizedType) {
                Class<?> clazz3 = NSObject.getClassForName(((ParameterizedType)types[0]).getRawType().toString());
                elemTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
            } else {
                Class<?> clazz4 = NSObject.getClassForName(types[0].toString());
            }
        }
        if (payload instanceof NSArray) {
            for (NSObject nsObject : ((NSArray)payload).getArray()) {
                result.add(this.toJavaObject(nsObject, (Class<?>)var5_9, elemTypes));
            }
            return result;
        }
        if (!(payload instanceof NSSet)) throw new IllegalArgumentException("Unknown NS* type " + payload.getClass().getSimpleName());
        for (NSObject nsObject : ((NSSet)payload).getSet()) {
            result.add(this.toJavaObject(nsObject, (Class<?>)var5_9, elemTypes));
        }
        return result;
    }

    private Object[] deserializeArray() {
        NSObject[] originalArray = ((NSArray)this).getArray();
        Object[] clonedArray = new Object[originalArray.length];
        for (int i = 0; i < originalArray.length; ++i) {
            clonedArray[i] = originalArray[i].toJavaObject();
        }
        return clonedArray;
    }

    private Object deserializeArray(NSObject payload, Class<?> clazz) {
        Class<?> elementClass = NSObject.getClassForName(clazz.getComponentType().getName());
        if (payload instanceof NSArray) {
            NSObject[] array = ((NSArray)payload).getArray();
            Object result = Array.newInstance(elementClass, array.length);
            for (int i = 0; i < array.length; ++i) {
                Array.set(result, i, this.toJavaObject(array[i], elementClass, null));
            }
            return result;
        }
        if (payload instanceof NSSet) {
            Set<NSObject> set = ((NSSet)payload).getSet();
            Object result = Array.newInstance(elementClass, set.size());
            int i = 0;
            for (NSObject aSet : set) {
                Array.set(result, i, this.toJavaObject(aSet, elementClass, null));
                ++i;
            }
            return result;
        }
        if (payload instanceof NSData) {
            return NSObject.deserializeData((NSData)payload, elementClass);
        }
        throw new IllegalArgumentException("Unable to map " + payload.getClass().getSimpleName() + " to " + clazz.getName());
    }

    private Set<Object> deserializeSet() {
        Set<NSObject> originalSet = ((NSSet)this).getSet();
        AbstractSet clonedSet = originalSet instanceof LinkedHashSet ? new LinkedHashSet(originalSet.size()) : new TreeSet();
        for (NSObject o : originalSet) {
            clonedSet.add((Object)o.toJavaObject());
        }
        return clonedSet;
    }

    private static Object deserializeData(NSData payload, Class<?> elementClass) {
        if (elementClass == Byte.TYPE) {
            return payload.bytes();
        }
        if (elementClass == Byte.class) {
            byte[] bytes = payload.bytes();
            Object result = Array.newInstance(elementClass, bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                Array.set(result, i, bytes[i]);
            }
            return result;
        }
        throw new IllegalArgumentException("NSData can only be mapped to byte[] or Byte[].");
    }

    private static Object deserializeSimple(NSObject payload, Class<?> clazz) {
        if (payload instanceof NSNumber) {
            return NSObject.deserializeNumber((NSNumber)payload, clazz);
        }
        if (payload instanceof NSDate) {
            return NSObject.deserializeDate((NSDate)payload, clazz);
        }
        if (payload instanceof NSString) {
            return ((NSString)payload).getContent();
        }
        throw new IllegalArgumentException("Cannot map " + payload.getClass().getSimpleName() + " to " + clazz.getSimpleName());
    }

    private static Date deserializeDate(NSDate date, Class<?> clazz) {
        if (clazz == Date.class) {
            return date.getDate();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return date.getDate();
        }
        Date result = (Date)NSObject.getInstance(clazz);
        result.setTime(date.getDate().getTime());
        return result;
    }

    private Object deserializeNumber() {
        NSNumber num = (NSNumber)this;
        switch (num.type()) {
            case 0: {
                long longVal = num.longValue();
                if (longVal > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE) {
                    return longVal;
                }
                return num.intValue();
            }
            case 1: {
                return num.doubleValue();
            }
            case 2: {
                return num.boolValue();
            }
        }
        return num.doubleValue();
    }

    private static Object deserializeNumber(NSNumber number, Class<?> clazz) {
        if (number.isInteger()) {
            if (clazz == Long.TYPE || clazz == Long.class) {
                return number.longValue();
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return number.intValue();
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)number.intValue();
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)number.intValue();
            }
        }
        if (number.isReal()) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                return number.doubleValue();
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf((float)number.doubleValue());
            }
        }
        if (number.isBoolean() && (clazz == Boolean.TYPE || clazz == Boolean.class)) {
            return number.boolValue();
        }
        throw new IllegalArgumentException("Cannot map NSNumber to " + clazz.getSimpleName());
    }

    private static NSObject fromSimple(Object object, Class<?> objClass) {
        if (object instanceof Long || objClass == Long.TYPE) {
            return new NSNumber((Long)object);
        }
        if (object instanceof Integer || objClass == Integer.TYPE) {
            return new NSNumber((Integer)object);
        }
        if (object instanceof Short || objClass == Short.TYPE) {
            return new NSNumber(((Short)object).shortValue());
        }
        if (object instanceof Byte || objClass == Byte.TYPE) {
            return new NSNumber(((Byte)object).byteValue());
        }
        if (object instanceof Double || objClass == Double.TYPE) {
            return new NSNumber((Double)object);
        }
        if (object instanceof Float || objClass == Float.TYPE) {
            return new NSNumber(((Float)object).floatValue());
        }
        if (object instanceof Boolean || objClass == Boolean.TYPE) {
            return new NSNumber((Boolean)object);
        }
        if (object instanceof Date) {
            return new NSDate((Date)object);
        }
        if (objClass == String.class) {
            return new NSString((String)object);
        }
        throw new IllegalArgumentException("Cannot map " + objClass.getSimpleName() + " as a simple type.");
    }

    private static NSDictionary fromPojo(Object object, Class<?> objClass) {
        NSDictionary result = new NSDictionary();
        for (Method method : objClass.getMethods()) {
            if (Modifier.isNative(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                name = NSObject.makeFirstCharLowercase(name.substring(3));
            } else {
                if (!name.startsWith("is")) continue;
                name = NSObject.makeFirstCharLowercase(name.substring(2));
            }
            try {
                result.put(name, NSObject.fromJavaObject(method.invoke(object, new Object[0])));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access getter " + method.getName());
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke getter " + method.getName());
            }
        }
        for (AccessibleObject accessibleObject : objClass.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                result.put(((Field)accessibleObject).getName(), NSObject.fromJavaObject(((Field)accessibleObject).get(object)));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access field " + ((Field)accessibleObject).getName());
            }
        }
        return result;
    }

    private static NSDictionary fromMap(Map<?, ?> map) {
        NSDictionary result = new NSDictionary();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Maps need a String key for mapping to NSDictionary.");
            }
            result.put((String)entry.getKey(), NSObject.fromJavaObject(entry.getValue()));
        }
        return result;
    }

    private static NSObject fromArray(Object object, Class<?> objClass) {
        Class<?> elementClass = objClass.getComponentType();
        if (elementClass == Byte.TYPE || elementClass == Byte.class) {
            return NSObject.fromData(object);
        }
        int size = Array.getLength(object);
        NSObject[] array = new NSObject[size];
        for (int i = 0; i < size; ++i) {
            array[i] = NSObject.fromJavaObject(Array.get(object, i));
        }
        return new NSArray(array);
    }

    private static NSData fromData(Object object) {
        int size = Array.getLength(object);
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (Byte)Array.get(object, i);
        }
        return new NSData(array);
    }

    private static NSArray fromCollection(Collection<?> collection) {
        ArrayList<NSObject> payload = new ArrayList<NSObject>(collection.size());
        for (Object elem : collection) {
            payload.add(NSObject.fromJavaObject(elem));
        }
        return new NSArray(payload.toArray(new NSObject[payload.size()]));
    }

    private static NSSet fromSet(Set<?> set) {
        NSSet result = new NSSet();
        for (Object elem : set) {
            result.addObject(NSObject.fromJavaObject(elem));
        }
        return result;
    }
}

