/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.bsh;

import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.impldep.bsh.BSHAmbiguousName;
import org.gradle.internal.impldep.bsh.BSHArguments;
import org.gradle.internal.impldep.bsh.CallStack;
import org.gradle.internal.impldep.bsh.EvalError;
import org.gradle.internal.impldep.bsh.Interpreter;
import org.gradle.internal.impldep.bsh.Name;
import org.gradle.internal.impldep.bsh.NameSpace;
import org.gradle.internal.impldep.bsh.Primitive;
import org.gradle.internal.impldep.bsh.ReflectError;
import org.gradle.internal.impldep.bsh.SimpleNode;
import org.gradle.internal.impldep.bsh.TargetError;
import org.gradle.internal.impldep.bsh.UtilEvalError;

class BSHMethodInvocation
extends SimpleNode {
    BSHMethodInvocation(int id) {
        super(id);
    }

    BSHAmbiguousName getNameNode() {
        return (BSHAmbiguousName)this.jjtGetChild(0);
    }

    BSHArguments getArgsNode() {
        return (BSHArguments)this.jjtGetChild(1);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace namespace = callstack.top();
        BSHAmbiguousName nameNode = this.getNameNode();
        if (namespace.getParent() != null && namespace.getParent().isClass && (nameNode.text.equals("super") || nameNode.text.equals("this"))) {
            return Primitive.VOID;
        }
        Name name = nameNode.getName(namespace);
        Object[] args = this.getArgsNode().getArguments(callstack, interpreter);
        try {
            return name.invokeMethod(interpreter, args, callstack, this);
        }
        catch (ReflectError e) {
            throw new EvalError("Error in method invocation: " + e.getMessage(), this, callstack);
        }
        catch (InvocationTargetException e) {
            String msg = "Method Invocation " + name;
            Throwable te = e.getTargetException();
            boolean isNative = true;
            if (te instanceof EvalError) {
                isNative = te instanceof TargetError ? ((TargetError)te).inNativeCode() : false;
            }
            throw new TargetError(msg, te, this, callstack, isNative);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(this, callstack);
        }
    }
}

