/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.platforms;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.platforms.KotlinBuildTargets;
import org.jetbrains.kotlin.jps.platforms.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuilderTarget;
import org.jetbrains.kotlin.jps.platforms.TargetPlatformKt;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.TargetId;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J^\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0003J4\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010#\u001a\u00020\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/jps/platforms/KotlinJvmModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/platforms/KotlinModuleBuilderTarget;", "compileContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "compileModuleChunk", "", "allCompiledFiles", "", "Ljava/io/File;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "createTempFileForModuleDesc", "findClassPathRoots", "", "findModularJdkRoot", "findSourceRoots", "", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "context", "generateModuleDescription", "sourceFiles", "hasRemovedFiles", "jps-plugin"})
public final class KotlinJvmModuleBuildTarget
extends KotlinModuleBuilderTarget {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compileModuleChunk(@NotNull Set<File> allCompiledFiles, @NotNull ModuleChunk chunk, @NotNull CommonCompilerArguments commonArguments, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment, @NotNull MultiMap<ModuleBuildTarget, File> filesToCompile, @NotNull FSOperationsHelper fsOperations) {
        Intrinsics.checkParameterIsNotNull(allCompiledFiles, (String)"allCompiledFiles");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkParameterIsNotNull((Object)fsOperations, (String)"fsOperations");
        if (chunk.getModules().size() > 1) {
            MessageCollector messageCollector = environment.getMessageCollector();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are only partially supported. The following modules depend on each other: ");
            Set set = chunk.getModules();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.modules");
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, (Function1)compileModuleChunk.1.INSTANCE, (int)30, null)).append(" ").append("Kotlin will compile them, but some strange effect may happen").toString(), null, 4, null);
        }
        Collection collection = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection);
        Set<ModuleBuildTarget> processedTargetsWithRemoved = KotlinBuilderKt.getProcessedTargetsWithRemovedFilesContainer(this.getContext());
        int totalRemovedFiles = 0;
        Iterator iterator2 = chunk.getTargets().iterator();
        while (iterator2.hasNext()) {
            ModuleBuildTarget target;
            ModuleBuildTarget moduleBuildTarget = target = (ModuleBuildTarget)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            List<File> removedFilesInTarget = KotlinSourceFileCollector.INSTANCE.getRemovedKotlinFiles(dirtyFilesHolder2, moduleBuildTarget);
            if (removedFilesInTarget.isEmpty() || !processedTargetsWithRemoved.add(target)) continue;
            totalRemovedFiles += removedFilesInTarget.size();
        }
        File moduleFile = this.generateModuleDescription(this.getContext(), chunk, filesToCompile, totalRemovedFiles != 0);
        if (moduleFile == null) {
            Logger logger = KotlinBuilder.Companion.getLOG();
            StringBuilder stringBuilder = new StringBuilder().append("Not compiling, because no files affected: ");
            Set set = filesToCompile.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"filesToCompile.keySet()");
            logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)compileModuleChunk.2.INSTANCE, (int)31, null)).toString());
            return false;
        }
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        JpsModule module = moduleBuildTarget.getModule();
        Logger logger = KotlinBuilder.Companion.getLOG();
        StringBuilder stringBuilder = new StringBuilder().append("Compiling to JVM ").append(filesToCompile.values().size()).append(" files").append(totalRemovedFiles == 0 ? "" : " (" + totalRemovedFiles + " removed files)").append(" in ");
        Set set = filesToCompile.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"filesToCompile.keySet()");
        logger.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)compileModuleChunk.3.INSTANCE, (int)31, null)).toString());
        try {
            JpsKotlinCompilerRunner compilerRunner = new JpsKotlinCompilerRunner();
            JpsModule jpsModule = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
            compilerRunner.runK2JvmCompiler(commonArguments, ModuleSettingsKt.getK2JvmCompilerArguments(jpsModule), ModuleSettingsKt.getKotlinCompilerSettings(module), environment, moduleFile);
        }
        finally {
            if (Intrinsics.areEqual((Object)System.getProperty("kotlin.jps.delete.module.file.after.build"), (Object)"false") ^ true) {
                moduleFile.delete();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final File generateModuleDescription(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) {
        void $receiver$iv$iv;
        Object element$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Iterable<KotlinJvmModuleBuildTarget> destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinJvmModuleBuildTarget kotlinJvmModuleBuildTarget;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            ModuleBuildTarget it = (ModuleBuildTarget)element$iv$iv;
            KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(this.getContext());
            ModuleBuildTarget moduleBuildTarget = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
            KotlinModuleBuilderTarget kotlinModuleBuilderTarget = kotlinBuildTargets.get(moduleBuildTarget);
            if (!(kotlinModuleBuilderTarget instanceof KotlinJvmModuleBuildTarget)) {
                kotlinModuleBuilderTarget = null;
            }
            if ((KotlinJvmModuleBuildTarget)kotlinModuleBuilderTarget == null) continue;
            KotlinJvmModuleBuildTarget it$iv$iv = kotlinJvmModuleBuildTarget;
            destination$iv$iv.add(it$iv$iv);
        }
        List targets = (List)destination$iv$iv;
        Iterable $receiver$iv2 = targets;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            element$iv$iv = (KotlinJvmModuleBuildTarget)item$iv$iv;
            Collection collection = destination$iv$iv2;
            File file = it.getOutputDir();
            collection.add(file);
        }
        Set outputDirs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        BuildLoggingManager buildLoggingManager = context.getLoggingManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildLoggingManager, (String)"context.loggingManager");
        ProjectBuilderLogger logger = buildLoggingManager.getProjectBuilderLogger();
        for (KotlinJvmModuleBuildTarget target : targets) {
            Collection moduleSources;
            Collection collection;
            File outputDir2 = target.getOutputDir();
            List<File> friendDirs = target.getFriendOutputDirs();
            if (IncrementalCompilation.isEnabled() && target.getExpectedBy().isEmpty()) {
                Collection collection2 = sourceFiles.get((Object)target.getJpsModuleBuildTarget());
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"sourceFiles.get(target.jpsModuleBuildTarget)");
            } else {
                collection = target.getSources();
            }
            Collection $i$a$1$map = moduleSources = collection;
            if (!$i$a$1$map.isEmpty() || hasRemovedFiles) {
                noSources = false;
                ProjectBuilderLogger projectBuilderLogger = logger;
                Intrinsics.checkExpressionValueIsNotNull((Object)projectBuilderLogger, (String)"logger");
                if (projectBuilderLogger.isEnabled()) {
                    logger.logCompiledFiles(moduleSources, "Kotlin Builder", "Compiling files:");
                }
            }
            TargetId kotlinModuleId = target.getTargetId();
            String string = kotlinModuleId.getName();
            String string2 = outputDir2.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"outputDir.absolutePath");
            builder.addModule(string, string2, moduleSources, (Iterable<JvmSourceRoot>)target.findSourceRoots(context), (Iterable<? extends File>)target.findClassPathRoots(), target.findModularJdkRoot(), kotlinModuleId.getType(), this.isTests(), outputDirs, (Iterable<? extends File>)friendDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = this.createTempFileForModuleDesc(chunk);
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    private final File createTempFileForModuleDesc(ModuleChunk chunk) {
        Object object;
        Object object2;
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"chunk.representativeTarget().module");
        $receiver.append(StringUtil.sanitizeJavaIdentifier((String)jpsModule.getName()));
        if (chunk.containsTests()) {
            $receiver.append("-test");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String readableSuffix = string;
        String string2 = System.getProperty("kotlin.jps.dir.for.module.files");
        if (string2 != null) {
            Object it = object2 = string2;
            object2 = new File((String)it);
            object = ((File)(it = object2)).isDirectory() ? object2 : null;
        } else {
            object = null;
        }
        Object dir = object;
        try {
            File file = File.createTempFile("kjps", readableSuffix + ".script.xml", (File)dir);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File.createTempFile(\"kjp\u2026fix + \".script.xml\", dir)");
            object2 = file;
        }
        catch (IOException e) {
            File file;
            try {
                File file2 = File.createTempFile("kjps", ".script.xml", dir);
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"File.createTempFile(\"kjps\", \".script.xml\", dir)");
                file = file2;
            }
            catch (IOException e2) {
                StringBuilder stringBuilder2;
                StringBuilder $receiver2 = stringBuilder2 = new StringBuilder();
                $receiver2.append("Could not create module file when building chunk " + chunk);
                if (dir != null) {
                    $receiver2.append(" in dir " + dir);
                }
                String string3 = stringBuilder2.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                String message = string3;
                throw (Throwable)new RuntimeException(message, e2);
            }
            object2 = file;
        }
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Collection<File> findClassPathRoots() {
        v0 = this.getAllDependencies().classes();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"allDependencies.classes()");
        v1 = v0.getRoots();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"allDependencies.classes().roots");
        var2_2 = $receiver$iv = (Iterable)v1;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            file = (File)element$iv$iv;
            if (file.exists()) ** GOTO lbl-1000
            v2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"file");
            extension = FilesKt.getExtension((File)v2);
            if (!Intrinsics.areEqual((Object)extension, (Object)"class") && !Intrinsics.areEqual((Object)extension, (Object)"jar")) {
                v3 = false;
            } else lbl-1000:
            // 2 sources

            {
                v3 = true;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public final File findModularJdkRoot() {
        Object v3;
        block2: {
            Collection urls2;
            JpsJavaDependenciesRootsEnumerator jpsJavaDependenciesRootsEnumerator = JpsJavaExtensionService.dependencies((JpsModule)this.getModule()).satisfying((Condition)findModularJdkRoot.urls.1.INSTANCE).classes();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesRootsEnumerator, (String)"JpsJavaExtensionService.\u2026 }\n            .classes()");
            Collection collection = urls2 = jpsJavaDependenciesRootsEnumerator.getUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"urls");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                String it;
                String string = it = (String)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (!StringsKt.startsWith$default((String)string, (String)"jrt://", (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        String string = v3;
        if (string == null) {
            return null;
        }
        String url = string;
        return new File(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)url, (String)"jrt://", null, (int)2, null), (String)"!/", null, (int)2, null));
    }

    @NotNull
    public final List<JvmSourceRoot> findSourceRoots(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        List roots = projectDescriptor.getBuildRootIndex().getTargetRoots((BuildTarget)this.getJpsModuleBuildTarget(), context);
        ArrayList result = ContainerUtil.newArrayList();
        Iterator iterator2 = roots.iterator();
        while (iterator2.hasNext()) {
            File file;
            JavaSourceRootDescriptor root;
            JavaSourceRootDescriptor javaSourceRootDescriptor = root = (JavaSourceRootDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootDescriptor, (String)"root");
            File file2 = javaSourceRootDescriptor.getRootFile();
            String prefix = root.getPackagePrefix();
            if (!file2.exists()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            String string = prefix;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefix");
            CharSequence charSequence = string;
            ArrayList arrayList = result;
            boolean bl = charSequence.length() == 0;
            String string2 = bl ? null : prefix;
            File file3 = file;
            arrayList.add(new JvmSourceRoot(file3, string2));
        }
        ArrayList arrayList = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"result");
        return arrayList;
    }

    public KotlinJvmModuleBuildTarget(@NotNull CompileContext compileContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkParameterIsNotNull((Object)compileContext, (String)"compileContext");
        Intrinsics.checkParameterIsNotNull((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(compileContext, jpsModuleBuildTarget);
    }
}

