/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.platforms;

import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuilderTarget;
import org.jetbrains.kotlin.jps.platforms.TargetPlatformKt;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010%\u001a\u00020&H\u0002J^\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00050/2\u0006\u00101\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0012042\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020 H\u0002J\b\u00108\u001a\u00020 H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000b\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/jps/platforms/KotlinJsModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/platforms/KotlinModuleBuilderTarget;", "compileContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "dependenciesMetaFiles", "", "", "getDependenciesMetaFiles", "()Ljava/util/List;", "explicitOutputPath", "getExplicitOutputPath", "()Ljava/lang/String;", "friendBuildTargetsMetaFiles", "getFriendBuildTargetsMetaFiles", "implicitOutputFile", "Ljava/io/File;", "getImplicitOutputFile", "()Ljava/io/File;", "libraryFiles", "getLibraryFiles", "outputFile", "getOutputFile", "outputFileBaseName", "getOutputFileBaseName", "outputMetaFile", "getOutputMetaFile", "sourceMapRoots", "getSourceMapRoots", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "", "compileModuleChunk", "allCompiledFiles", "", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "copyJsLibraryFilesIfNeeded", "doAfterBuild", "jps-plugin"})
public final class KotlinJsModuleBuildTarget
extends KotlinModuleBuilderTarget {
    @Override
    public boolean compileModuleChunk(@NotNull Set<File> allCompiledFiles, @NotNull ModuleChunk chunk, @NotNull CommonCompilerArguments commonArguments, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment, @NotNull MultiMap<ModuleBuildTarget, File> filesToCompile, @NotNull FSOperationsHelper fsOperations) {
        Intrinsics.checkParameterIsNotNull(allCompiledFiles, (String)"allCompiledFiles");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkParameterIsNotNull((Object)fsOperations, (String)"fsOperations");
        boolean bl = Intrinsics.areEqual((Object)chunk.representativeTarget(), (Object)this.getJpsModuleBuildTarget());
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.reportAndSkipCircular(chunk, environment)) {
            return false;
        }
        List<File> sources2 = this.getSources();
        if (sources2.isEmpty()) {
            return false;
        }
        List libraries = CollectionsKt.plus((Collection)this.getLibraryFiles(), (Iterable)this.getDependenciesMetaFiles());
        new JpsKotlinCompilerRunner().runK2JsCompiler(commonArguments, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, (Collection<? extends File>)sources2, (Collection<? extends File>)this.getSourceMapRoots(), libraries, this.getFriendBuildTargetsMetaFiles(), this.getOutputFile());
        return true;
    }

    @Override
    public void doAfterBuild() {
        this.copyJsLibraryFilesIfNeeded();
    }

    private final void copyJsLibraryFilesIfNeeded() {
        if (ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(this.getOutputDir(), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            List<String> list = this.getLibraryFiles();
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            JsLibraryUtils.copyJsFilesFromLibraries(list, string, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getSourceMapRoots() {
        List list;
        CharSequence charSequence = ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMapPrefix();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            list = CollectionsKt.emptyList();
        } else {
            void var3_3;
            Comparable<URI> comparable;
            URI it;
            Collection collection;
            Iterable $receiver$iv$iv;
            JpsUrlList jpsUrlList = this.getModule().getContentRootsList();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsUrlList, (String)"module.contentRootsList");
            List list2 = jpsUrlList.getUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"module.contentRootsList.urls");
            Iterable $receiver$iv = list2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                comparable = URI.create((String)((Object)it));
                collection.add(comparable);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                URI uRI = it = (URI)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"it");
                if (!Intrinsics.areEqual((Object)uRI.getScheme(), (Object)"file")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (URI)item$iv$iv;
                collection = destination$iv$iv;
                URI uRI = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"it");
                comparable = new File(uRI.getPath());
                collection.add(comparable);
            }
            list = (List)var3_3;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFriendBuildTargetsMetaFiles() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getFriendBuildTargets();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            String string;
            Object object;
            Object element$iv$iv = element$iv$iv$iv;
            KotlinModuleBuilderTarget it = (KotlinModuleBuilderTarget)element$iv$iv;
            KotlinModuleBuilderTarget kotlinModuleBuilderTarget = it;
            if (!(kotlinModuleBuilderTarget instanceof KotlinJsModuleBuildTarget)) {
                kotlinModuleBuilderTarget = null;
            }
            String string2 = (object = (KotlinJsModuleBuildTarget)kotlinModuleBuilderTarget) != null && (object = ((KotlinJsModuleBuildTarget)object).getOutputMetaFile()) != null && (object = ((File)object).getAbsoluteFile()) != null ? ((File)object).toString() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public final File getOutputFile() {
        File file;
        String string = this.getExplicitOutputPath();
        if (string != null) {
            String string2;
            String it = string2 = string;
            file = new File(it);
        } else {
            file = this.getImplicitOutputFile();
        }
        return file;
    }

    private final String getExplicitOutputPath() {
        return this.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this.getModule());
    }

    private final File getImplicitOutputFile() {
        String suffix = this.isTests() ? "_test" : "";
        return new File(this.getOutputDir(), this.getModule().getName() + suffix + ".js");
    }

    private final String getOutputFileBaseName() {
        String string = this.getOutputFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.path");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    @NotNull
    public final File getOutputMetaFile() {
        return new File(this.getOutputFileBaseName() + ".meta.js");
    }

    private final List<String> getLibraryFiles() {
        List list;
        List result = list = (List)new ArrayList();
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = this.getAllDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"allDependencies");
        for (JpsLibrary library : jpsJavaDependenciesEnumerator.getLibraries()) {
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot, (String)"root");
                String string = JpsPathUtil.urlToPath((String)jpsLibraryRoot.getUrl());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string);
            }
        }
        return list;
    }

    private final List<String> getDependenciesMetaFiles() {
        List list;
        List result = list = (List)new ArrayList();
        this.getAllDependencies().processModules((Consumer)new Consumer<JpsModule>(result, this){
            final /* synthetic */ List $result;
            final /* synthetic */ KotlinJsModuleBuildTarget this$0;
            {
                this.$result = list;
                this.this$0 = kotlinJsModuleBuildTarget;
            }

            public final void consume(JpsModule module) {
                if (this.this$0.isTests()) {
                    JpsModule jpsModule = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                    KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, true);
                }
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, false);
            }
        });
        return list;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        File metaFile;
        Collection collection;
        KotlinModuleBuilderTarget dependencyBuildTarget = TargetPlatformKt.getKotlinBuildTargets(this.getContext()).get(TargetPlatformKt.ModuleBuildTarget(module, isTests));
        if (Intrinsics.areEqual((Object)dependencyBuildTarget, (Object)this) ^ true && dependencyBuildTarget instanceof KotlinJsModuleBuildTarget && !(collection = (Collection)dependencyBuildTarget.getSources()).isEmpty() && (metaFile = ((KotlinJsModuleBuildTarget)dependencyBuildTarget).getOutputMetaFile()).exists()) {
            String string = metaFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metaFile.absolutePath");
            result.add(string);
        }
    }

    public KotlinJsModuleBuildTarget(@NotNull CompileContext compileContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkParameterIsNotNull((Object)compileContext, (String)"compileContext");
        Intrinsics.checkParameterIsNotNull((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(compileContext, jpsModuleBuildTarget);
    }

    public static final /* synthetic */ void access$addDependencyMetaFile(KotlinJsModuleBuildTarget $this, @NotNull JpsModule module, @NotNull List result, boolean isTests) {
        $this.addDependencyMetaFile(module, result, isTests);
    }
}

