/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.JpsICReporter;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\b\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\b\u001a$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a$\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060!2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u001a\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&\u001a,\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e*\u00020(2\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030+0*2\u0006\u0010%\u001a\u00020&H\u0002\u001a8\u0010,\u001a\u00020-*\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010%\u001a\u00020&2\u0006\u0010/\u001a\u0002002\f\u0010)\u001a\b\u0012\u0004\u0012\u0002010*H\u0002\"(\u0010\u0000\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0004*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00062"}, d2={"ALL_COMPILED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "PROCESSED_TARGETS_WITH_REMOVED_FILES", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "processedTargetsWithRemovedFilesContainer", "Lorg/jetbrains/jps/incremental/CompileContext;", "getProcessedTargetsWithRemovedFilesContainer", "(Lorg/jetbrains/jps/incremental/CompileContext;)Ljava/util/Set;", "getAllCompiledFilesContainer", "context", "getDependenciesRecursively", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "module", "kind", "Lorg/jetbrains/jps/model/java/JpsJavaClasspathKind;", "getDependentTargets", "compilingChunk", "Lorg/jetbrains/jps/ModuleChunk;", "getIncrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJvmCache;", "chunk", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "hasKotlinDirtyOrRemovedFiles", "", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "jvmBuildMetaInfoFile", "target", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "getDirtyFiles", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "caches", "", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "processChangesUsingLookups", "", "compiledFiles", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "jps-plugin"})
public final class KotlinBuilderKt {
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_kotlin_compiled_files_");
    private static final Key<Set<ModuleBuildTarget>> PROCESSED_TARGETS_WITH_REMOVED_FILES = Key.create((String)"_processed_targets_with_removed_files_");

    /*
     * WARNING - void declaration
     */
    private static final void processChangesUsingLookups(@NotNull ChangesCollector $receiver, Set<? extends File> compiledFiles, BuildDataManager dataManager, FSOperationsHelper fsOperations, Iterable<? extends IncrementalJvmCache> caches) {
        void $receiver$iv$iv;
        Iterable<? extends IncrementalJvmCache> $receiver$iv;
        Iterable<? extends IncrementalJvmCache> iterable = $receiver$iv = caches;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IncrementalJvmCache it = (IncrementalJvmCache)element$iv$iv;
            Iterable list$iv$iv = it.getThisWithDependentCaches();
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List allCaches = (List)destination$iv$iv;
        JpsICReporter reporter = new JpsICReporter();
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.1.INSTANCE));
        Set<File> dirtyFiles = KotlinBuilderKt.getDirtyFiles($receiver, allCaches, dataManager);
        Iterable iterable2 = dirtyFiles;
        FSOperationsHelper fSOperationsHelper = fsOperations;
        Iterable iterable3 = iterable2;
        fSOperationsHelper.markInChunkOrDependents(iterable3, compiledFiles);
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<File> getDirtyFiles(@NotNull ChangesCollector $receiver, Iterable<? extends IncrementalCacheCommon<?>> caches, BuildDataManager dataManager) {
        void dirtyLookupSymbols;
        JpsICReporter reporter = new JpsICReporter();
        DirtyData dirtyData = BuildUtilKt.getDirtyData($receiver, caches, reporter);
        Collection<LookupSymbol> collection = dirtyData.component1();
        Collection<FqName> dirtyClassFqNames = dirtyData.component2();
        Set dirtyFilesFromLookups2 = (Set)JpsLookupStorageKt.withLookupStorage(dataManager, (Function1)new Function1<LookupStorage, Set<? extends File>>((Collection)dirtyLookupSymbols, reporter){
            final /* synthetic */ Collection $dirtyLookupSymbols;
            final /* synthetic */ JpsICReporter $reporter;

            @NotNull
            public final Set<File> invoke(@NotNull LookupStorage it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BuildUtilKt.mapLookupSymbolsToFiles$default(it, this.$dirtyLookupSymbols, this.$reporter, null, 8, null);
            }
            {
                this.$dirtyLookupSymbols = collection;
                this.$reporter = jpsICReporter;
                super(1);
            }
        });
        return SetsKt.plus((Set)dirtyFilesFromLookups2, (Iterable)BuildUtilKt.mapClassesFqNamesToFiles$default(caches, dirtyClassFqNames, reporter, null, 8, null));
    }

    private static final LookupTracker getLookupTracker(JpsProject project) {
        Object testLookupTracker;
        Object object = TestingContextKt.getTestingContext(project);
        if (object == null || (object = ((TestingContext)object).getLookupTracker()) == null) {
            object = testLookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if (IncrementalCompilation.isEnabled()) {
            return new LookupTrackerImpl((LookupTracker)testLookupTracker);
        }
        return testLookupTracker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ModuleBuildTarget, JpsIncrementalJvmCache> getIncrementalCaches(ModuleChunk chunk, CompileContext context) {
        void $receiver$iv$iv;
        Set<ModuleBuildTarget> dependentTargets = KotlinBuilderKt.getDependentTargets(chunk, context);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Map<ModuleBuildTarget, JpsIncrementalJvmCache> chunkCaches2 = CollectionsKt.keysToMap(set, (Function1)new Function1<ModuleBuildTarget, JpsIncrementalJvmCache>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @NotNull
            public final JpsIncrementalJvmCache invoke(ModuleBuildTarget it) {
                BuildDataManager buildDataManager = this.$dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                ModuleBuildTarget moduleBuildTarget = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                return JpsIncrementalJvmCacheKt.getKotlinCache(buildDataManager, moduleBuildTarget);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        Iterable $receiver$iv = dependentTargets;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            BuildDataManager buildDataManager = dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            JpsIncrementalJvmCache jpsIncrementalJvmCache = JpsIncrementalJvmCacheKt.getKotlinCache(buildDataManager, (ModuleBuildTarget)it);
            collection.add(jpsIncrementalJvmCache);
        }
        List dependentCaches = (List)destination$iv$iv;
        for (JpsIncrementalJvmCache chunkCache : chunkCaches2.values()) {
            for (JpsIncrementalJvmCache dependentCache : dependentCaches) {
                chunkCache.addDependentCache(dependentCache);
            }
        }
        return chunkCaches2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleBuildTarget> getDependentTargets(@NotNull ModuleChunk compilingChunk, @NotNull CompileContext context) {
        Iterator iterator2;
        boolean bl;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)compilingChunk, (String)"compilingChunk");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Set set = compilingChunk.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"compilingChunk.targets");
            Iterable $receiver$iv = set;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleBuildTarget it;
                    ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                    if (!moduleBuildTarget.isTests()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean compilingChunkIsTests = bl;
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)compilingChunkIsTests);
        Function1 dependsOnCompilingChunk$ = new Function1<BuildTarget<?>, Boolean>(compilingChunkIsTests, classpathKind, compilingChunk){
            final /* synthetic */ boolean $compilingChunkIsTests;
            final /* synthetic */ JpsJavaClasspathKind $classpathKind;
            final /* synthetic */ ModuleChunk $compilingChunk;

            public final boolean invoke(@NotNull BuildTarget<?> target) {
                Intrinsics.checkParameterIsNotNull(target, (String)"target");
                if (!(target instanceof ModuleBuildTarget) || this.$compilingChunkIsTests && !((ModuleBuildTarget)target).isTests()) {
                    return false;
                }
                JpsModule jpsModule = ((ModuleBuildTarget)target).getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                JpsJavaClasspathKind jpsJavaClasspathKind = this.$classpathKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaClasspathKind, (String)"classpathKind");
                Set dependencies = KotlinBuilderKt.access$getDependenciesRecursively(jpsModule, jpsJavaClasspathKind);
                return ContainerUtil.intersects((Collection)dependencies, (Collection)this.$compilingChunk.getModules());
            }
            {
                this.$compilingChunkIsTests = bl;
                this.$classpathKind = jpsJavaClasspathKind;
                this.$compilingChunk = moduleChunk;
                super(1);
            }
        };
        HashSet dependentTargets = new HashSet();
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        Iterator sortedChunks = projectDescriptor.getBuildTargetIndex().getSortedTargetChunks(context).iterator();
        while (sortedChunks.hasNext()) {
            Object e = sortedChunks.next();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"sortedChunks.next()");
            if (!Intrinsics.areEqual((Object)((BuildTargetChunk)e).getTargets(), (Object)compilingChunk.getTargets())) continue;
            break;
        }
        Iterator iterator3 = iterator2 = sortedChunks;
        while (iterator3.hasNext()) {
            void $receiver$iv$iv;
            boolean bl2;
            Iterable $receiver$iv;
            BuildTargetChunk followingChunk;
            block10: {
                BuildTargetChunk buildTargetChunk = followingChunk = (BuildTargetChunk)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTargetChunk, (String)"followingChunk");
                Set set = buildTargetChunk.getTargets();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"followingChunk.targets");
                $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        BuildTarget p1 = (BuildTarget)element$iv;
                        if (!dependsOnCompilingChunk$.invoke(p1)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) continue;
            Set set = followingChunk.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"followingChunk.targets");
            $receiver$iv = set;
            HashSet hashSet = dependentTargets;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ModuleBuildTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            hashSet.addAll(list);
        }
        return dependentTargets;
    }

    private static final Set<JpsModule> getDependenciesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"JpsJavaExtensionService.\u2026recursivelyExportedOnly()");
        Set set = jpsJavaDependenciesEnumerator.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JpsJavaExtensionService.\u2026elyExportedOnly().modules");
        return set;
    }

    @NotNull
    public static final Set<File> getAllCompiledFilesContainer(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = (Set)new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        return allCompiledFiles;
    }

    @NotNull
    public static final Set<ModuleBuildTarget> getProcessedTargetsWithRemovedFilesContainer(@NotNull CompileContext $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set set = (Set)PROCESSED_TARGETS_WITH_REMOVED_FILES.get((UserDataHolder)$receiver);
        if (set == null) {
            set = new HashSet();
            PROCESSED_TARGETS_WITH_REMOVED_FILES.set((UserDataHolder)$receiver, (Object)set);
        }
        return set;
    }

    private static final boolean hasKotlinDirtyOrRemovedFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, ModuleChunk chunk) {
        boolean bl;
        block5: {
            if (!dirtyFilesHolder2.hasDirtyFiles() && !dirtyFilesHolder2.hasRemovedFiles()) {
                return false;
            }
            if (!KotlinSourceFileCollector.INSTANCE.getDirtySourceFiles(dirtyFilesHolder2).isEmpty()) {
                return true;
            }
            Set set = chunk.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
            Iterable $receiver$iv = set;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleBuildTarget it;
                    ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                    Collection collection = KotlinSourceFileCollector.INSTANCE.getRemovedKotlinFiles(dirtyFilesHolder2, moduleBuildTarget);
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final File jvmBuildMetaInfoFile(@NotNull ModuleBuildTarget target, @NotNull BuildDataManager dataManager) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        return new File(dataManager.getDataPaths().getTargetDataRoot((BuildTarget)target), "jvm-build-meta-info.txt");
    }

    @NotNull
    public static final /* synthetic */ Map access$getIncrementalCaches(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        return KotlinBuilderKt.getIncrementalCaches(chunk, context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDirtyFiles(@NotNull ChangesCollector $receiver, @NotNull Iterable caches, @NotNull BuildDataManager dataManager) {
        return KotlinBuilderKt.getDirtyFiles($receiver, caches, dataManager);
    }

    public static final /* synthetic */ boolean access$hasKotlinDirtyOrRemovedFiles(@NotNull DirtyFilesHolder dirtyFilesHolder2, @NotNull ModuleChunk chunk) {
        return KotlinBuilderKt.hasKotlinDirtyOrRemovedFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder2, chunk);
    }

    @NotNull
    public static final /* synthetic */ LookupTracker access$getLookupTracker(@NotNull JpsProject project) {
        return KotlinBuilderKt.getLookupTracker(project);
    }

    public static final /* synthetic */ void access$processChangesUsingLookups(@NotNull ChangesCollector $receiver, @NotNull Set compiledFiles, @NotNull BuildDataManager dataManager, @NotNull FSOperationsHelper fsOperations, @NotNull Iterable caches) {
        KotlinBuilderKt.processChangesUsingLookups($receiver, compiledFiles, dataManager, fsOperations, caches);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDependenciesRecursively(@NotNull JpsModule module, @NotNull JpsJavaClasspathKind kind) {
        return KotlinBuilderKt.getDependenciesRecursively(module, kind);
    }
}

