/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.JvmBuildMetaInfo;
import org.jetbrains.kotlin.build.JvmBuildMetaInfoKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.CacheVersion;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.BuildLogger;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilder$MessageCollectorAdapter$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinBuilder$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionProvider;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.platforms.KotlinBuildTargets;
import org.jetbrains.kotlin.jps.platforms.KotlinJsModuleBuildTarget;
import org.jetbrains.kotlin.jps.platforms.KotlinModuleBuilderTarget;
import org.jetbrains.kotlin.jps.platforms.TargetPlatformKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u0001:\u0002OPB\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J>\u0010'\u001a\u0004\u0018\u00010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002JD\u00100\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J|\u00101\u001a\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00105\u001a\u00020$2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u00106\u001a\u00020(2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u000204082\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002090*2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010:\u001a\u0012\u0012\u0004\u0012\u00020<0;j\b\u0012\u0004\u0012\u00020<`=H\u0016J2\u0010>\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0?0*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020<H\u0016J \u0010D\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010E\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010F\u001a\u00020<H\u0002J*\u0010G\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0?0*H\u0002J \u0010I\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00105\u001a\u00020$H\u0002Jn\u0010J\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u000204082\u0018\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0K0*2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020L0*H\u0002JH\u0010M\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00120\u001a2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020408H\u0002J\u0012\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "applyActionsOnCacheVersionChange", "", "actions", "", "Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;", "cacheVersionsProvider", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionProvider;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "targets", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "buildStarted", "checkCachesVersions", "chunkBuildFinished", "chunkBuildStarted", "compilerArgumentsForChunk", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "computeKotlinPathsForJpsPlugin", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "createCompileEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "doBuild", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "allCompiledFiles", "Ljava/io/File;", "commonArguments", "environment", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "markAdditionalFilesForInitialRound", "markAllKotlinForRebuild", "reason", "registerOutputItems", "outputItems", "saveVersions", "updateJavaMappings", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJvmCache;", "updateLookupStorage", "allTargets", "Companion", "MessageCollectorAdapter", "jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String JVM_BUILD_META_INFO_FILE_NAME = "jvm-build-meta-info.txt";
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LOG.debug("==========================================");
        LOG.info("is Kotlin incremental compilation enabled: " + IncrementalCompilation.isEnabled());
        LOG.info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info("Label in local history: " + historyLabel);
        }
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        block12: {
            boolean bl;
            BuildDataManager dataManager;
            Set targets;
            BuildLogger buildLogger;
            block11: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
                super.chunkBuildStarted(context, chunk);
                if (JpsUtilKt.isDummy(chunk, context)) {
                    return;
                }
                TestingContext testingContext = TestingContextKt.getTestingContext(context);
                BuildLogger buildLogger2 = buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
                if (buildLogger2 != null) {
                    buildLogger2.buildStarted(context, chunk);
                }
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                    return;
                }
                targets = chunk.getTargets();
                BuildDataManager buildDataManager = dataManager = context.getProjectDescriptor().dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                HasKotlinMarker hasKotlin = new HasKotlinMarker(buildDataManager);
                Set set = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
                Iterable $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ModuleBuildTarget it;
                        ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                        if (!Intrinsics.areEqual((Object)hasKotlin.get(moduleBuildTarget), (Object)true)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            Logger logger = LOG;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, logger);
            if (System.getProperty(SKIP_CACHE_VERSION_CHECK_PROPERTY) == null) {
                BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataPaths, (String)"dataManager.dataPaths");
                CacheVersionProvider cacheVersionsProvider = new CacheVersionProvider(buildDataPaths);
                Set<CacheVersion.Action> actions = this.checkCachesVersions(context, cacheVersionsProvider, chunk);
                this.applyActionsOnCacheVersionChange(actions, cacheVersionsProvider, context, dataManager, targets, fsOperations);
                if (actions.contains((Object)CacheVersion.Action.REBUILD_ALL_KOTLIN)) {
                    return;
                }
            }
            try {
                JpsLookupStorageKt.withLookupStorage(dataManager, chunkBuildStarted.2.INSTANCE);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                this.markAllKotlinForRebuild(context, fsOperations, "Lookup storage is corrupted");
                return;
            }
            this.markAdditionalFilesForInitialRound(chunk, context, fsOperations);
            BuildLogger buildLogger3 = buildLogger;
            if (buildLogger3 == null) break block12;
            buildLogger3.afterBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(ModuleChunk chunk, CompileContext context, FSOperationsHelper fsOperations) {
        DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2 = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk, context){
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;

            public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
            }
            {
                this.$context = $captured_local_variable$0;
                this.$chunk = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        MultiMap<ModuleBuildTarget, File> chunkDirtyFiles = KotlinSourceFileCollector.INSTANCE.getDirtySourceFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)dirtyFilesHolder2));
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Map chunkRemovedFiles2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap(set, (Function1)new Function1<ModuleBuildTarget, List<? extends File>>(dirtyFilesHolder2){
            final /* synthetic */ markAdditionalFilesForInitialRound.dirtyFilesHolder.1 $dirtyFilesHolder;

            @NotNull
            public final List<File> invoke(ModuleBuildTarget it) {
                DirtyFilesHolder dirtyFilesHolder2 = (DirtyFilesHolder)this.$dirtyFilesHolder;
                ModuleBuildTarget moduleBuildTarget = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                return KotlinSourceFileCollector.INSTANCE.getRemovedKotlinFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder2, moduleBuildTarget);
            }
            {
                this.$dirtyFilesHolder = var1_1;
                super(1);
            }
        });
        Map incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        JpsCompilerEnvironment environment = this.createCompileEnvironment(incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, context, chunk, messageCollector);
        if (environment == null) {
            return;
        }
        HashSet<String> removedClasses = new HashSet<String>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            Object v = incrementalCaches.get(target);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            JpsIncrementalJvmCache cache = (JpsIncrementalJvmCache)v;
            Collection dirtyFiles = chunkDirtyFiles.get((Object)target);
            List list = (List)chunkRemovedFiles2.get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List removedFiles = list;
            JpsKotlinCompilerRunner jpsKotlinCompilerRunner = new JpsKotlinCompilerRunner();
            Collection collection = dirtyFiles;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"dirtyFiles");
            Set<String> existingClasses = jpsKotlinCompilerRunner.classesFqNamesByFiles(environment, CollectionsKt.toHashSet((Iterable)collection));
            Iterable<JvmClassName> previousClasses = cache.classesBySources(CollectionsKt.plus((Collection)dirtyFiles, (Iterable)removedFiles));
            for (JvmClassName jvmClassName : previousClasses) {
                String fqName2 = jvmClassName.getFqNameForClassNameWithoutDollars().asString();
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $receiver$iv = removedClasses;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            changesCollector.collectSignature(new FqName(it), true);
        }
        Iterable iterable = incrementalCaches.values();
        BuildDataManager buildDataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"context.projectDescriptor.dataManager");
        Set affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, iterable, buildDataManager);
        fsOperations.markFilesBeforeInitialRound(affectedByRemovedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<CacheVersion.Action> checkCachesVersions(CompileContext context, CacheVersionProvider cacheVersionsProvider, ModuleChunk chunk) {
        void $receiver$iv$iv;
        Iterable<CacheVersion> allVersions;
        Iterable<CacheVersion> $receiver$iv;
        Set targets = chunk.getTargets();
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set set = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
        Iterable<CacheVersion> iterable = $receiver$iv = (allVersions = cacheVersionsProvider.allVersions(set));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CacheVersion cacheVersion = (CacheVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            CacheVersion.Action action = it.checkVersion();
            collection.add(action);
        }
        Set actions = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        KotlinModuleBuilderTarget kotlinModuleBuilderTarget = kotlinBuildTargets.get(moduleBuildTarget);
        if (!(kotlinModuleBuilderTarget instanceof KotlinJsModuleBuildTarget)) {
            CommonCompilerArguments args = this.compilerArgumentsForChunk(chunk);
            JvmBuildMetaInfo currentBuildMetaInfo = JvmBuildMetaInfoKt.JvmBuildMetaInfo(args);
            Iterator iterator2 = chunk.getTargets().iterator();
            while (iterator2.hasNext()) {
                String reasonToRebuild;
                Object currentApiVersion;
                String it;
                Object object;
                Object currentLangVersion;
                String string;
                String it2;
                JvmBuildMetaInfo $i$f$mapTo;
                ModuleBuildTarget target;
                ModuleBuildTarget moduleBuildTarget2 = target = (ModuleBuildTarget)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"target");
                BuildDataManager buildDataManager = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                File file = KotlinBuilderKt.jvmBuildMetaInfoFile(moduleBuildTarget2, buildDataManager);
                if (!file.exists()) continue;
                try {
                    if (JvmBuildMetaInfo.Companion.deserializeFromString(FilesKt.readText$default((File)file, null, (int)1, null)) == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not deserialize jvm build meta info", (Throwable)e);
                    continue;
                }
                JvmBuildMetaInfo lastBuildMetaInfo = $i$f$mapTo;
                LanguageVersion lastBuildLangVersion = LanguageVersion.Companion.fromVersionString(lastBuildMetaInfo.getLanguageVersionString());
                ApiVersion lastBuildApiVersion = ApiVersion.Companion.parse(lastBuildMetaInfo.getApiVersionString());
                Object object2 = args.getLanguageVersion();
                if (object2 == null || (object2 = LanguageVersion.Companion.fromVersionString(it2 = (string = object2))) == null) {
                    object2 = currentLangVersion = LanguageVersion.LATEST_STABLE;
                }
                if ((object = args.getApiVersion()) == null || (object = ApiVersion.Companion.parse(it = (it2 = object))) == null) {
                    object = currentApiVersion = ApiVersion.Companion.createByLanguageVersion((LanguageVersion)currentLangVersion);
                }
                if ((reasonToRebuild = currentLangVersion != lastBuildLangVersion ? "Language version was changed (" + lastBuildLangVersion + " -> " + currentLangVersion + ')' : (Intrinsics.areEqual((Object)currentApiVersion, (Object)lastBuildApiVersion) ^ true ? "Api version was changed (" + lastBuildApiVersion + " -> " + currentApiVersion + ')' : (lastBuildLangVersion != LanguageVersion.KOTLIN_1_0 && lastBuildMetaInfo.isEAP() && !currentBuildMetaInfo.isEAP() ? "Last build was compiled with EAP-plugin" : null))) == null) continue;
                LOG.info(reasonToRebuild + ". Performing non-incremental rebuild (kotlin only)");
                actions.add(CacheVersion.Action.REBUILD_ALL_KOTLIN);
            }
        }
        return actions;
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        if (JpsUtilKt.isDummy(chunk, context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        Logger logger = LOG;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, logger);
        try {
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, context, dirtyFilesHolder2, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && fsOperations.getHasMarkedDirty$jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.info("Caught exception: " + e);
            MessageCollectorUtil.reportException(messageCollector, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block32: {
            block31: {
                v0 = TargetPlatformKt.getKotlinBuildTargets(context);
                v1 = chunk.representativeTarget();
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"chunk.representativeTarget()");
                isJsModule = v0.get(v1) instanceof KotlinJsModuleBuildTarget;
                if (!((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue() && !isJsModule) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                dataManager = projectDescriptor.dataManager;
                targets = chunk.getTargets();
                v2 = dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"dataManager");
                hasKotlin = new HasKotlinMarker(v2);
                rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(dataManager);
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                v3 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"targets");
                $receiver$iv = v3;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Iterable element$iv : $receiver$iv) {
                        v5 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                        if (!Intrinsics.areEqual((Object)rebuildAfterCacheVersionChanged.get(v5), (Object)true)) continue;
                        v4 = true;
                        break block31;
                    }
                    v4 = false;
                }
            }
            if (v4) lbl-1000:
            // 2 sources

            {
                v6 = true;
            } else {
                v6 = isChunkRebuilding = false;
            }
            if (KotlinBuilderKt.access$hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
                if (!isChunkRebuilding && !IncrementalCompilation.isEnabled()) {
                    v7 = targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"targets");
                    $receiver$iv = v7;
                    for (Iterable element$iv : $receiver$iv) {
                        v8 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
                        rebuildAfterCacheVersionChanged.set(v8, true);
                    }
                    return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                }
            } else {
                if (isChunkRebuilding) {
                    v9 = targets;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"targets");
                    $receiver$iv = v9;
                    for (Iterable element$iv : $receiver$iv) {
                        v10 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                        hasKotlin.set(v10, false);
                    }
                }
                v11 = targets;
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"targets");
                $receiver$iv = v11;
                for (Iterable element$iv : $receiver$iv) {
                    v12 = it = (ModuleBuildTarget)element$iv /* !! */ ;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                    rebuildAfterCacheVersionChanged.clean(v12);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v13 = targets;
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"targets");
            element$iv /* !! */  = $receiver$iv = (Iterable)v13;
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                it = (ModuleBuildTarget)element$iv$iv;
                v14 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                if (!(v14.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            $receiver$iv = targetsWithoutOutputDir;
            if ($receiver$iv.isEmpty() == false) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Output directory not specified for " + CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            v15 = projectDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"projectDescriptor");
            v16 = project = v15.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(v16);
            incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
            v17 = this.createCompileEnvironment(incrementalCaches, lookupTracker, context, chunk, messageCollector);
            if (v17 == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            environment = v17;
            $receiver = it = this.compilerArgumentsForChunk(chunk);
            $receiver.setReportOutputFiles(true);
            $receiver.setVersion(true);
            commonArguments = it;
            allCompiledFiles = KotlinBuilderKt.getAllCompiledFilesContainer(context);
            filesToCompile = KotlinSourceFileCollector.INSTANCE.getDirtySourceFiles(dirtyFilesHolder);
            KotlinBuilder.LOG.debug("Compiling files: " + filesToCompile.values());
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, (CommonCompilerArguments)commonArguments, context, dirtyFilesHolder, environment, filesToCompile, incrementalCaches, fsOperations);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v18 = compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"compilationErrors");
            if (v18.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            this.registerOutputItems(outputConsumer, generatedFiles);
            this.saveVersions(context, chunk, (CommonCompilerArguments)commonArguments);
            $receiver$iv = targets;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v19 = false;
            } else {
                var28_27 = $receiver$iv.iterator();
                while (var28_27.hasNext()) {
                    element$iv /* !! */  = var28_27.next();
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    v20 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"it");
                    if (!(hasKotlin.get(v20) == null)) continue;
                    v19 = true;
                    break block32;
                }
                v19 = false;
            }
        }
        if (v19) {
            v21 = filesToCompile.values();
            Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"filesToCompile.values()");
            fsOperations.markChunk(false, true, CollectionsKt.toSet((Iterable)v21));
        }
        var28_27 = targets.iterator();
        while (var28_27.hasNext()) {
            v22 = target = (ModuleBuildTarget)var28_27.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"target");
            hasKotlin.set(v22, true);
            rebuildAfterCacheVersionChanged.clean(target);
        }
        v23 = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"chunk.targets");
        $receiver$iv = v23;
        var28_27 = $receiver$iv.iterator();
        while (var28_27.hasNext()) {
            element$iv /* !! */  = var28_27.next();
            it = (ModuleBuildTarget)element$iv /* !! */ ;
            v24 = TargetPlatformKt.getKotlinBuildTargets(context);
            v25 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"it");
            v26 = v24.get(v25);
            if (v26 == null) continue;
            v26.doAfterBuild();
        }
        this.updateJavaMappings(chunk, context, dirtyFilesHolder, filesToCompile, generatedFiles, incrementalCaches);
        if (!IncrementalCompilation.isEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $receiver$iv = environment;
        try {
            progress = $receiver$iv.getProgressReporter();
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            it = generatedFiles;
            var31_30 = it.entrySet().iterator();
            while (var31_30.hasNext()) {
                var33_32 = var32_31 = var31_30.next();
                target = (ModuleBuildTarget)var33_32.getKey();
                var33_32 = var32_31;
                files = (List)var33_32.getValue();
                v27 = files;
                v28 = incrementalCaches.get(target);
                if (v28 == null) {
                    Intrinsics.throwNpe();
                }
                BuildUtilKt.updateIncrementalCache(v27, (IncrementalJvmCache)v28, changesCollector, null);
            }
            this.updateLookupStorage(chunk, lookupTracker, dataManager, dirtyFilesHolder, filesToCompile);
            if (!isChunkRebuilding) {
                v29 = filesToCompile.values();
                Intrinsics.checkExpressionValueIsNotNull((Object)v29, (String)"filesToCompile.values()");
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, CollectionsKt.toSet((Iterable)v29), dataManager, fsOperations, incrementalCaches.values());
            }
            var36_34 = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    private final void applyActionsOnCacheVersionChange(Set<? extends CacheVersion.Action> actions, CacheVersionProvider cacheVersionsProvider, CompileContext context, BuildDataManager dataManager, Set<ModuleBuildTarget> targets, FSOperationsHelper fsOperations) {
        HasKotlinMarker hasKotlin = new HasKotlinMarker(dataManager);
        List sortedActions = CollectionsKt.sorted((Iterable)actions);
        Object object = TestingContextKt.getTestingContext(context);
        if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
            object.actionsOnCacheVersionChanged(sortedActions);
        }
        block6: for (CacheVersion.Action status : sortedActions) {
            boolean bl;
            switch (KotlinBuilder$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1: {
                    this.markAllKotlinForRebuild(context, fsOperations, "Kotlin global lookup map format changed");
                    return;
                }
                case 2: {
                    LOG.info("Clearing caches for " + CollectionsKt.joinToString$default((Iterable)targets, null, null, null, (int)0, null, (Function1)applyActionsOnCacheVersionChange.1.INSTANCE, (int)31, null));
                    RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(dataManager);
                    for (ModuleBuildTarget target : targets) {
                        JpsIncrementalJvmCacheKt.getKotlinCache(dataManager, target).clean();
                        hasKotlin.clean(target);
                        rebuildAfterCacheVersionChanged.set(target, true);
                    }
                    FSOperationsHelper.markChunk$default(fsOperations, false, true, null, 4, null);
                    return;
                }
                case 3: {
                    ModuleBuildTarget target;
                    LOG.info("Clearing caches for all targets");
                    target = this.allTargets(context).iterator();
                    while (target.hasNext()) {
                        ModuleBuildTarget target2 = target.next();
                        JpsIncrementalJvmCacheKt.getKotlinCache(dataManager, target2).clean();
                    }
                    continue block6;
                }
                case 4: {
                    LOG.info("Clearing lookup cache");
                    Logger logger = LOG;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                    JpsLookupStorageKt.cleanLookupStorage(dataManager, logger);
                    cacheVersionsProvider.dataContainerVersion().clean();
                    continue block6;
                }
            }
            boolean bl2 = bl = status == CacheVersion.Action.DO_NOTHING;
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Unknown version status " + (Object)((Object)status);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ModuleBuildTarget> allTargets(@NotNull CompileContext $receiver) {
        void var3_3;
        void $receiver$iv;
        ProjectDescriptor projectDescriptor = $receiver.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"projectDescriptor");
        BuildTargetIndex buildTargetIndex = projectDescriptor.getBuildTargetIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildTargetIndex, (String)"projectDescriptor.buildTargetIndex");
        List list = buildTargetIndex.getAllTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"projectDescriptor.buildTargetIndex.allTargets");
        Iterable iterable = list;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv) {
            if (!(element$iv instanceof ModuleBuildTarget)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void markAllKotlinForRebuild(CompileContext context, FSOperationsHelper fsOperations, String reason) {
        BuildDataManager dataManager;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        JpsProject project;
        LOG.info("Rebuilding all Kotlin: " + reason);
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
        JpsProject jpsProject = project = projectDescriptor.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        List list = jpsProject.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.modules");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JpsModule it;
            JpsModule jpsModule = it = (JpsModule)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"it");
            Iterable list$iv$iv = jpsModule.getSourceRoots();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List sourceRoots = (List)destination$iv$iv;
        BuildDataManager buildDataManager = dataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager);
        Iterator<Object> iterator2 = sourceRoots.iterator();
        while (iterator2.hasNext()) {
            JpsModuleSourceRoot sourceRoot;
            JpsModuleSourceRoot jpsModuleSourceRoot = sourceRoot = (JpsModuleSourceRoot)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"sourceRoot");
            File file = jpsModuleSourceRoot.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceRoot.file");
            Sequence ktFiles2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)markAllKotlinForRebuild.ktFiles.1.INSTANCE);
            fsOperations.markFiles(SequencesKt.toList((Sequence)ktFiles2));
        }
        for (ModuleBuildTarget target : this.allTargets(context)) {
            JpsIncrementalJvmCacheKt.getKotlinCache(dataManager, target).clean();
            rebuildAfterCacheVersionChanged.set(target, true);
        }
        Logger logger = LOG;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        JpsLookupStorageKt.cleanLookupStorage(dataManager, logger);
    }

    private final void saveVersions(CompileContext context, ModuleChunk chunk, CommonCompilerArguments commonArguments) {
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Set targets = chunk.getTargets();
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        BuildDataPaths buildDataPaths = buildDataManager.getDataPaths();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataPaths, (String)"dataManager.dataPaths");
        CacheVersionProvider cacheVersionsProvider = new CacheVersionProvider(buildDataPaths);
        Set set = targets;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"targets");
        Iterable<CacheVersion> $receiver$iv = cacheVersionsProvider.allVersions(set);
        Iterator<CacheVersion> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            CacheVersion element$iv;
            CacheVersion it = element$iv = iterator2.next();
            it.saveIfNeeded();
        }
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        boolean isJsModule = kotlinBuildTargets.get(moduleBuildTarget) instanceof KotlinJsModuleBuildTarget;
        if (!isJsModule) {
            JvmBuildMetaInfo jvmBuildMetaInfo = JvmBuildMetaInfoKt.JvmBuildMetaInfo(commonArguments);
            String serializedMetaInfo = JvmBuildMetaInfo.Companion.serializeToString(jvmBuildMetaInfo);
            Iterator iterator3 = chunk.getTargets().iterator();
            while (iterator3.hasNext()) {
                ModuleBuildTarget target;
                ModuleBuildTarget moduleBuildTarget2 = target = (ModuleBuildTarget)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"target");
                FilesKt.writeText$default((File)KotlinBuilderKt.jvmBuildMetaInfoFile(moduleBuildTarget2, dataManager), (String)serializedMetaInfo, null, (int)2, null);
            }
        }
    }

    private final CommonCompilerArguments compilerArgumentsForChunk(ModuleChunk chunk) {
        ModuleBuildTarget moduleBuildTarget = chunk.representativeTarget();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"chunk.representativeTarget()");
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"chunk.representativeTarget().module");
        return ModuleSettingsKt.getKotlinCompilerArguments(jpsModule);
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector doCompileModuleChunk(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, JpsCompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends IncrementalJvmCache> incrementalCaches, FSOperationsHelper fsOperations) {
        KotlinModuleBuilderTarget kotlinModuleBuilderTarget;
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.1 concatenate$ = doCompileModuleChunk.1.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.getPluginOptions();
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.setPluginOptions(concatenate$.invoke(stringArray, argumentProvider.getExtraArguments(moduleBuildTarget, context)));
            commonArguments.setPluginClasspaths(concatenate$.invoke(commonArguments.getPluginClasspaths(), argumentProvider.getClasspath(representativeTarget, context)));
            LOG.debug("Plugin loaded: " + argumentProvider.getClass().getSimpleName());
        }
        if (IncrementalCompilation.isEnabled()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalJvmCache cache;
                Collection collection;
                Collection<File> collection2;
                void $receiver$iv$iv;
                void $receiver$iv;
                if (incrementalCaches.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)filesToCompile.get((Object)target), (String)"filesToCompile[target]");
                Collection collection3 = dirtyFilesHolder2.getRemovedFiles((BuildTarget)target);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"dirtyFilesHolder.getRemovedFiles(target)");
                Iterable iterable = collection3;
                void var17_18 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    String string = (String)item$iv$iv;
                    collection2 = destination$iv$iv;
                    File file = new File((String)p1);
                    collection2.add(file);
                }
                collection2 = (List)destination$iv$iv;
                List removedAndDirtyFiles = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
                cache.markDirty(removedAndDirtyFiles);
            }
        }
        KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        KotlinModuleBuilderTarget kotlinModuleBuilderTarget2 = kotlinModuleBuilderTarget = kotlinBuildTargets.get(moduleBuildTarget);
        boolean isDoneSomething = kotlinModuleBuilderTarget2 != null ? kotlinModuleBuilderTarget2.compileModuleChunk(allCompiledFiles, chunk, commonArguments, dirtyFilesHolder2, environment, filesToCompile, fsOperations) : false;
        return isDoneSomething ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final JpsCompilerEnvironment createCompileEnvironment(Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches, LookupTracker lookupTracker, CompileContext context, ModuleChunk chunk, MessageCollectorAdapter messageCollector) {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Services.Builder builder;
        Services.Builder $receiver = builder = new Services.Builder();
        $receiver.register(LookupTracker.class, lookupTracker);
        Map<ModuleBuildTarget, ? extends IncrementalCache> map3 = incrementalCaches;
        Class<IncrementalCompilationComponents> clazz = IncrementalCompilationComponents.class;
        Services.Builder builder2 = $receiver;
        void var14_11 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            KotlinModuleBuilderTarget kotlinModuleBuilderTarget = TargetPlatformKt.getKotlinBuildTargets(context).get((ModuleBuildTarget)it.getKey());
            if (kotlinModuleBuilderTarget == null) {
                Intrinsics.throwNpe();
            }
            TargetId targetId = kotlinModuleBuilderTarget.getTargetId();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TargetId targetId2 = targetId;
            Map map4 = map2;
            Object v = it$iv$iv.getValue();
            map4.put(targetId2, v);
        }
        Map map5 = map2 = destination$iv$iv;
        builder2.register(clazz, new IncrementalCompilationComponentsImpl(map5));
        $receiver.register(CompilationCanceledStatus.class, new CompilationCanceledStatus(lookupTracker, incrementalCaches, context){
            final /* synthetic */ LookupTracker $lookupTracker$inlined;
            final /* synthetic */ Map $incrementalCaches$inlined;
            final /* synthetic */ CompileContext $context$inlined;
            {
                this.$lookupTracker$inlined = lookupTracker;
                this.$incrementalCaches$inlined = map2;
                this.$context$inlined = compileContext;
            }

            public void checkCanceled() {
                CanceledStatus canceledStatus = this.$context$inlined.getCancelStatus();
                Intrinsics.checkExpressionValueIsNotNull((Object)canceledStatus, (String)"context.cancelStatus");
                if (canceledStatus.isCanceled()) {
                    throw (Throwable)((Object)new CompilationCanceledException());
                }
            }
        });
        Services compilerServices = $receiver.build();
        KotlinPaths paths = this.computeKotlinPathsForJpsPlugin();
        if (paths == null || !paths.getHomePath().exists()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cannot find kotlinc home. Make sure the plugin is properly installed, or specify jps.kotlin.home system property", null, 4, null);
            return null;
        }
        return new JpsCompilerEnvironment(paths, compilerServices, Companion.getClassesToLoadByParent(), messageCollector, new OutputItemsCollectorImpl(), new ProgressReporterImpl(context, chunk));
    }

    private final KotlinPaths computeKotlinPathsForJpsPlugin() {
        File jar;
        if (StringsKt.equals((String)System.getProperty("kotlin.jps.tests"), (String)"true", (boolean)true)) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            return new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
        }
        File file = PathUtil.INSTANCE.getPathUtilJar();
        File p1 = file;
        File file2 = jar = p1.exists() ? file : null;
        if (Intrinsics.areEqual((Object)(file2 != null ? file2.getName() : null), (Object)"kotlin-jps-plugin.jar")) {
            File file3 = jar.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"jar.parentFile");
            File file4 = file3.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"jar.parentFile.parentFile");
            File pluginHome = file4.getParentFile();
            return new KotlinPathsFromHomeDir(new File(pluginHome, "kotlinc"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        HashMap sourceToTarget = new HashMap();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                KotlinBuildTargets kotlinBuildTargets = TargetPlatformKt.getKotlinBuildTargets(context);
                ModuleBuildTarget moduleBuildTarget = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
                Object object = kotlinBuildTargets.get(moduleBuildTarget);
                if (object != null && (object = ((KotlinModuleBuilderTarget)object).getSources()) != null) {
                    $receiver$iv = (Iterable)object;
                    for (Object element$iv : $receiver$iv) {
                        File it = (File)element$iv;
                        Map map2 = sourceToTarget;
                        ModuleBuildTarget moduleBuildTarget2 = target;
                        map2.put(it, moduleBuildTarget2);
                    }
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Function1<SimpleOutputItem, ModuleBuildTarget> target$ = new Function1<SimpleOutputItem, ModuleBuildTarget>(sourceToTarget, chunk, representativeTarget){
            final /* synthetic */ HashMap $sourceToTarget;
            final /* synthetic */ ModuleChunk $chunk;
            final /* synthetic */ ModuleBuildTarget $representativeTarget;

            /*
             * WARNING - void declaration
             */
            public final ModuleBuildTarget invoke(@NotNull SimpleOutputItem $receiver) {
                File file;
                File file2;
                File it;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                File file3 = (File)CollectionsKt.firstOrNull((Iterable)$receiver.getSourceFiles());
                if (file3 == null || (file3 = (ModuleBuildTarget)this.$sourceToTarget.get(it = (file2 = file3))) == null) {
                    Object object;
                    block6: {
                        void var3_3;
                        Set set = this.$chunk.getTargets();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
                        Iterable $receiver$iv = set;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $receiver$iv) {
                            boolean bl;
                            ModuleBuildTarget it2;
                            ModuleBuildTarget moduleBuildTarget = it2 = (ModuleBuildTarget)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                            if (moduleBuildTarget.getOutputDir() != null) {
                                File file4;
                                File it3 = file4;
                                File file5 = $receiver.getOutputFile();
                                File file6 = it3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it");
                                bl = FilesKt.startsWith((File)file5, (File)file6);
                            } else {
                                bl = false;
                            }
                            if (!bl) continue;
                            if (found$iv) {
                                object = null;
                                break block6;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        object = !found$iv ? null : var3_3;
                    }
                    file3 = file = (ModuleBuildTarget)object;
                }
                if (file3 == null) {
                    file = this.$representativeTarget;
                }
                return file;
            }
            {
                this.$sourceToTarget = hashMap;
                this.$chunk = moduleChunk;
                this.$representativeTarget = moduleBuildTarget;
                super(1);
            }
        };
        List<SimpleOutputItem> list = outputItemCollector.getOutputs();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"outputItemCollector.outputs");
        $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            SimpleOutputItem p1 = (SimpleOutputItem)element$iv$iv;
            ModuleBuildTarget key$iv$iv = target$.invoke(p1);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p1 = (SimpleOutputItem)element$iv$iv;
            List list2 = list$iv$iv;
            GeneratedFile generatedFile = SimpleOutputItemKt.toGeneratedFile(p1);
            list2.add(generatedFile);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> outputItems, Map<ModuleBuildTarget, JpsIncrementalJvmCache> incrementalCaches) {
        BuildDataManager buildDataManager = context.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"context.projectDescriptor.dataManager");
        Mappings previousMappings = buildDataManager.getMappings();
        Callbacks.Backend callback = JavaBuilderUtil.getDependenciesRegistrar((CompileContext)context);
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Map targetDirtyFiles2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap(set, (Function1)new Function1<ModuleBuildTarget, HashSet<File>>(dirtyFilesHolder2, filesToCompile){
            final /* synthetic */ DirtyFilesHolder $dirtyFilesHolder;
            final /* synthetic */ MultiMap $filesToCompile;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<File> invoke(ModuleBuildTarget it) {
                void var2_2;
                HashSet<E> files = new HashSet<E>();
                Collection collection = this.$dirtyFilesHolder.getRemovedFiles((BuildTarget)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"dirtyFilesHolder.getRemovedFiles(it)");
                Iterable $receiver$iv = collection;
                for (T item$iv : $receiver$iv) {
                    void p1;
                    String string = (String)item$iv;
                    Collection collection2 = files;
                    File file = new File((String)p1);
                    collection2.add(file);
                }
                Collection cfr_ignored_0 = (Collection)files;
                files.addAll(this.$filesToCompile.get((Object)it));
                return var2_2;
            }
            {
                this.$dirtyFilesHolder = dirtyFilesHolder2;
                this.$filesToCompile = multiMap;
                super(1);
            }
        });
        Function2<ModuleBuildTarget, GeneratedJvmClass, Set<? extends File>> getOldSourceFiles$ = new Function2<ModuleBuildTarget, GeneratedJvmClass, Set<? extends File>>(incrementalCaches, previousMappings){
            final /* synthetic */ Map $incrementalCaches;
            final /* synthetic */ Mappings $previousMappings;

            @NotNull
            public final Set<File> invoke(@NotNull ModuleBuildTarget target, @NotNull GeneratedJvmClass generatedClass) {
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
                JpsIncrementalJvmCache jpsIncrementalJvmCache = (JpsIncrementalJvmCache)this.$incrementalCaches.get(target);
                if (jpsIncrementalJvmCache == null) {
                    return SetsKt.emptySet();
                }
                JpsIncrementalJvmCache cache = jpsIncrementalJvmCache;
                JvmClassName className2 = generatedClass.getOutputClass().getClassName();
                if (!cache.isMultifileFacade(className2)) {
                    return SetsKt.emptySet();
                }
                int name = this.$previousMappings.getName(className2.getInternalName());
                Collection collection = this.$previousMappings.getClassSources(name);
                if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
                    collection = SetsKt.emptySet();
                }
                return collection;
            }
            {
                this.$incrementalCaches = map2;
                this.$previousMappings = mappings;
                super(2);
            }
        };
        Map<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> map2 = outputItems;
        Iterator<Map.Entry<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> entry;
            Map.Entry<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> entry2 = entry = iterator2.next();
            ModuleBuildTarget target = entry2.getKey();
            Map.Entry<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> entry3 = entry;
            Iterable<? extends GeneratedFile> outputs = entry3.getValue();
            for (GeneratedFile generatedFile : outputs) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                if (!(generatedFile instanceof GeneratedJvmClass)) continue;
                THashSet sourceFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                sourceFiles.addAll((Collection)getOldSourceFiles$.invoke(target, (GeneratedJvmClass)generatedFile));
                Set set2 = (Set)targetDirtyFiles2.get(target);
                sourceFiles.removeAll(set2 != null ? (Collection)set2 : (Collection)SetsKt.emptySet());
                sourceFiles.addAll(generatedFile.getSourceFiles());
                Iterable iterable = (Iterable)sourceFiles;
                String string = FileUtil.toSystemIndependentName((String)generatedFile.getOutputFile().getCanonicalPath());
                Callbacks.Backend backend = callback;
                void var19_22 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    String string2 = FileUtil.toSystemIndependentName((String)v3.getCanonicalPath());
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                backend.associate(string, (Collection)collection, new ClassReader(((GeneratedJvmClass)generatedFile).getOutputClass().getFileContents()));
            }
        }
        Collection allCompiled = filesToCompile.values();
        JavaBuilderUtil.registerFilesToCompile((CompileContext)context, (Collection)allCompiled);
        JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)context, (Collection)allCompiled);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> outputItems) {
        Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> map2 = outputItems;
        Iterator<Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry;
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry2 = entry = iterator2.next();
            ModuleBuildTarget target = entry2.getKey();
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry3 = entry;
            List<? extends GeneratedFile> outputs = entry3.getValue();
            for (GeneratedFile generatedFile : outputs) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = generatedFile.getSourceFiles();
                File file = generatedFile.getOutputFile();
                BuildTarget buildTarget = (BuildTarget)target;
                ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
                void var10_13 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getPath();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLookupStorage(ModuleChunk chunk, LookupTracker lookupTracker, BuildDataManager dataManager, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, MultiMap<ModuleBuildTarget, File> filesToCompile) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        Set set = chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ModuleBuildTarget it;
            ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
            Iterable list$iv$iv = KotlinSourceFileCollector.INSTANCE.getRemovedKotlinFiles(dirtyFilesHolder2, moduleBuildTarget);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List removedFiles = (List)destination$iv$iv;
        JpsLookupStorageKt.withLookupStorage(dataManager, (Function1)new Function1<LookupStorage, Unit>(filesToCompile, removedFiles, lookupTracker){
            final /* synthetic */ MultiMap $filesToCompile;
            final /* synthetic */ List $removedFiles;
            final /* synthetic */ LookupTracker $lookupTracker;

            public final void invoke(@NotNull LookupStorage lookupStorage) {
                Intrinsics.checkParameterIsNotNull((Object)lookupStorage, (String)"lookupStorage");
                Collection collection = this.$filesToCompile.values();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile.values()");
                lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)collection), (Sequence)CollectionsKt.asSequence((Iterable)this.$removedFiles)));
                Set set = ((LookupTrackerImpl)this.$lookupTracker).getLookups().entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"lookupTracker.lookups.entrySet()");
                Set set2 = ((LookupTrackerImpl)this.$lookupTracker).getPathInterner().getValues();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"lookupTracker.pathInterner.values");
                lookupStorage.addAll(set, set2);
            }
            {
                this.$filesToCompile = multiMap;
                this.$removedFiles = list;
                this.$lookupTracker = lookupTracker;
                super(1);
            }
        });
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "hasErrors", "", "clear", "", "kind", "Lorg/jetbrains/jps/incremental/messages/BuildMessage$Kind;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "report", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "jps-plugin"})
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        private boolean hasErrors;
        private final CompileContext context;

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
            BuildMessage.Kind kind;
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.hasErrors |= severity.isError();
            String prefix = "";
            if (severity == CompilerMessageSeverity.EXCEPTION) {
                prefix = "[Internal Error] ";
            }
            if ((kind = this.kind(severity)) != null) {
                CompilerMessageLocation compilerMessageLocation = location;
                CompilerMessageLocation compilerMessageLocation2 = location;
                CompilerMessageLocation compilerMessageLocation3 = location;
                this.context.processMessage((BuildMessage)new CompilerMessage("Kotlin", kind, prefix + message, compilerMessageLocation != null ? compilerMessageLocation.getPath() : null, -1L, -1L, -1L, compilerMessageLocation2 != null ? (long)compilerMessageLocation2.getLine() : -1L, compilerMessageLocation3 != null ? (long)compilerMessageLocation3.getColumn() : -1L));
            } else {
                String path = location != null ? location.getPath() + ':' + location.getLine() + ':' + location.getColumn() + ": " : "";
                Companion.getLOG().debug(path + message);
            }
        }

        @Override
        public void clear() {
            this.hasErrors = false;
        }

        @Override
        public boolean hasErrors() {
            return this.hasErrors;
        }

        private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            switch (KotlinBuilder$MessageCollectorAdapter$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    kind = BuildMessage.Kind.INFO;
                    break;
                }
                case 2: 
                case 3: {
                    kind = BuildMessage.Kind.ERROR;
                    break;
                }
                case 4: 
                case 5: {
                    kind = BuildMessage.Kind.WARNING;
                    break;
                }
                case 6: {
                    kind = null;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
                }
            }
            return kind;
        }

        public MessageCollectorAdapter(@NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JPS_KOTLIN_HOME_PROPERTY", "", "JVM_BUILD_META_INFO_FILE_NAME", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "jps-plugin"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return classesToLoadByParent.1.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

