/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.kotlin.jps.build.BuildLogger;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper$sam$java_io_FileFilter$0;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0014\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dJ\u0014\u0010\u001e\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dJ3\u0010\u001f\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010 \u001a\u00020\f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f0\"H\u0082\bJ\"\u0010#\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "", "compileContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;Lcom/intellij/openapi/diagnostic/Logger;)V", "buildLogger", "Lorg/jetbrains/kotlin/jps/build/BuildLogger;", "<set-?>", "", "hasMarkedDirty", "getHasMarkedDirty$jps_plugin", "()Z", "setHasMarkedDirty", "(Z)V", "moduleBasedFilter", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper$ModulesBasedFileFilter;", "markChunk", "", "recursively", "kotlinOnly", "excludeFiles", "", "Ljava/io/File;", "markFiles", "files", "", "markFilesBeforeInitialRound", "markFilesImpl", "beforeRound", "shouldMark", "Lkotlin/Function1;", "markInChunkOrDependents", "ModulesBasedFileFilter", "jps-plugin"})
public final class FSOperationsHelper {
    private final ModulesBasedFileFilter moduleBasedFilter;
    private boolean hasMarkedDirty;
    private final BuildLogger buildLogger;
    private final CompileContext compileContext;
    private final ModuleChunk chunk;
    private final Logger log;

    public final boolean getHasMarkedDirty$jps_plugin() {
        return this.hasMarkedDirty;
    }

    private final void setHasMarkedDirty(boolean bl) {
        this.hasMarkedDirty = bl;
    }

    public final void markChunk(boolean recursively, boolean kotlinOnly, @NotNull Set<? extends File> excludeFiles) {
        Intrinsics.checkParameterIsNotNull(excludeFiles, (String)"excludeFiles");
        Function1<File, Boolean> shouldMark$ = new Function1<File, Boolean>(this, kotlinOnly, excludeFiles){
            final /* synthetic */ FSOperationsHelper this$0;
            final /* synthetic */ boolean $kotlinOnly;
            final /* synthetic */ Set $excludeFiles;

            public final boolean invoke(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (this.$kotlinOnly && !KotlinSourceFileCollector.INSTANCE.isKotlinSourceFile$jps_plugin(file)) {
                    return false;
                }
                if (this.$excludeFiles.contains(file)) {
                    return false;
                }
                FSOperationsHelper.access$setHasMarkedDirty$p(this.this$0, true);
                return true;
            }
            {
                this.this$0 = fSOperationsHelper;
                this.$kotlinOnly = bl;
                this.$excludeFiles = set;
                super(1);
            }
        };
        if (recursively) {
            Function1 function1 = (Function1)new Function1<File, Boolean>(shouldMark$){
                final /* synthetic */ markChunk.1 $shouldMark$1;

                public final boolean invoke(@NotNull File p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$shouldMark$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "shouldMark";
                }

                public final String getSignature() {
                    return "invoke(Ljava/io/File;)Z";
                }
                {
                    this.$shouldMark$1 = var1_1;
                    super(1);
                }
            };
            FSOperations.markDirtyRecursively((CompileContext)this.compileContext, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)new FSOperationsHelper$sam$java_io_FileFilter$0(function1));
        } else {
            Function1 function1 = (Function1)new Function1<File, Boolean>(shouldMark$){
                final /* synthetic */ markChunk.1 $shouldMark$1;

                public final boolean invoke(@NotNull File p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$shouldMark$1.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "shouldMark";
                }

                public final String getSignature() {
                    return "invoke(Ljava/io/File;)Z";
                }
                {
                    this.$shouldMark$1 = var1_1;
                    super(1);
                }
            };
            FSOperations.markDirty((CompileContext)this.compileContext, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)new FSOperationsHelper$sam$java_io_FileFilter$0(function1));
        }
    }

    public static /* bridge */ /* synthetic */ void markChunk$default(FSOperationsHelper fSOperationsHelper, boolean bl, boolean bl2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        fSOperationsHelper.markChunk(bl, bl2, set);
    }

    /*
     * WARNING - void declaration
     */
    public final void markFilesBeforeInitialRound(@NotNull Iterable<? extends File> files) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        FSOperationsHelper fSOperationsHelper = this;
        boolean beforeRound$iv = true;
        Iterable<? extends File> iterable = files;
        Collection destination$iv$iv = new HashSet();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            if (!(it.exists() && this.moduleBasedFilter.accept(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            BuildLogger buildLogger = ((FSOperationsHelper)this_$iv).buildLogger;
            if (buildLogger != null) {
                buildLogger.markedAsDirtyBeforeRound(filesToMark$iv);
            }
            CompilationRound compilationRound$iv = CompilationRound.CURRENT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)((FSOperationsHelper)this_$iv).compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            ((FSOperationsHelper)this_$iv).log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void markFiles(@NotNull Iterable<? extends File> files) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        FSOperationsHelper fSOperationsHelper = this;
        boolean beforeRound$iv = false;
        Iterable<? extends File> iterable = files;
        Collection destination$iv$iv = new HashSet();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            BuildLogger buildLogger = ((FSOperationsHelper)this_$iv).buildLogger;
            if (buildLogger != null) {
                buildLogger.markedAsDirtyAfterRound(filesToMark$iv);
            }
            ((FSOperationsHelper)this_$iv).hasMarkedDirty = true;
            CompilationRound compilationRound$iv = CompilationRound.NEXT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)((FSOperationsHelper)this_$iv).compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            ((FSOperationsHelper)this_$iv).log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void markInChunkOrDependents(@NotNull Iterable<? extends File> files, @NotNull Set<? extends File> excludeFiles) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull(excludeFiles, (String)"excludeFiles");
        FSOperationsHelper fSOperationsHelper = this;
        boolean beforeRound$iv = false;
        Iterable<? extends File> iterable = files;
        Collection destination$iv$iv = new HashSet();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            if (!(!excludeFiles.contains(it) && it.exists() && this.moduleBasedFilter.accept(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            BuildLogger buildLogger = ((FSOperationsHelper)this_$iv).buildLogger;
            if (buildLogger != null) {
                buildLogger.markedAsDirtyAfterRound(filesToMark$iv);
            }
            ((FSOperationsHelper)this_$iv).hasMarkedDirty = true;
            CompilationRound compilationRound$iv = CompilationRound.NEXT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)((FSOperationsHelper)this_$iv).compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            ((FSOperationsHelper)this_$iv).log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markFilesImpl(Iterable<? extends File> files, boolean beforeRound, Function1<? super File, Boolean> shouldMark) {
        CompilationRound compilationRound;
        void $receiver$iv;
        Iterable<? extends File> iterable = files;
        Collection destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv) {
            if (!((Boolean)shouldMark.invoke(element$iv)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        HashSet filesToMark = (HashSet)destination$iv;
        if (filesToMark.isEmpty()) {
            return;
        }
        if (beforeRound) {
            BuildLogger buildLogger = this.buildLogger;
            if (buildLogger != null) {
                buildLogger.markedAsDirtyBeforeRound(filesToMark);
            }
            compilationRound = CompilationRound.CURRENT;
        } else {
            BuildLogger buildLogger = this.buildLogger;
            if (buildLogger != null) {
                buildLogger.markedAsDirtyAfterRound(filesToMark);
            }
            this.hasMarkedDirty = true;
            compilationRound = CompilationRound.NEXT;
        }
        CompilationRound compilationRound2 = compilationRound;
        for (File fileToMark : filesToMark) {
            FSOperations.markDirty((CompileContext)this.compileContext, (CompilationRound)compilationRound2, (File)fileToMark);
        }
        this.log.debug("Mark dirty: " + filesToMark + " (" + compilationRound2 + ')');
    }

    public FSOperationsHelper(@NotNull CompileContext compileContext, @NotNull ModuleChunk chunk, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)compileContext, (String)"compileContext");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.compileContext = compileContext;
        this.chunk = chunk;
        this.log = log;
        this.moduleBasedFilter = new ModulesBasedFileFilter(this.compileContext, this.chunk);
        TestingContext testingContext = TestingContextKt.getTestingContext(this.compileContext);
        this.buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
    }

    public static final /* synthetic */ boolean access$getHasMarkedDirty$p(FSOperationsHelper $this) {
        return $this.hasMarkedDirty;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00120\u0012 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper$ModulesBasedFileFilter;", "Lorg/jetbrains/jps/builders/java/dependencyView/Mappings$DependentFilesFilter;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;)V", "buildRootIndex", "Lorg/jetbrains/jps/builders/BuildRootIndex;", "kotlin.jvm.PlatformType", "buildTargetIndex", "Lorg/jetbrains/jps/builders/BuildTargetIndex;", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/jps/builders/BuildTarget;", "", "chunkTargets", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "accept", "", "file", "Ljava/io/File;", "belongsToCurrentTargetChunk", "jps-plugin"})
    private static final class ModulesBasedFileFilter
    implements Mappings.DependentFilesFilter {
        private final Set<ModuleBuildTarget> chunkTargets;
        private final BuildRootIndex buildRootIndex;
        private final BuildTargetIndex buildTargetIndex;
        private final HashMap<BuildTarget<?>, Set<BuildTarget<?>>> cache;
        private final CompileContext context;

        /*
         * WARNING - void declaration
         */
        public boolean accept(@NotNull File file) {
            Object object;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            JavaSourceRootDescriptor javaSourceRootDescriptor = this.buildRootIndex.findJavaRootDescriptor(this.context, file);
            if (javaSourceRootDescriptor == null) {
                return true;
            }
            JavaSourceRootDescriptor rd = javaSourceRootDescriptor;
            ModuleBuildTarget target = rd.target;
            if (this.chunkTargets.contains(target)) {
                return true;
            }
            Map map2 = this.cache;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            ModuleBuildTarget key$iv = moduleBuildTarget;
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Set set = this.buildTargetIndex.getDependenciesRecursively((BuildTarget)target, this.context);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"buildTargetIndex.getDepe\u2026ursively(target, context)");
                Set answer$iv = set;
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set targetOfFileWithDependencies = (Set)object;
            return ContainerUtil.intersects((Collection)targetOfFileWithDependencies, (Collection)this.chunkTargets);
        }

        public boolean belongsToCurrentTargetChunk(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            JavaSourceRootDescriptor rd = this.buildRootIndex.findJavaRootDescriptor(this.context, file);
            return rd != null && this.chunkTargets.contains(rd.target);
        }

        public ModulesBasedFileFilter(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            this.context = context;
            this.chunkTargets = chunk.getTargets();
            ProjectDescriptor projectDescriptor = this.context.getProjectDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"context.projectDescriptor");
            this.buildRootIndex = projectDescriptor.getBuildRootIndex();
            ProjectDescriptor projectDescriptor2 = this.context.getProjectDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor2, (String)"context.projectDescriptor");
            this.buildTargetIndex = projectDescriptor2.getBuildTargetIndex();
            this.cache = new HashMap();
        }
    }
}

