/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J3\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u001f0!H\u0002\u00a2\u0006\u0002\u0010\"R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil;", "", "()V", "jdkToolsJar", "Ljava/io/File;", "getJdkToolsJar$jps_plugin", "()Ljava/io/File;", "ourClassLoaderRef", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "getLibPath", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getOrCreateClassLoader", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "", "invokeClassesFqNames", "", "", "files", "invokeExecMethod", "compilerClassName", "arguments", "", "out", "Ljava/io/PrintStream;", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Ljava/io/PrintStream;)Ljava/lang/Object;", "withCompilerClassloader", "T", "fn", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jps-plugin"})
public final class CompilerRunnerUtil {
    private static SoftReference<ClassLoader> ourClassLoaderRef;
    public static final CompilerRunnerUtil INSTANCE;

    @Nullable
    public final File getJdkToolsJar$jps_plugin() {
        CharSequence charSequence;
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || (charSequence = (CharSequence)javaHomePath).length() == 0) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile();
        }
        if (Intrinsics.areEqual((Object)javaHome.getName(), (Object)"jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile();
        }
        return null;
    }

    private final synchronized ClassLoader getOrCreateClassLoader(JpsCompilerEnvironment environment, List<? extends File> paths) {
        ClassLoader classLoader = ourClassLoaderRef.get();
        if (classLoader == null) {
            classLoader = ClassPreloadingUtils.preloadClasses((Collection<File>)paths, 4096, CompilerRunnerUtil.class.getClassLoader(), environment.getClassesToLoadByParent());
            ourClassLoaderRef = new SoftReference<ClassLoader>(classLoader);
        }
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            Intrinsics.throwNpe();
        }
        return classLoader2;
    }

    @Nullable
    public final File getLibPath(@NotNull KotlinPaths paths, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        File libs = paths.getLibPath();
        if (libs.exists()) {
            File file = libs;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"libs");
            if (!file.isFile()) {
                return libs;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Broken compiler at '");
        File file = libs;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"libs");
        messageCollector.report(CompilerMessageSeverity.ERROR, stringBuilder.append(file.getAbsolutePath()).append("'. Make sure plugin is properly installed").toString(), null);
        return null;
    }

    @Nullable
    public final Object invokeExecMethod(@NotNull String compilerClassName, @NotNull String[] arguments, @NotNull JpsCompilerEnvironment environment, @NotNull PrintStream out) {
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        return this.withCompilerClassloader(environment, (Function1)new Function1<ClassLoader, Object>(compilerClassName, out, environment, arguments){
            final /* synthetic */ String $compilerClassName;
            final /* synthetic */ PrintStream $out;
            final /* synthetic */ JpsCompilerEnvironment $environment;
            final /* synthetic */ String[] $arguments;

            public final Object invoke(@NotNull ClassLoader classLoader) {
                Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
                Class<?> kompiler = Class.forName(this.$compilerClassName, true, classLoader);
                Method exec = kompiler.getMethod("execAndOutputXml", PrintStream.class, Class.forName("org.jetbrains.kotlin.config.Services", true, classLoader), String[].class);
                return exec.invoke(kompiler.newInstance(), this.$out, this.$environment.getServices(), this.$arguments);
            }
            {
                this.$compilerClassName = string;
                this.$out = printStream;
                this.$environment = jpsCompilerEnvironment;
                this.$arguments = stringArray;
                super(1);
            }
        });
    }

    @NotNull
    public final Set<String> invokeClassesFqNames(@NotNull JpsCompilerEnvironment environment, @NotNull Set<? extends File> files) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Set set = (Set)this.withCompilerClassloader(environment, (Function1)new Function1<ClassLoader, Set<? extends String>>(files){
            final /* synthetic */ Set $files;

            @Nullable
            public final Set<String> invoke(@NotNull ClassLoader classLoader) {
                Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
                Class<?> klass = Class.forName("org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt", true, classLoader);
                Method method = klass.getMethod("classesFqNames", Set.class);
                Object object = method.invoke(klass, this.$files);
                if (!(object instanceof Set)) {
                    object = null;
                }
                return (Set)object;
            }
            {
                this.$files = set;
                super(1);
            }
        });
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final <T> T withCompilerClassloader(JpsCompilerEnvironment environment, Function1<? super ClassLoader, ? extends T> fn) {
        SmartList<File> paths = new SmartList<File>();
        File file = this.getLibPath(environment.getKotlinPaths(), environment.getMessageCollector());
        if (file == null) {
            return null;
        }
        File libPath = file;
        paths.add(new File(libPath, "kotlin-compiler.jar"));
        File file2 = this.getJdkToolsJar$jps_plugin();
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            paths.add(it);
        }
        ClassLoader classLoader = this.getOrCreateClassLoader(environment, (List<? extends File>)paths);
        return (T)fn.invoke((Object)classLoader);
    }

    private CompilerRunnerUtil() {
    }

    static {
        CompilerRunnerUtil compilerRunnerUtil;
        INSTANCE = compilerRunnerUtil = new CompilerRunnerUtil();
        ourClassLoaderRef = new SoftReference<Object>(null);
    }
}

