/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.components.JBList;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PsiUtil {
    private static final Key<Boolean> IDEA_PROJECT = Key.create((String)"idea.internal.inspections.enabled");
    private static final String IDE_PROJECT_MARKER_CLASS = JBList.class.getName();
    private static final String[] IDEA_PROJECT_MARKER_FILES = new String[]{"idea.iml", "community-main.iml", "intellij.idea.community.main.iml", "intellij.idea.ultimate.main.iml"};

    private PsiUtil() {
    }

    public static boolean isInstantiable(@NotNull PsiClass cls) {
        PsiModifierList modList;
        if (cls == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        if ((modList = cls.getModifierList()) == null || cls.isInterface() || modList.hasModifierProperty("abstract") || !PsiUtil.isPublicOrStaticInnerClass(cls)) {
            return false;
        }
        PsiMethod[] constructors = cls.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (!constructor.getParameterList().isEmpty() || !constructor.hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicOrStaticInnerClass(@NotNull PsiClass cls) {
        PsiModifierList modifiers;
        if (cls == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if ((modifiers = cls.getModifierList()) == null) {
            return false;
        }
        return modifiers.hasModifierProperty("public") && (cls.getParent() instanceof PsiFile || modifiers.hasModifierProperty("static"));
    }

    @Nullable
    public static String getReturnedLiteral(PsiMethod method, PsiClass cls) {
        Pair evaluateResult;
        PsiExpression value = PsiUtil.getReturnedExpression(method);
        if (value instanceof PsiLiteralExpression) {
            Object str = ((PsiLiteralExpression)value).getValue();
            return str == null ? null : str.toString();
        }
        if (value instanceof PsiMethodCallExpression) {
            if (PsiUtil.isSimpleClassNameExpression((PsiMethodCallExpression)value)) {
                return cls.getName();
            }
        } else if (value != null && (evaluateResult = StringExpressionHelper.evaluateConstantExpression((PsiElement)value)) != null && value.equals(evaluateResult.first)) {
            return (String)evaluateResult.second;
        }
        return null;
    }

    private static boolean isSimpleClassNameExpression(PsiMethodCallExpression expr) {
        String text = expr.getText();
        if (text == null) {
            return false;
        }
        return "getClass().getSimpleName()".equals(text = text.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll("\r", "")) || "this.getClass().getSimpleName()".equals(text);
    }

    @Nullable
    public static PsiExpression getReturnedExpression(PsiMethod method) {
        PsiStatement[] statements;
        PsiCodeBlock body = method.getBody();
        if (body != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            PsiField field;
            PsiElement element;
            PsiExpression value = ((PsiReturnStatement)statements[0]).getReturnValue();
            if (value instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && (field = (PsiField)element).hasModifierProperty("final")) {
                return field.getInitializer();
            }
            return value;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (!method.getParameterList().isEmpty() || !method.getName().equals(name)) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return PsiUtil.findNearestMethod(name, cls.getSuperClass());
    }

    public static boolean isIdeaProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Boolean flag = (Boolean)project.getUserData(IDEA_PROJECT);
        if (flag == null) {
            flag = PsiUtil.checkIdeaProject(project);
            project.putUserData(IDEA_PROJECT, (Object)flag);
        }
        return flag;
    }

    public static boolean isPluginProject(@NotNull Project project) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                PsiUtil.$$$reportNull$$$0(10);
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.allScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean isPluginModule(@NotNull Module module) {
        if (module == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                PsiUtil.$$$reportNull$$$0(9);
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
    }

    private static boolean isIntelliJBasedDir(VirtualFile baseDir) {
        if (baseDir == null) {
            return false;
        }
        for (VirtualFile dir : new VirtualFile[]{baseDir, baseDir.findChild("community"), baseDir.findChild("ultimate")}) {
            if (dir == null || !dir.isDirectory()) continue;
            for (String fileName : IDEA_PROJECT_MARKER_FILES) {
                if (dir.findChild(fileName) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void markAsIdeaProject(@NotNull Project project, boolean value) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        project.putUserData(IDEA_PROJECT, (Object)value);
    }

    private static boolean checkIdeaProject(@NotNull Project project) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (!PsiUtil.isIntelliJBasedDir(project.getBaseDir())) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, scope) != null;
    }

    @NotNull
    public static <E extends PsiElement> SmartPsiElementPointer<E> createPointer(@NotNull E e) {
        if (e == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)e.getProject()).createSmartPsiElementPointer(e);
        if (smartPsiElementPointer == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        return smartPsiElementPointer;
    }

    public static boolean isPluginXmlPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        return PsiUtil.isPluginProject(element.getProject()) && DescriptorUtil.isPluginXml(element.getContainingFile());
    }

    public static boolean isPathToIntelliJIdeaSources(String path) {
        for (String file : IDEA_PROJECT_MARKER_FILES) {
            if (!new File(path, file).isFile()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/util/PsiUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/util/PsiUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPublicOrStaticInnerClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPluginProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPluginModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markAsIdeaProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkIdeaProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPluginXmlPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isPluginModule$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isPluginProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

