/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.util.JvmClassUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public abstract class ExtensionLocator {
    @NotNull
    public abstract List<ExtensionCandidate> findCandidates();

    @NotNull
    public static ExtensionLocator byClass(@NotNull Project project, @NotNull JvmClass clazz) {
        if (project == null) {
            ExtensionLocator.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            ExtensionLocator.$$$reportNull$$$0(1);
        }
        ExtensionByClassLocator extensionByClassLocator = new ExtensionByClassLocator(project, clazz);
        if (extensionByClassLocator == null) {
            ExtensionLocator.$$$reportNull$$$0(2);
        }
        return extensionByClassLocator;
    }

    public static ExtensionLocator byPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExtensionLocator.$$$reportNull$$$0(3);
        }
        return new ExtensionByPsiClassLocator(psiClass);
    }

    public static ExtensionLocator byExtensionPoint(@NotNull ExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            ExtensionLocator.$$$reportNull$$$0(4);
        }
        return new ExtensionByExtensionPointLocator(extensionPoint, null);
    }

    public static ExtensionLocator byExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId) {
        if (extensionPoint == null) {
            ExtensionLocator.$$$reportNull$$$0(5);
        }
        if (extensionId == null) {
            ExtensionLocator.$$$reportNull$$$0(6);
        }
        return new ExtensionByExtensionPointLocator(extensionPoint, extensionId);
    }

    private static void processExtensionDeclarations(@Nullable String name, @NotNull Project project, boolean strictMatch, @NotNull BiFunction<Extension, XmlTag, Boolean> callback) {
        if (project == null) {
            ExtensionLocator.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            ExtensionLocator.$$$reportNull$$$0(8);
        }
        if (name == null) {
            return;
        }
        GlobalSearchScope scope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord((element, offsetInElement) -> {
            if (callback == null) {
                ExtensionLocator.$$$reportNull$$$0(10);
            }
            if (!(element instanceof XmlTag)) {
                return true;
            }
            PsiElement elementAtOffset = element.findElementAt(offsetInElement);
            if (elementAtOffset == null) {
                return true;
            }
            String foundText = elementAtOffset.getText();
            if (!strictMatch && !StringUtil.contains((CharSequence)foundText, (CharSequence)name)) {
                return true;
            }
            if (strictMatch && !StringUtil.equals((CharSequence)foundText, (CharSequence)name)) {
                return true;
            }
            XmlTag tag = (XmlTag)element;
            DomElement dom = DomUtil.getDomElement((PsiElement)tag);
            if (!(dom instanceof Extension)) {
                return true;
            }
            return (Boolean)callback.apply((Extension)dom, tag);
        }, (SearchScope)scope, name, (short)8, true);
    }

    private static List<ExtensionCandidate> findCandidatesByClassName(@Nullable String jvmClassName, @NotNull Project project) {
        if (project == null) {
            ExtensionLocator.$$$reportNull$$$0(9);
        }
        SmartList result = new SmartList();
        ExtensionLocator.processExtensionDeclarations(jvmClassName, project, true, (arg_0, arg_1) -> ExtensionLocator.lambda$findCandidatesByClassName$1((List)result, arg_0, arg_1));
        return result;
    }

    private static /* synthetic */ Boolean lambda$findCandidatesByClassName$1(List result, Extension extension, XmlTag tag) {
        if (extension.getExtensionPoint() != null) {
            result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag)));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/util/ExtensionLocator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionId";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "byClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byClass";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byPsiClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byExtensionPointAndId";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCandidatesByClassName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExtensionDeclarations$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtensionByExtensionPointLocator
    extends ExtensionLocator {
        private final ExtensionPoint myExtensionPoint;
        private final String myExtensionId;

        private ExtensionByExtensionPointLocator(@NotNull ExtensionPoint extensionPoint, @Nullable String extensionId) {
            if (extensionPoint == null) {
                ExtensionByExtensionPointLocator.$$$reportNull$$$0(0);
            }
            this.myExtensionPoint = extensionPoint;
            this.myExtensionId = extensionId;
        }

        @Override
        @NotNull
        public List<ExtensionCandidate> findCandidates() {
            XmlTag epTag = this.myExtensionPoint.getXmlTag();
            if (epTag == null) {
                List<ExtensionCandidate> list = Collections.emptyList();
                if (list == null) {
                    ExtensionByExtensionPointLocator.$$$reportNull$$$0(1);
                }
                return list;
            }
            String epNameToSearch = StringUtil.substringAfterLast((String)this.myExtensionPoint.getEffectiveQualifiedName(), (String)".");
            SmartList result = new SmartList();
            ExtensionLocator.processExtensionDeclarations(epNameToSearch, epTag.getProject(), false, (arg_0, arg_1) -> this.lambda$findCandidates$0((List)result, arg_0, arg_1));
            SmartList smartList = result;
            if (smartList == null) {
                ExtensionByExtensionPointLocator.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private /* synthetic */ Boolean lambda$findCandidates$0(List result, Extension extension, XmlTag tag) {
            ExtensionPoint ep = extension.getExtensionPoint();
            if (ep == null) {
                return true;
            }
            if (StringUtil.equals((CharSequence)ep.getEffectiveQualifiedName(), (CharSequence)this.myExtensionPoint.getEffectiveQualifiedName()) && (this.myExtensionId == null || this.myExtensionId.equals(extension.getId().getStringValue()))) {
                result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag)));
                return this.myExtensionId == null;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionPoint";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByExtensionPointLocator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByExtensionPointLocator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findCandidates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtensionByPsiClassLocator
    extends ExtensionLocator {
        private final PsiClass myPsiClass;

        ExtensionByPsiClassLocator(PsiClass psiClass) {
            this.myPsiClass = psiClass;
        }

        @Override
        @NotNull
        public List<ExtensionCandidate> findCandidates() {
            List list = ExtensionLocator.findCandidatesByClassName(ClassUtil.getJVMClassName((PsiClass)this.myPsiClass), this.myPsiClass.getProject());
            if (list == null) {
                ExtensionByPsiClassLocator.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByPsiClassLocator", "findCandidates"));
        }
    }

    private static class ExtensionByClassLocator
    extends ExtensionLocator {
        private final Project myProject;
        private final JvmClass myClazz;

        ExtensionByClassLocator(@NotNull Project project, @NotNull JvmClass clazz) {
            if (project == null) {
                ExtensionByClassLocator.$$$reportNull$$$0(0);
            }
            if (clazz == null) {
                ExtensionByClassLocator.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myClazz = clazz;
        }

        @Override
        @NotNull
        public List<ExtensionCandidate> findCandidates() {
            List list = ExtensionLocator.findCandidatesByClassName(JvmClassUtil.getJvmClassName((JvmClass)this.myClazz), this.myProject);
            if (list == null) {
                ExtensionByClassLocator.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByClassLocator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByClassLocator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findCandidates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

