/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElement;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElementFactory;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataNavigationHandler
implements GutterIconNavigationHandler<PsiMethod> {
    public void navigate(MouseEvent e, PsiMethod elt) {
        List<String> fileNames = TestDataNavigationHandler.getFileNames(elt);
        if (fileNames.isEmpty()) {
            return;
        }
        TestDataNavigationHandler.navigate(new RelativePoint(e), fileNames, elt.getProject());
    }

    @NotNull
    static List<String> getFileNames(PsiMethod method) {
        List<String> list = TestDataNavigationHandler.getFileNames(method, true);
        if (list == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    static List<String> getFileNames(PsiMethod method, boolean collectByExistingFiles) {
        List<String> fileNames = null;
        String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass());
        if (testDataPath != null) {
            fileNames = new TestDataReferenceCollector(testDataPath, method.getName().substring(4)).collectTestDataReferences(method, collectByExistingFiles);
        }
        if (collectByExistingFiles && (fileNames == null || fileNames.isEmpty())) {
            fileNames = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method);
        }
        if (fileNames == null) {
            fileNames = Collections.emptyList();
        }
        List<String> list = fileNames;
        if (list == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static void navigate(@NotNull RelativePoint point, @NotNull List<String> testDataFiles, Project project) {
        if (point == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(2);
        }
        if (testDataFiles == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(3);
        }
        if (testDataFiles.size() == 1) {
            TestDataUtil.openOrAskToCreateFile(project, testDataFiles.get(0));
        } else if (testDataFiles.size() > 1) {
            TestDataGroupVirtualFile groupFile = TestDataUtil.getTestDataGroup(testDataFiles);
            if (groupFile != null) {
                new OpenFileDescriptor(project, (VirtualFile)groupFile).navigate(true);
            } else {
                TestDataNavigationHandler.showNavigationPopup(project, testDataFiles, point);
            }
        }
    }

    @NotNull
    public static List<String> fastGetTestDataPathsByRelativePath(@NotNull String testDataFileRelativePath, PsiMethod method) {
        if (testDataFileRelativePath == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(4);
        }
        List<String> list = TestDataNavigationHandler.getFileNames(method, false).stream().filter(path -> {
            if (testDataFileRelativePath == null) {
                TestDataNavigationHandler.$$$reportNull$$$0(6);
            }
            return path.endsWith(testDataFileRelativePath.startsWith("/") ? testDataFileRelativePath : "/" + testDataFileRelativePath);
        }).distinct().collect(Collectors.toList());
        if (list == null) {
            TestDataNavigationHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void showNavigationPopup(Project project, List<String> filePaths, RelativePoint point) {
        List<TestDataNavigationElement> elementsToDisplay = TestDataNavigationHandler.getElementsToDisplay(project, filePaths);
        for (String path : filePaths) {
            if (LocalFileSystem.getInstance().refreshAndFindFileByPath(path) != null) continue;
            elementsToDisplay.add(TestDataNavigationElementFactory.createForCreateMissingFilesOption(filePaths));
            break;
        }
        JBList list = new JBList(elementsToDisplay);
        list.setSelectionMode(0);
        list.setCellRenderer(new ColoredListCellRenderer<TestDataNavigationElement>(){

            protected void customizeCellRenderer(@NotNull JList list, TestDataNavigationElement element, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.getTitleFragments().forEach(pair -> this.append((String)pair.getFirst(), (SimpleTextAttributes)pair.getSecond()));
                this.setIcon(element.getIcon());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler$1", "customizeCellRenderer"));
            }
        });
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
        builder.setItemChoosenCallback(() -> TestDataNavigationHandler.lambda$showNavigationPopup$1((JList)list, project)).createPopup().show(point);
    }

    private static List<TestDataNavigationElement> getElementsToDisplay(Project project, List<String> filePaths) {
        ContainerUtil.removeDuplicates(filePaths);
        Collections.sort(filePaths, String.CASE_INSENSITIVE_ORDER);
        ArrayList<TestDataNavigationElement> result = new ArrayList<TestDataNavigationElement>();
        HashSet<String> usedPaths = new HashSet<String>();
        for (String path1 : filePaths) {
            if (usedPaths.contains(path1)) continue;
            boolean groupFound = false;
            for (String path2 : filePaths) {
                TestDataGroupVirtualFile group;
                if (usedPaths.contains(path2) || path2.equals(path1) || (group = TestDataUtil.getTestDataGroup(path1, path2)) == null) continue;
                groupFound = true;
                result.add(TestDataNavigationElementFactory.createForGroup(project, group));
                usedPaths.add(path1);
                usedPaths.add(path2);
                break;
            }
            if (groupFound) continue;
            result.add(TestDataNavigationElementFactory.createForFile(project, path1));
            usedPaths.add(path1);
        }
        return result;
    }

    private static /* synthetic */ void lambda$showNavigationPopup$1(JList list, Project project) {
        TestDataNavigationElement selectedElement = (TestDataNavigationElement)list.getSelectedValue();
        if (selectedElement != null) {
            selectedElement.performAction(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFiles";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFileRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fastGetTestDataPathsByRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fastGetTestDataPathsByRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fastGetTestDataPathsByRelativePath$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

