/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PointableCandidate;

class LineMarkerInfoHelper {
    private static final NotNullFunction<PointableCandidate, Collection<? extends PsiElement>> CONVERTER = candidate -> Collections.singleton(candidate.pointer.getElement());
    private static final NotNullFunction<PointableCandidate, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = candidate -> GotoRelatedItem.createItems(Collections.singleton(candidate.pointer.getElement()), (String)"DevKit");
    private static final NullableFunction<PointableCandidate, String> EXTENSION_NAMER = LineMarkerInfoHelper.createNamer("line.marker.tooltip.extension.declaration", (NotNullFunction<XmlTag, String>)((NotNullFunction)XmlTag::getName));
    private static final NullableFunction<PointableCandidate, String> EXTENSION_POINT_NAMER = LineMarkerInfoHelper.createNamer("line.marker.tooltip.extension.point.declaration", (NotNullFunction<XmlTag, String>)((NotNullFunction)tag -> {
        String name = tag.getAttributeValue("name");
        if (StringUtil.isEmpty((String)name)) {
            name = "Extension Point";
        }
        return name;
    }));
    private static final String MODULE_SUFFIX_PATTERN = " <font color='" + ColorUtil.toHex((Color)UIUtil.getInactiveTextColor()) + "'>[{0}]</font>";

    private LineMarkerInfoHelper() {
    }

    @NotNull
    public static RelatedItemLineMarkerInfo<PsiElement> createExtensionLineMarkerInfo(List<? extends PointableCandidate> targets, PsiElement element) {
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, "Choose Extension", EXTENSION_NAMER);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(0);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    public static RelatedItemLineMarkerInfo<PsiElement> createExtensionPointLineMarkerInfo(List<? extends PointableCandidate> targets, PsiElement element) {
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, "Choose Extension Point", EXTENSION_POINT_NAMER);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(1);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    private static RelatedItemLineMarkerInfo<PsiElement> createPluginLineMarkerInfo(List<? extends PointableCandidate> targets, PsiElement element, String popup, NullableFunction<PointableCandidate, String> namer) {
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)AllIcons.Nodes.Plugin, CONVERTER, RELATED_ITEM_PROVIDER).setTargets(targets).setPopupTitle(popup).setNamer(namer).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(element);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(2);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    private static NullableFunction<PointableCandidate, String> createNamer(String tooltipPatternPropertyName, NotNullFunction<XmlTag, String> nameProvider) {
        NullableFunction nullableFunction = target -> {
            XmlTag tag = (XmlTag)target.pointer.getElement();
            if (tag == null) {
                throw new NullPointerException("Null element for pointable candidate: " + target);
            }
            PsiFile file = tag.getContainingFile();
            String path = file.getVirtualFile().getPath();
            String fileDisplayName = file.getName();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module != null) {
                fileDisplayName = fileDisplayName + MessageFormat.format(MODULE_SUFFIX_PATTERN, module.getName());
            }
            return DevKitBundle.message(tooltipPatternPropertyName, path, String.valueOf(tag.getTextRange().getStartOffset()), nameProvider.fun((Object)tag), fileDisplayName);
        };
        if (nullableFunction == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(3);
        }
        return nullableFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensionLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensionPointLineMarkerInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginLineMarkerInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

