/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class UsePrimitiveTypesInspection
extends DevKitInspectionBase {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UsePrimitiveTypesInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                super.visitBinaryExpression(expression);
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE)) {
                    PsiExpression lOperand = expression.getLOperand();
                    PsiExpression rOperand = expression.getROperand();
                    if (rOperand != null && (UsePrimitiveTypesInspection.isPrimitiveTypeRef(lOperand) || UsePrimitiveTypesInspection.isPrimitiveTypeRef(rOperand))) {
                        String name = JavaTokenType.NE.equals(tokenType) ? IntentionPowerPackBundle.message((String)"replace.equality.with.not.equals.intention.name", (Object[])new Object[0]) : IntentionPowerPackBundle.message((String)"replace.equality.with.equals.intention.name", (Object[])new Object[0]);
                        holder.registerProblem((PsiElement)expression.getOperationSign(), "Primitive types should be compared with .equals", new LocalQuickFix[]{new ReplaceEqualityWithEqualsFix(name)});
                    }
                }
            }
        };
    }

    private static boolean isPrimitiveTypeRef(PsiExpression expression) {
        PsiElement target;
        if (expression instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) instanceof PsiField) {
            PsiClass containingClass = ((PsiField)target).getContainingClass();
            return containingClass != null && PsiType.class.getName().equals(containingClass.getQualifiedName()) && !"NULL".equals(((PsiField)target).getName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UsePrimitiveTypesInspection", "buildInternalVisitor"));
    }

    private static class ReplaceEqualityWithEqualsFix
    implements LocalQuickFix {
        private final String myName;

        public ReplaceEqualityWithEqualsFix(String name) {
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ReplaceEqualityWithEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace equality with .equals" == null) {
                ReplaceEqualityWithEqualsFix.$$$reportNull$$$0(1);
            }
            return "Replace equality with .equals";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                ReplaceEqualityWithEqualsFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceEqualityWithEqualsFix.$$$reportNull$$$0(3);
            }
            if ((psiElement = descriptor.getPsiElement()) instanceof PsiJavaToken) {
                String prefix;
                IElementType tokenType = ((PsiJavaToken)psiElement).getTokenType();
                if (tokenType.equals(JavaTokenType.EQEQ)) {
                    prefix = "";
                } else if (tokenType.equals(JavaTokenType.NE)) {
                    prefix = "!";
                } else {
                    return;
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiBinaryExpression) {
                    boolean flip;
                    PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
                    PsiExpression lOperand = ((PsiBinaryExpression)parent).getLOperand();
                    if (rOperand != null && ((flip = UsePrimitiveTypesInspection.isPrimitiveTypeRef(rOperand)) || UsePrimitiveTypesInspection.isPrimitiveTypeRef(lOperand))) {
                        CommentTracker commentTracker = new CommentTracker();
                        String rText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)rOperand));
                        String lText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)lOperand));
                        String lhText = flip ? rText : lText;
                        String rhText = flip ? lText : rText;
                        String expString = prefix + lhText + ".equals(" + rhText + ')';
                        PsiReplacementUtil.replaceExpression((PsiExpression)((PsiBinaryExpression)parent), (String)expString, (CommentTracker)commentTracker);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UsePrimitiveTypesInspection$ReplaceEqualityWithEqualsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UsePrimitiveTypesInspection$ReplaceEqualityWithEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

