/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "AddDescriptionKeyIntention", "Companion", "intellij.devkit"})
public final class RegistryPropertiesAnnotator
implements Annotator {
    @NonNls
    private static final String REGISTRY_PROPERTIES_FILENAME = "registry.properties";
    @NonNls
    private static final String DESCRIPTION_SUFFIX = ".description";
    @NonNls
    private static final String RESTART_REQUIRED_SUFFIX = ".restartRequired";
    public static final Companion Companion = new Companion(null);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (!(element instanceof PropertyKeyImpl)) {
            return;
        }
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationSession, (String)"holder.currentAnnotationSession");
        PsiFile psiFile = annotationSession.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"holder.currentAnnotationSession.file");
        PsiFile file = psiFile;
        if (!Companion.isRegistryPropertiesFile(file)) {
            return;
        }
        String string = ((PropertyKeyImpl)element).getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
        String propertyName = string;
        if (Companion.isImplicitUsageKey(propertyName)) {
            return;
        }
        PsiFile psiFile2 = file;
        if (psiFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
        }
        PropertiesFile propertiesFile = (PropertiesFile)psiFile2;
        IProperty descriptionProperty = propertiesFile.findPropertyByKey(propertyName + DESCRIPTION_SUFFIX);
        if (descriptionProperty == null) {
            holder.createWarningAnnotation(((PropertyKeyImpl)element).getNode(), "Key '" + propertyName + "' does not have description key").registerFix((IntentionAction)new AddDescriptionKeyIntention(propertyName));
        }
    }

    @JvmStatic
    public static final boolean isImplicitUsageKey(@NotNull String keyName) {
        return Companion.isImplicitUsageKey(keyName);
    }

    @JvmStatic
    public static final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
        return Companion.isRegistryPropertiesFile(psiFile);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$AddDescriptionKeyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "myPropertyName", "", "(Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.devkit"})
    private static final class AddDescriptionKeyIntention
    implements IntentionAction {
        private final String myPropertyName;

        @Nls
        @NotNull
        public String getText() {
            return "Add description key for '" + this.myPropertyName + '\'';
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Add description key";
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            IProperty descriptionProperty;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            PropertyImpl originalProperty = (PropertyImpl)propertiesFile.findPropertyByKey(this.myPropertyName);
            IProperty iProperty = descriptionProperty = propertiesFile.addPropertyAfter(this.myPropertyName + RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX, "Description", (IProperty)originalProperty);
            Intrinsics.checkExpressionValueIsNotNull((Object)iProperty, (String)"descriptionProperty");
            PsiElement psiElement = iProperty.getPsiElement();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            }
            ASTNode aSTNode = ((PropertyImpl)psiElement).getValueNode();
            if (aSTNode == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"(descriptionProperty.psi\u2026PropertyImpl).valueNode!!");
            ASTNode valueNode = aSTNode;
            PsiNavigateUtil.navigate((PsiElement)valueNode.getPsi());
        }

        public boolean startInWriteAction() {
            return true;
        }

        public AddDescriptionKeyIntention(@NotNull String myPropertyName) {
            Intrinsics.checkParameterIsNotNull((Object)myPropertyName, (String)"myPropertyName");
            this.myPropertyName = myPropertyName;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$Companion;", "", "()V", "DESCRIPTION_SUFFIX", "", "REGISTRY_PROPERTIES_FILENAME", "RESTART_REQUIRED_SUFFIX", "isImplicitUsageKey", "", "keyName", "isRegistryPropertiesFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.devkit"})
    public static final class Companion {
        @JvmStatic
        public final boolean isImplicitUsageKey(@NotNull String keyName) {
            Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
            return StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX) || StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.RESTART_REQUIRED_SUFFIX);
        }

        @JvmStatic
        public final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            return PsiUtil.isIdeaProject(psiFile.getProject()) && Intrinsics.areEqual((Object)psiFile.getName(), (Object)RegistryPropertiesAnnotator.REGISTRY_PROPERTIES_FILENAME);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

