/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Anchor;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;
import org.jetbrains.idea.devkit.inspections.quickfix.AddWithTagFix;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PluginXmlDomInspection
extends BasicDomElementsInspection<IdeaPlugin> {
    private static final Logger LOG = Logger.getInstance(PluginXmlDomInspection.class);
    public List<String> myRegistrationCheckIgnoreClassList = new ExternalizableStringSet(new String[0]);
    private static final Pattern BASE_LINE_EXTRACTOR = Pattern.compile("(?:\\p{javaLetter}+-)?(\\d+)(?:\\..*)?");
    private static final int FIRST_BRANCH_SUPPORTING_STAR = 131;

    public PluginXmlDomInspection() {
        super(IdeaPlugin.class, new Class[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        String title = DevKitBundle.message("inspections.plugin.xml.ignore.classes.title", new Object[0]);
        ListTable table = new ListTable(new ListWrappingTableModel(this.myRegistrationCheckIgnoreClassList, title));
        JPanel panel = UiUtils.createAddRemoveTreeClassChooserPanel((ListTable)table, (String)title, (String[])new String[0]);
        return new FormBuilder().addComponentFillVertically((JComponent)panel, 0).getPanel();
    }

    @NotNull
    public String getShortName() {
        if ("PluginXmlValidity" == null) {
            PluginXmlDomInspection.$$$reportNull$$$0(0);
        }
        return "PluginXmlValidity";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue domValue;
        super.checkDomElement(element, holder, helper);
        if (element instanceof IdeaPlugin) {
            PluginXmlDomInspection.annotateIdeaPlugin((IdeaPlugin)element, holder);
            PluginXmlDomInspection.checkJetBrainsPlugin((IdeaPlugin)element, holder);
        } else if (element instanceof Extension) {
            this.annotateExtension((Extension)element, holder);
        } else if (element instanceof ExtensionPoint) {
            this.annotateExtensionPoint((ExtensionPoint)element, holder);
        } else if (element instanceof Vendor) {
            PluginXmlDomInspection.annotateVendor((Vendor)element, holder);
        } else if (element instanceof IdeaVersion) {
            PluginXmlDomInspection.annotateIdeaVersion((IdeaVersion)element, holder);
        } else if (element instanceof Extensions) {
            PluginXmlDomInspection.annotateExtensions((Extensions)element, holder);
        } else if (element instanceof AddToGroup) {
            PluginXmlDomInspection.annotateAddToGroup((AddToGroup)element, holder);
        } else if (element instanceof Action) {
            PluginXmlDomInspection.annotateAction((Action)element, holder);
        } else if (element instanceof Group) {
            PluginXmlDomInspection.annotateGroup((Group)element, holder);
        } else if (element instanceof Component) {
            this.annotateComponent((Component)element, holder);
            if (element instanceof Component.Project) {
                PluginXmlDomInspection.annotateProjectComponent((Component.Project)element, holder);
            }
        }
        if (element instanceof GenericDomValue && (domValue = (GenericDomValue)element).getConverter() instanceof PluginPsiClassConverter) {
            PluginXmlDomInspection.annotatePsiClassValue(domValue, holder);
        }
    }

    private static void annotatePsiClassValue(GenericDomValue domValue, DomElementAnnotationHolder holder) {
        PsiClass psiClass;
        Object value = domValue.getValue();
        if (value instanceof PsiClass && (psiClass = (PsiClass)value).getContainingClass() != null && !StringUtil.containsChar((String)StringUtil.notNullize((String)domValue.getRawText()), (char)'$')) {
            holder.createProblem((DomElement)domValue, DevKitBundle.message("inspections.plugin.xml.inner.class.must.be.separated.with.dollar", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void annotateIdeaPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaPlugin.getIdeaPluginVersion(), holder);
        if (DomUtil.hasXml(ideaPlugin.getUseIdeaClassloader())) {
            PluginXmlDomInspection.highlightDeprecated(ideaPlugin.getUseIdeaClassloader(), "Deprecated", holder, true, true);
        }
    }

    private static void checkJetBrainsPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder) {
        Module module = ideaPlugin.getModule();
        if (module == null) {
            return;
        }
        if (!PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        String pluginId = ideaPlugin.getPluginId();
        if (pluginId == null || pluginId.equals("com.intellij")) {
            return;
        }
        XmlTag xmlTag = ideaPlugin.getXmlTag();
        if (xmlTag == null) {
            return;
        }
        VirtualFile virtualFile = xmlTag.getContainingFile().getVirtualFile();
        if (virtualFile == null || !ModuleRootManager.getInstance((Module)module).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION)) {
            return;
        }
        Vendor vendor = ideaPlugin.getVendor();
        if (!DomUtil.hasXml((DomElement)vendor)) {
            holder.createProblem((DomElement)DomUtil.getFileElement((DomElement)ideaPlugin), DevKitBundle.message("inspections.plugin.xml.plugin.should.have.jetbrains.vendor", new Object[0]), new LocalQuickFix[]{new SpecifyJetBrainsAsVendorQuickFix()});
        } else if (!PluginManagerMain.isDevelopedByJetBrains((String)vendor.getValue())) {
            holder.createProblem((DomElement)vendor, DevKitBundle.message("inspections.plugin.xml.plugin.should.include.jetbrains.vendor", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void annotateExtensionPoint(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder) {
        Module module;
        GenericAttributeValue<String> qualifiedName;
        GenericAttributeValue<String> name;
        if (extensionPoint.getWithElements().isEmpty() && !extensionPoint.collectMissingWithTags().isEmpty()) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.ep.doesnt.have.with", new Object[0]), new LocalQuickFix[]{new AddWithTagFix()});
        }
        if (!PluginXmlDomInspection.isValidEpName(name = extensionPoint.getName())) {
            holder.createProblem(name, ProblemHighlightType.WEAK_WARNING, DevKitBundle.message("inspections.plugin.xml.invalid.ep.name", name.getValue()), null, new LocalQuickFix[0]);
        }
        if (!PluginXmlDomInspection.isValidEpName(qualifiedName = extensionPoint.getQualifiedName())) {
            holder.createProblem(qualifiedName, ProblemHighlightType.WEAK_WARNING, DevKitBundle.message("inspections.plugin.xml.invalid.ep.qualified.name", qualifiedName.getValue()), null, new LocalQuickFix[0]);
        }
        if (ComponentModuleRegistrationChecker.isIdeaPlatformModule(module = extensionPoint.getModule())) {
            ComponentModuleRegistrationChecker.checkProperModule(extensionPoint, holder, this.myRegistrationCheckIgnoreClassList);
        }
    }

    private static boolean isValidEpName(GenericAttributeValue<String> nameAttrValue) {
        if (!nameAttrValue.exists()) {
            return true;
        }
        String name = (String)nameAttrValue.getValue();
        return StringUtil.isNotEmpty((String)name) && Character.isLowerCase(name.charAt(0)) && !name.toUpperCase().equals(name) && StringUtil.isLatinAlphanumeric((CharSequence)name.replace(".", "")) && name.charAt(name.length() - 1) != '.';
    }

    private static void annotateExtensions(Extensions extensions, DomElementAnnotationHolder holder) {
        GenericAttributeValue<IdeaPlugin> xmlnsAttribute = extensions.getXmlns();
        if (DomUtil.hasXml(xmlnsAttribute)) {
            PluginXmlDomInspection.highlightDeprecated(xmlnsAttribute, DevKitBundle.message("inspections.plugin.xml.use.defaultExtensionNs", new Object[0]), holder, false, true);
            return;
        }
        if (!DomUtil.hasXml(extensions.getDefaultExtensionNs())) {
            holder.createProblem((DomElement)extensions, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitBundle.message("inspections.plugin.xml.specify.defaultExtensionNs.explicitly", "com.intellij"), null, new LocalQuickFix[]{new AddDomElementQuickFix<GenericAttributeValue>(extensions.getDefaultExtensionNs()){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.applyFix(project, descriptor);
                    ((GenericAttributeValue)this.myElement).setStringValue("com.intellij");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "descriptor";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$1";
                    objectArray[2] = "applyFix";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }});
        }
    }

    private static void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMin(), holder);
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMax(), holder);
        PluginXmlDomInspection.highlightUntilBuild(ideaVersion, holder);
    }

    private static void highlightUntilBuild(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        String untilBuild = ideaVersion.getUntilBuild().getStringValue();
        if (untilBuild != null && PluginXmlDomInspection.isStarSupported(ideaVersion.getSinceBuild().getStringValue())) {
            Matcher matcher = IdeaPluginDescriptorImpl.EXPLICIT_BIG_NUMBER_PATTERN.matcher(untilBuild);
            if (matcher.matches()) {
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.use.asterisk.instead.of.big.number", matcher.group(2)), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar((String)untilBuild))});
            }
            if (untilBuild.matches("\\d+")) {
                int branch = Integer.parseInt(untilBuild);
                String corrected = branch - 1 + ".*";
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.misleading.plain.number", untilBuild, corrected), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(corrected)});
            }
        }
    }

    private static boolean isStarSupported(String buildNumber) {
        if (buildNumber == null) {
            return false;
        }
        Matcher matcher = BASE_LINE_EXTRACTOR.matcher(buildNumber);
        if (matcher.matches()) {
            int branch = Integer.parseInt(matcher.group(1));
            return branch >= 131;
        }
        return false;
    }

    private void annotateExtension(Extension extension, DomElementAnnotationHolder holder) {
        PsiClass value;
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        GenericAttributeValue<PsiClass> interfaceAttribute = extensionPoint.getInterface();
        if (DomUtil.hasXml(interfaceAttribute) && (value = (PsiClass)interfaceAttribute.getValue()) != null && value.isDeprecated()) {
            PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep", extensionPoint.getEffectiveQualifiedName()), holder, false, false);
            return;
        }
        if ("com.intellij.errorHandler".equals(extensionPoint.getEffectiveQualifiedName()) && extension.exists()) {
            Object plugin;
            String implementation = extension.getXmlTag().getAttributeValue("implementation");
            if (ITNReporter.class.getName().equals(implementation) && (plugin = (IdeaPlugin)extension.getParentOfType(IdeaPlugin.class, true)) != null) {
                Vendor vendor = plugin.getVendor();
                RemoveDomElementQuickFix fix = new RemoveDomElementQuickFix((DomElement)extension);
                if (DomUtil.hasXml((DomElement)vendor) && PluginManagerMain.isDevelopedByJetBrains((String)vendor.getValue())) {
                    holder.createProblem((DomElement)extension, ProblemHighlightType.LIKE_UNUSED_SYMBOL, DevKitBundle.message("inspections.plugin.xml.no.need.to.specify.itnReporter", new Object[0]), null, new LocalQuickFix[]{fix}).highlightWholeElement();
                } else {
                    boolean inPlatformCode;
                    Module module = plugin.getModule();
                    boolean bl = inPlatformCode = module != null && module.getName().startsWith("intellij.platform.");
                    if (!inPlatformCode) {
                        holder.createProblem((DomElement)extension, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitBundle.message("inspections.plugin.xml.third.party.plugins.must.not.use.itnReporter", new Object[0]), null, new LocalQuickFix[]{fix}).highlightWholeElement();
                    }
                }
            }
        }
        List descriptions = extension.getGenericInfo().getAttributeChildrenDescriptions();
        for (DomAttributeChildDescription attributeDescription : descriptions) {
            PsiField psiField;
            PsiElement declaration;
            GenericAttributeValue attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension);
            if (attributeValue == null || !DomUtil.hasXml((DomElement)attributeValue)) continue;
            if ("icon".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
            } else if ("order".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateOrderAttributeProblems(holder, attributeValue);
            }
            if (!((declaration = attributeDescription.getDeclaration(extension.getManager().getProject())) instanceof PsiField) || !(psiField = (PsiField)declaration).isDeprecated()) continue;
            PluginXmlDomInspection.highlightDeprecated((DomElement)attributeValue, DevKitBundle.message("inspections.plugin.xml.deprecated.attribute", attributeDescription.getName()), holder, false, true);
        }
        Module module = extension.getModule();
        if (ComponentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
            ComponentModuleRegistrationChecker.checkProperXmlFileForExtension(extension, holder, this.myRegistrationCheckIgnoreClassList);
        }
    }

    private void annotateComponent(Component component, DomElementAnnotationHolder holder) {
        Module module = component.getModule();
        if (ComponentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
            ComponentModuleRegistrationChecker.checkProperXmlFileForClass(component, holder, (PsiClass)component.getImplementationClass().getValue(), this.myRegistrationCheckIgnoreClassList);
        }
    }

    private static void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(vendor.getLogo(), holder);
    }

    private static void highlightAttributeNotUsedAnymore(GenericAttributeValue attributeValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)attributeValue)) {
            return;
        }
        PluginXmlDomInspection.highlightDeprecated((DomElement)attributeValue, DevKitBundle.message("inspections.plugin.xml.attribute.not.used.anymore", attributeValue.getXmlElementName()), holder, true, true);
    }

    private static void annotateAddToGroup(AddToGroup addToGroup, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(addToGroup.getRelativeToAction())) {
            return;
        }
        if (!DomUtil.hasXml(addToGroup.getAnchor())) {
            holder.createProblem((DomElement)addToGroup, DevKitBundle.message("inspections.plugin.xml.anchor.must.have.relative-to-action", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(addToGroup.getAnchor())});
            return;
        }
        Anchor value = (Anchor)((Object)addToGroup.getAnchor().getValue());
        if (value == Anchor.after || value == Anchor.before) {
            return;
        }
        holder.createProblem(addToGroup.getAnchor(), DevKitBundle.message("inspections.plugin.xml.must.use.after.before.with.relative-to-action", new Object[]{Anchor.after, Anchor.before}), new LocalQuickFix[0]);
    }

    private static void annotateGroup(Group group, DomElementAnnotationHolder holder) {
        GenericAttributeValue<String> iconAttribute = group.getIcon();
        if (DomUtil.hasXml(iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
    }

    private static void annotateAction(Action action, DomElementAnnotationHolder holder) {
        GenericAttributeValue<String> iconAttribute = action.getIcon();
        if (DomUtil.hasXml(iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
    }

    private static void annotateProjectComponent(Component.Project projectComponent, DomElementAnnotationHolder holder) {
        GenericDomValue<Boolean> skipForDefault = projectComponent.getSkipForDefaultProject();
        if (skipForDefault.exists()) {
            PluginXmlDomInspection.highlightDeprecated(skipForDefault, DevKitBundle.message("inspections.plugin.xml.skipForDefaultProject.deprecated", new Object[0]), holder, true, true);
        }
    }

    private static void annotateOrderAttributeProblems(DomElementAnnotationHolder holder, GenericAttributeValue attributeValue) {
        String orderValue = attributeValue.getStringValue();
        if (StringUtil.isEmpty((String)orderValue)) {
            return;
        }
        try {
            LoadingOrder.readOrder((String)orderValue);
        }
        catch (AssertionError ignore) {
            holder.createProblem((DomElement)attributeValue, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.invalid.order.attribute", new Object[0]));
            return;
        }
        PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
    }

    private static void annotateResolveProblems(DomElementAnnotationHolder holder, GenericAttributeValue attributeValue) {
        XmlAttributeValue value = attributeValue.getXmlAttributeValue();
        if (value != null) {
            for (PsiReference reference : value.getReferences()) {
                if (reference.resolve() != null) continue;
                holder.createResolveProblem((GenericDomValue)attributeValue, reference);
            }
        }
    }

    private static void highlightDeprecated(DomElement element, String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement) {
        DomElementProblemDescriptor problem = !useRemoveQuickfix ? holder.createProblem(element, ProblemHighlightType.LIKE_DEPRECATED, message, null, new LocalQuickFix[0]) : holder.createProblem(element, ProblemHighlightType.LIKE_DEPRECATED, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)});
        if (highlightWholeElement) {
            problem.highlightWholeElement();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getShortName"));
    }

    private static class SpecifyJetBrainsAsVendorQuickFix
    implements LocalQuickFix {
        private SpecifyJetBrainsAsVendorQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Specify JetBrains as vendor" == null) {
                SpecifyJetBrainsAsVendorQuickFix.$$$reportNull$$$0(0);
            }
            return "Specify JetBrains as vendor";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SpecifyJetBrainsAsVendorQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                SpecifyJetBrainsAsVendorQuickFix.$$$reportNull$$$0(2);
            }
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement((XmlFile)file, IdeaPlugin.class);
            if (fileElement != null) {
                IdeaPlugin root = (IdeaPlugin)fileElement.getRootElement();
                XmlTag after = SpecifyJetBrainsAsVendorQuickFix.getLastSubTag(root, new DomElement[]{root.getId(), root.getDescription(), root.getVersion(), root.getName()});
                XmlTag rootTag = root.getXmlTag();
                XmlTag vendorTag = rootTag.createChildTag("vendor", rootTag.getNamespace(), "JetBrains", false);
                if (after == null) {
                    rootTag.addSubTag(vendorTag, true);
                } else {
                    rootTag.addAfter((PsiElement)vendorTag, (PsiElement)after);
                }
            }
        }

        private static XmlTag getLastSubTag(IdeaPlugin root, DomElement ... children) {
            HashSet<XmlTag> childrenTags = new HashSet<XmlTag>();
            for (DomElement child : children) {
                if (child == null) continue;
                childrenTags.add(child.getXmlTag());
            }
            XmlTag[] subTags = root.getXmlTag().getSubTags();
            for (int i = subTags.length - 1; i >= 0; --i) {
                if (!childrenTags.contains(subTags[i])) continue;
                return subTags[i];
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CorrectUntilBuildAttributeFix
    implements LocalQuickFix {
        private final String myCorrectValue;

        public CorrectUntilBuildAttributeFix(String correctValue) {
            this.myCorrectValue = correctValue;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Change 'until-build' to '" + this.myCorrectValue + "'";
            if (string == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Correct 'until-build' attribute" == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(1);
            }
            return "Correct 'until-build' attribute";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CorrectUntilBuildAttributeFix.$$$reportNull$$$0(3);
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class, (boolean)false);
            GenericAttributeValue domElement = DomManager.getDomManager((Project)project).getDomElement(attribute);
            LOG.assertTrue(domElement != null);
            domElement.setStringValue(this.myCorrectValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$CorrectUntilBuildAttributeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$CorrectUntilBuildAttributeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

