/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionDescriptionNotFoundInspection
extends DevKitInspectionBase {
    @NonNls
    private static final String INSPECTION_PROFILE_ENTRY = DescriptionType.INSPECTION.getClassName();

    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(1);
        }
        Project project = psiClass.getProject();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(psiClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(INSPECTION_PROFILE_ENTRY, psiClass.getResolveScope());
        if (base == null || !psiClass.isInheritor(base, true) || InspectionDescriptionNotFoundInspection.isPathMethodsAreOverridden(psiClass)) {
            return null;
        }
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        if (!info.isValid() || info.hasDescriptionFile()) {
            return null;
        }
        PsiElement problemElement = InspectionDescriptionNotFoundInspection.getProblemElement(psiClass, info.getShortNameMethod());
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problemElement == null ? nameIdentifier : problemElement), "Inspection does not have a description", isOnTheFly, new LocalQuickFix[]{new CreateHtmlDescriptionFix(info.getFilename(), module, DescriptionType.INSPECTION)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static PsiElement getProblemElement(PsiClass psiClass, @Nullable PsiMethod method) {
        if (method != null && method.getContainingClass() == psiClass) {
            return PsiUtil.getReturnedExpression(method);
        }
        return psiClass.getNameIdentifier();
    }

    private static boolean isPathMethodsAreOverridden(PsiClass psiClass) {
        return !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionUrl", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", INSPECTION_PROFILE_ENTRY, psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", INSPECTION_PROFILE_ENTRY, psiClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @NotNull String classFQN, @Nullable PsiClass psiClass) {
        if (methodName == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(2);
        }
        if (classFQN == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            return false;
        }
        for (PsiMethod method : psiClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return classFQN.equals(containingClass.getQualifiedName());
        }
        return InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, classFQN, psiClass.getSuperClass());
    }

    @NotNull
    public String getShortName() {
        if ("InspectionDescriptionNotFoundInspection" == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(4);
        }
        return "InspectionDescriptionNotFoundInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLastMethodDefinitionIn";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

