/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterActionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterComponentFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ComponentNotRegisteredInspection
extends DevKitJvmInspection {
    public boolean CHECK_ACTIONS = true;
    public boolean IGNORE_NON_PUBLIC = true;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.devkit.inspections.ComponentNotRegisteredInspection");
    private static final Map<ComponentType, RegistrationCheckerUtil.RegistrationType> COMPONENT_TYPE_TO_REGISTRATION_TYPE = ContainerUtil.immutableMapBuilder().put((Object)ComponentType.APPLICATION, (Object)RegistrationCheckerUtil.RegistrationType.APPLICATION_COMPONENT).put((Object)ComponentType.PROJECT, (Object)RegistrationCheckerUtil.RegistrationType.PROJECT_COMPONENT).put((Object)ComponentType.MODULE, (Object)RegistrationCheckerUtil.RegistrationType.MODULE_COMPONENT).build();

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final JCheckBox ignoreNonPublic = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.ignore.non.public", new Object[0]), this.IGNORE_NON_PUBLIC);
        ignoreNonPublic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComponentNotRegisteredInspection.this.IGNORE_NON_PUBLIC = ignoreNonPublic.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.check.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                ComponentNotRegisteredInspection.this.CHECK_ACTIONS = selected = checkJavaActions.isSelected();
                ignoreNonPublic.setEnabled(selected);
            }
        });
        jPanel.add(checkJavaActions);
        jPanel.add(ignoreNonPublic);
        return jPanel;
    }

    @Nullable
    protected JvmElementVisitor<Boolean> buildVisitor(final @NotNull Project project, final @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        if (project == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        return new DefaultJvmElementVisitor<Boolean>(){

            public Boolean visitClass(@NotNull JvmClass clazz) {
                PsiElement sourceElement;
                if (clazz == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!((sourceElement = clazz.getSourceElement()) instanceof PsiClass)) {
                    return null;
                }
                ComponentNotRegisteredInspection.this.checkClass(project, (PsiClass)sourceElement, sink);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection$3", "visitClass"));
            }
        };
    }

    private void checkClass(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (project == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(2);
        }
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(3);
        }
        if (sink == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(4);
        }
        if (checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum() || com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)checkedClass) || !this.shouldCheckActionClass(checkedClass)) {
            return;
        }
        GlobalSearchScope scope = checkedClass.getResolveScope();
        PsiClass actionClass = JavaPsiFacade.getInstance((Project)project).findClass(AnAction.class.getName(), scope);
        if (actionClass == null) {
            return;
        }
        if (checkedClass.isInheritor(actionClass, true)) {
            if (!ComponentNotRegisteredInspection.isActionRegistered(checkedClass) && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                RegisterActionFix fix = new RegisterActionFix(PsiUtil.createPointer(checkedClass));
                sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message("new.menu.action.text", new Object[0])), new LocalQuickFix[]{fix});
            }
            return;
        }
        PsiClass compClass = JavaPsiFacade.getInstance((Project)project).findClass(BaseComponent.class.getName(), scope);
        if (compClass == null) {
            return;
        }
        if (!checkedClass.isInheritor(compClass, true)) {
            return;
        }
        for (ComponentType componentType : ComponentType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)componentType.myClassName)) continue;
            if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, COMPONENT_TYPE_TO_REGISTRATION_TYPE.get((Object)componentType)) != null) {
                return;
            }
            if (!ComponentNotRegisteredInspection.canFix(checkedClass)) {
                return;
            }
            RegisterComponentFix fix = new RegisterComponentFix(componentType, PsiUtil.createPointer(checkedClass));
            sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message(componentType.myPropertyKey, new Object[0])), new LocalQuickFix[]{fix});
        }
    }

    private static PsiClass findRegistrationType(@NotNull PsiClass checkedClass, @NotNull RegistrationCheckerUtil.RegistrationType type) {
        if (checkedClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(5);
        }
        if (type == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(6);
        }
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, type);
        return (PsiClass)ContainerUtil.getFirstItem(types);
    }

    private boolean shouldCheckActionClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(7);
        }
        if (!this.CHECK_ACTIONS) {
            return false;
        }
        return !this.IGNORE_NON_PUBLIC || psiClass.hasModifierProperty("public");
    }

    private static boolean isActionRegistered(@NotNull PsiClass actionClass) {
        PsiClass registrationType;
        if (actionClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(8);
        }
        if ((registrationType = ComponentNotRegisteredInspection.findRegistrationType(actionClass, RegistrationCheckerUtil.RegistrationType.ACTION)) != null) {
            return true;
        }
        for (PsiMethod method : actionClass.getConstructors()) {
            Query search = MethodReferencesSearch.search((PsiMethod)method);
            if (search.findFirst() == null) continue;
            return true;
        }
        Query search = ReferencesSearch.search((PsiElement)actionClass);
        for (PsiReference reference : search) {
            PsiJavaCodeReferenceElement classReference;
            PsiNewExpression newExpression;
            if (!(reference instanceof PsiJavaCodeReferenceElement) || (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiNewExpression.class)) == null || (classReference = newExpression.getClassReference()) == null || !classReference.getQualifiedName().equals(actionClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canFix(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ComponentNotRegisteredInspection.$$$reportNull$$$0(9);
        }
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        return PluginModuleType.isPluginModuleOrDependency(module) || module != null && PsiUtil.isPluginModule(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/ComponentNotRegisteredInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findRegistrationType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCheckActionClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isActionRegistered";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

