/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.dom.index.RegistrationIndexer;

public class IdeaPluginRegistrationIndex
extends FileBasedIndexExtension<String, List<RegistrationEntry>>
implements PsiDependentIndex {
    private static final int INDEX_VERSION = 1;
    private static final ID<String, List<RegistrationEntry>> NAME = ID.create((String)"IdeaPluginRegistrationIndex");
    private final DataExternalizer<List<RegistrationEntry>> myValueExternalizer = new DataExternalizer<List<RegistrationEntry>>(){

        public void save(@NotNull DataOutput out, List<RegistrationEntry> values) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, values, entry -> {
                if (out == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getRegistrationType().ordinal());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            });
        }

        public List<RegistrationEntry> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                if (in == null) {
                    1.$$$reportNull$$$0(2);
                }
                RegistrationEntry.RegistrationType type = RegistrationEntry.RegistrationType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                return new RegistrationEntry(type, offset);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$read$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$save$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, List<RegistrationEntry>> getName() {
        ID<String, List<RegistrationEntry>> iD = NAME;
        if (iD == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, List<RegistrationEntry>, FileContent> getIndexer() {
        DataIndexer<String, List<RegistrationEntry>, FileContent> dataIndexer = new DataIndexer<String, List<RegistrationEntry>, FileContent>(){

            @NotNull
            public Map<String, List<RegistrationEntry>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                Map<String, List<RegistrationEntry>> map = new RegistrationIndexer(inputData).indexFile();
                if (map == null) {
                    2.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<RegistrationEntry>> getValueExternalizer() {
        DataExternalizer<List<RegistrationEntry>> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML});
        if (defaultFileTypeSpecificInputFilter == null) {
            IdeaPluginRegistrationIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static boolean isRegisteredApplicationComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
    }

    public static boolean isRegisteredProjectComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
    }

    public static boolean isRegisteredModuleComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    public static boolean isRegisteredAction(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegistered(psiClass, scope, RegistrationEntry.RegistrationType.ACTION);
    }

    private static boolean isRegistered(PsiClass psiClass, GlobalSearchScope scope, RegistrationEntry.RegistrationType type) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)qualifiedName, null, (file, value) -> ContainerUtil.process((List)value, entry -> entry.getRegistrationType() != type), scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/dom/index/IdeaPluginRegistrationIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

