/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;

public class IdeaPluginConverter
extends ResolvingConverter<IdeaPlugin> {
    private static final Condition<IdeaPlugin> NON_CORE_PLUGINS = plugin -> !"com.intellij".equals(plugin.getPluginId());

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPluginsWithoutSelf(context);
        List list = ContainerUtil.filter(plugins, NON_CORE_PLUGINS);
        if (list == null) {
            IdeaPluginConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            IdeaPluginConverter.$$$reportNull$$$0(1);
        }
        THashSet result = new THashSet();
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            for (PluginModule module : ideaPlugin.getModules()) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)module.getValue().getValue());
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            IdeaPluginConverter.$$$reportNull$$$0(2);
        }
        return tHashSet;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("error.cannot.resolve.plugin", s);
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, ConvertContext context) {
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            String otherId = ideaPlugin.getPluginId();
            if (otherId == null) continue;
            if (otherId.equals(s)) {
                return ideaPlugin;
            }
            for (PluginModule module : ideaPlugin.getModules()) {
                String moduleName = (String)module.getValue().getValue();
                if (moduleName == null || !moduleName.equals(s)) continue;
                return ideaPlugin;
            }
        }
        return null;
    }

    public String toString(@Nullable IdeaPlugin ideaPlugin, ConvertContext context) {
        return ideaPlugin != null ? ideaPlugin.getPluginId() : null;
    }

    private static Collection<IdeaPlugin> getAllPluginsWithoutSelf(ConvertContext context) {
        IdeaPlugin self = (IdeaPlugin)context.getInvocationElement().getParentOfType(IdeaPlugin.class, true);
        if (self == null) {
            return Collections.emptyList();
        }
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPlugins(context.getProject());
        return ContainerUtil.filter(plugins, plugin -> !Comparing.strEqual((String)self.getPluginId(), (String)plugin.getPluginId()));
    }

    public static Collection<IdeaPlugin> getAllPlugins(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
            return CachedValueProvider.Result.create(IdeaPluginConverter.getPlugins(project, scope), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static Collection<IdeaPlugin> getPlugins(Project project, GlobalSearchScope scope) {
        if (DumbService.isDumb((Project)project)) {
            List<IdeaPlugin> list = Collections.emptyList();
            if (list == null) {
                IdeaPluginConverter.$$$reportNull$$$0(3);
            }
            return list;
        }
        List files = DomService.getInstance().getFileElements(IdeaPlugin.class, project, scope);
        List list = ContainerUtil.map((Collection)files, ideaPluginDomFileElement -> (IdeaPlugin)ideaPluginDomFileElement.getRootElement());
        if (list == null) {
            IdeaPluginConverter.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/IdeaPluginConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

