/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.DomImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverter;

public class ActionOrGroupResolveConverter
extends ResolvingConverter<ActionOrGroup> {
    @NotNull
    public Collection<? extends ActionOrGroup> getVariants(ConvertContext context) {
        ArrayList variants = new ArrayList();
        PairProcessor collectProcessor = (s, actionOrGroup) -> {
            if (this.isRelevant((ActionOrGroup)actionOrGroup)) {
                variants.add(actionOrGroup);
            }
            return true;
        };
        ActionOrGroupResolveConverter.processActionOrGroup(context, (PairProcessor<String, ActionOrGroup>)collectProcessor);
        ArrayList arrayList = variants;
        if (arrayList == null) {
            ActionOrGroupResolveConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable ActionOrGroup resolvedValue) {
        if (resolvedValue == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)resolvedValue);
        return target == null ? super.getPsiElement((Object)resolvedValue) : PomService.convertToPsi((PsiTarget)target);
    }

    @Nullable
    public ActionOrGroup fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        ActionOrGroup[] result = new ActionOrGroup[]{null};
        PairProcessor findProcessor = (s, actionOrGroup) -> {
            if (this.isRelevant((ActionOrGroup)actionOrGroup) && Comparing.strEqual((String)value, (String)s)) {
                result[0] = actionOrGroup;
                return false;
            }
            return true;
        };
        ActionOrGroupResolveConverter.processActionOrGroup(context, (PairProcessor<String, ActionOrGroup>)findProcessor);
        return result[0];
    }

    @Nullable
    public String toString(@Nullable ActionOrGroup actionGroup, ConvertContext context) {
        return actionGroup == null ? null : ActionOrGroupResolveConverter.getName(actionGroup);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return "Cannot resolve action or group '" + s + "'";
    }

    @Nullable
    public LookupElement createLookupElement(ActionOrGroup actionOrGroup) {
        if (actionOrGroup instanceof Action) {
            Action action = (Action)actionOrGroup;
            String msg = action.getId().getStringValue() + " in " + DomUtil.getFile((DomElement)action) + " " + action.isValid() + " ";
            DomImplUtil.assertValidity((DomElement)action, (String)msg);
            PsiElement element = this.getPsiElement(actionOrGroup);
            if (element == null) {
                throw new IllegalStateException("no PSI: " + msg);
            }
            LookupElementBuilder builder = LookupElementBuilder.create((Object)ObjectUtils.assertNotNull((Object)element), (String)((String)ObjectUtils.assertNotNull((Object)ActionOrGroupResolveConverter.getName(action))));
            String text = action.getText().getStringValue();
            if (StringUtil.isNotEmpty((String)text)) {
                String withoutMnemonic = StringUtil.replace((String)text, (String)"_", (String)"");
                builder = builder.withTailText(" \"" + withoutMnemonic + "\"", true);
            }
            return builder;
        }
        return super.createLookupElement((Object)actionOrGroup);
    }

    protected boolean isRelevant(ActionOrGroup actionOrGroup) {
        return true;
    }

    private static boolean processActionOrGroup(ConvertContext context, PairProcessor<String, ActionOrGroup> processor) {
        Project project = context.getProject();
        Module module = context.getModule();
        if (module == null) {
            Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPlugins(project);
            return ActionOrGroupResolveConverter.processPlugins(plugins, processor);
        }
        return ModuleUtilCore.visitMeAndDependentModules((Module)module, module1 -> {
            Collection<IdeaPlugin> dependenciesAndLibs = IdeaPluginConverter.getPlugins(project, module1.getModuleRuntimeScope(false));
            return ActionOrGroupResolveConverter.processPlugins(dependenciesAndLibs, processor);
        });
    }

    private static boolean processPlugins(Collection<IdeaPlugin> plugins, PairProcessor<String, ActionOrGroup> processor) {
        for (IdeaPlugin plugin : plugins) {
            Map<String, ActionOrGroup> forFile = ActionOrGroupResolveConverter.collectForFile(plugin);
            for (Map.Entry<String, ActionOrGroup> entry : forFile.entrySet()) {
                if (processor.process((Object)entry.getKey(), (Object)entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, ActionOrGroup> collectForFile(IdeaPlugin plugin) {
        XmlFile xmlFile = DomUtil.getFile((DomElement)plugin);
        return (Map)CachedValuesManager.getCachedValue((PsiElement)xmlFile, () -> {
            HashMap<String, ActionOrGroup> result = new HashMap<String, ActionOrGroup>();
            for (Actions actions : plugin.getActions()) {
                ActionOrGroupResolveConverter.collectRecursive(result, actions);
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{xmlFile});
        });
    }

    private static void collectRecursive(Map<String, ActionOrGroup> result, Actions actions) {
        String name;
        for (Action action : actions.getActions()) {
            name = ActionOrGroupResolveConverter.getName(action);
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            result.put(name, action);
        }
        for (Group group : actions.getGroups()) {
            name = ActionOrGroupResolveConverter.getName(group);
            if (!StringUtil.isEmptyOrSpaces((String)name)) {
                result.put(name, group);
            }
            ActionOrGroupResolveConverter.collectRecursive(result, group);
        }
    }

    @Nullable
    private static String getName(@NotNull ActionOrGroup actionOrGroup) {
        if (actionOrGroup == null) {
            ActionOrGroupResolveConverter.$$$reportNull$$$0(1);
        }
        return ElementPresentationManager.getElementName((Object)actionOrGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ActionOrGroupResolveConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ActionOrGroupResolveConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OnlyGroups
    extends ActionOrGroupResolveConverter {
        @Override
        protected boolean isRelevant(ActionOrGroup actionOrGroup) {
            return actionOrGroup instanceof Group;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return "Cannot resolve group '" + s + "'";
        }
    }

    public static class OnlyActions
    extends ActionOrGroupResolveConverter {
        @Override
        protected boolean isRelevant(ActionOrGroup actionOrGroup) {
            return actionOrGroup instanceof Action;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return "Cannot resolve action '" + s + "'";
        }
    }
}

