/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.codeStyle.bean;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.codeStyle.bean.CodeStyleBeanAccessorGenerator;

public class CodeStyleBeanGenerator {
    private final PsiFile myFile;
    private final PsiClass myBeanClass;
    private final Language myLanguage;
    private final Set<String> myImports;

    public CodeStyleBeanGenerator(@NotNull PsiFile file, @NotNull PsiClass aClass, @NotNull Language language) {
        if (file == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(2);
        }
        this.myImports = ContainerUtil.newHashSet();
        this.myFile = file;
        this.myBeanClass = aClass;
        this.myLanguage = language;
    }

    public String generateBeanMethods() {
        StringBuilder sb = new StringBuilder();
        this.generateMethodsFor(CommonCodeStyleSettings.IndentOptions.class, sb, this.getSupportedIndentOptions());
        this.generateMethodsFor(CommonCodeStyleSettings.class, sb, this.getSupportedFields());
        for (CustomCodeStyleSettings customSettings : this.getCustomSettings()) {
            this.generateMethodsFor(customSettings.getClass(), sb, null);
        }
        return sb.toString();
    }

    private Set<String> getSupportedIndentOptions() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.myLanguage);
        if (provider == null) {
            return Collections.emptySet();
        }
        HashSet indentOptions = ContainerUtil.newHashSet();
        IndentOptionsEditor editor = provider.getIndentOptionsEditor();
        if (editor != null) {
            indentOptions.add("TAB_SIZE");
            indentOptions.add("USE_TAB_CHARACTER");
            indentOptions.add("INDENT_SIZE");
            if (editor instanceof SmartIndentOptionsEditor) {
                indentOptions.add("CONTINUATION_INDENT_SIZE");
                indentOptions.add("SMART_TABS");
                indentOptions.add("KEEP_INDENTS_ON_EMPTY_LINES");
            }
        }
        return indentOptions;
    }

    private Set<String> getSupportedFields() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.myLanguage);
        return provider == null ? Collections.emptySet() : provider.getSupportedFields();
    }

    private void generateMethodsFor(Class codeStyleClass, StringBuilder output, @Nullable Set<String> supportedFields) {
        for (Field field : CodeStyleBeanGenerator.getCodeStyleFields(codeStyleClass)) {
            CodeStyleBeanAccessorGenerator accessorGenerator = new CodeStyleBeanAccessorGenerator(field);
            String fieldName = field.getName();
            if ((supportedFields == null || supportedFields.contains(fieldName)) && !this.beanContainsField(fieldName) && accessorGenerator.isFieldSupported()) {
                String getterName;
                String setterName = accessorGenerator.getSetterName();
                if (!this.superClassContainsMethod(setterName)) {
                    accessorGenerator.generateGetter(output);
                }
                if (!this.superClassContainsMethod(getterName = accessorGenerator.getGetterName())) {
                    accessorGenerator.generateSetter(output);
                }
            }
            this.myImports.addAll(accessorGenerator.getImports());
        }
    }

    private static List<Field> getCodeStyleFields(Class codeStyleClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : codeStyleClass.getFields()) {
            if (!CodeStyleBeanGenerator.isPublic(field) || CodeStyleBeanGenerator.isFinal(field)) continue;
            fields.add(field);
        }
        return fields;
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    private boolean beanContainsField(@NotNull String fieldName) {
        PsiMethod[] methods;
        if (fieldName == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(3);
        }
        for (PsiMethod method : methods = this.myBeanClass.getMethods()) {
            if (!CodeStyleBeanGenerator.methodContainsField(method, fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean superClassContainsMethod(@NotNull String methodName) {
        PsiClass superClass;
        if (methodName == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(4);
        }
        if ((superClass = this.myBeanClass.getSuperClass()) != null) {
            for (PsiMethod baseMethod : superClass.getMethods()) {
                if (!methodName.equals(baseMethod.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean methodContainsField(@NotNull PsiMethod method, final @NotNull String fieldName) {
        if (method == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(6);
        }
        final Ref found = Ref.create((Object)false);
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiIdentifier && fieldName.equals(element.getText())) {
                    found.set((Object)true);
                } else {
                    super.visitElement(element);
                }
            }
        };
        method.accept((PsiElementVisitor)visitor);
        return (Boolean)found.get();
    }

    private List<CustomCodeStyleSettings> getCustomSettings() {
        CodeStyleSettings rootSettings = new CodeStyleSettings();
        ArrayList<CustomCodeStyleSettings> customSettingsList = new ArrayList<CustomCodeStyleSettings>();
        for (CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
            CustomCodeStyleSettings customSettings;
            if (provider.getLanguage() != this.myLanguage || (customSettings = provider.createCustomSettings(rootSettings)) == null || CodeStyleBeanGenerator.resolveClass(customSettings.getClass().getName(), this.myFile) == null) continue;
            customSettingsList.add(customSettings);
        }
        return customSettingsList;
    }

    @Nullable
    static PsiClass resolveClass(@NotNull String classFQN, @NotNull PsiFile file) {
        if (classFQN == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CodeStyleBeanGenerator.$$$reportNull$$$0(8);
        }
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)file.getProject());
        return resolveHelper.resolveReferencedClass(classFQN, (PsiElement)file);
    }

    Set<String> getImports() {
        return this.myImports;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/codeStyle/bean/CodeStyleBeanGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beanContainsField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "superClassContainsMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "methodContainsField";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

