/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.gradle.model.impl.GradleResourceFileFilter;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;

public class GradleResourceRootDescriptor
extends BuildRootDescriptor {
    private final GradleResourcesTarget myTarget;
    private final ResourceRootConfiguration myConfig;
    private final File myFile;
    private final String myId;
    private final boolean myOverwrite;
    private final int myIndexInPom;

    public GradleResourceRootDescriptor(@NotNull GradleResourcesTarget target, ResourceRootConfiguration config, int indexInPom, boolean overwrite) {
        if (target == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(0);
        }
        this.myTarget = target;
        this.myConfig = config;
        String path = FileUtil.toCanonicalPath((String)config.directory);
        this.myFile = new File(path);
        this.myId = path;
        this.myIndexInPom = indexInPom;
        this.myOverwrite = overwrite;
    }

    public ResourceRootConfiguration getConfiguration() {
        return this.myConfig;
    }

    public String getRootId() {
        return this.myId;
    }

    public File getRootFile() {
        return this.myFile;
    }

    public GradleResourcesTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public FileFilter createFileFilter() {
        GradleResourceFileFilter gradleResourceFileFilter = new GradleResourceFileFilter(this.myFile, this.myConfig);
        if (gradleResourceFileFilter == null) {
            GradleResourceRootDescriptor.$$$reportNull$$$0(1);
        }
        return gradleResourceFileFilter;
    }

    public boolean canUseFileCache() {
        return true;
    }

    public int getIndexInPom() {
        return this.myIndexInPom;
    }

    public boolean isOverwrite() {
        return this.myOverwrite;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gradle/model/impl/GradleResourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gradle/model/impl/GradleResourceRootDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

