/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Base64;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.artifacts.JpsGradleArtifactExtension;
import org.jetbrains.jps.gradle.model.impl.artifacts.GradleArtifactExtensionProperties;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;

public class GradleArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        JpsGradleArtifactExtension extension;
        if (artifact == null) {
            GradleArtifactBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            GradleArtifactBuildTaskProvider.$$$reportNull$$$0(1);
        }
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && artifactName.endsWith(" (exploded)") && artifact.getRootElement() instanceof JpsArtifactRootElement && (extension = GradleArtifactBuildTaskProvider.getArtifactExtension(artifact, buildPhase)) != null && extension.getProperties() != null) {
            List list = ContainerUtil.list((Object[])new GradleGenerationBuildTask[]{new GradleManifestGenerationBuildTask(artifact, extension.getProperties()), new GradleAdditionalFilesGenerationBuildTask(artifact, extension.getProperties())});
            if (list == null) {
                GradleArtifactBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            GradleArtifactBuildTaskProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static JpsGradleArtifactExtension getArtifactExtension(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        switch (buildPhase) {
            case PRE_PROCESSING: {
                return JpsGradleExtensionService.getArtifactExtension(artifact);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleAdditionalFilesGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleAdditionalFilesGenerationBuildTask.class);

        public GradleAdditionalFilesGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                GradleAdditionalFilesGenerationBuildTask.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                GradleAdditionalFilesGenerationBuildTask.$$$reportNull$$$0(1);
            }
            super(artifact, properties);
        }

        public void build(CompileContext context) {
            if (this.myProperties.additionalFiles != null) {
                for (Map.Entry<String, String> entry : this.myProperties.additionalFiles.entrySet()) {
                    try {
                        File output = new File(entry.getKey());
                        FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)entry.getValue()));
                    }
                    catch (Exception e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleAdditionalFilesGenerationBuildTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GradleManifestGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleManifestGenerationBuildTask.class);

        public GradleManifestGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                GradleManifestGenerationBuildTask.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                GradleManifestGenerationBuildTask.$$$reportNull$$$0(1);
            }
            super(artifact, properties);
        }

        public void build(CompileContext context) {
            if (this.myProperties.manifest != null) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)this.myProperties.manifest));
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleManifestGenerationBuildTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class GradleGenerationBuildTask
    extends BuildTask {
        protected final JpsArtifact myArtifact;
        protected final GradleArtifactExtensionProperties myProperties;

        public GradleGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                GradleGenerationBuildTask.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                GradleGenerationBuildTask.$$$reportNull$$$0(1);
            }
            this.myArtifact = artifact;
            this.myProperties = properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "properties";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleGenerationBuildTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

